
package org.bidib.jbidib.decoder.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "id",
    "name",
    "firmware",
    "manufacturer",
    "manufacturerExtendedId",
    "producedFrom",
    "type",
    "metadata",
    "typeid"
})
@Generated("jsonschema2pojo")
public class Decoder {

    /**
     * id
     * (Required)
     * 
     */
    @JsonProperty("id")
    @JsonPropertyDescription("id")
    @NotNull
    private String id;
    /**
     * id
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("id")
    @NotNull
    private String name;
    @JsonProperty("firmware")
    @Valid
    private Firmware firmware;
    /**
     * TODO
     * 
     */
    @JsonProperty("manufacturer")
    @JsonPropertyDescription("TODO")
    private String manufacturer;
    /**
     * TODO
     * 
     */
    @JsonProperty("manufacturerExtendedId")
    @JsonPropertyDescription("TODO")
    private String manufacturerExtendedId;
    /**
     * TODO
     * 
     */
    @JsonProperty("producedFrom")
    @JsonPropertyDescription("TODO")
    private String producedFrom;
    /**
     * type
     * 
     */
    @JsonProperty("type")
    @JsonPropertyDescription("type")
    private Decoder.Type type;
    @JsonProperty("metadata")
    @Valid
    private Metadata metadata;
    @JsonProperty("typeid")
    @Size(min = 0)
    @Valid
    private List<String> typeid = new ArrayList<String>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public Decoder() {
    }

    /**
     * 
     * @param manufacturerExtendedId
     *     TODO.
     * @param name
     *     id.
     * @param id
     *     id.
     * @param type
     *     type.
     * @param manufacturer
     *     TODO.
     * @param producedFrom
     *     TODO.
     */
    public Decoder(String id, String name, Firmware firmware, String manufacturer, String manufacturerExtendedId, String producedFrom, Decoder.Type type, Metadata metadata, List<String> typeid) {
        super();
        this.id = id;
        this.name = name;
        this.firmware = firmware;
        this.manufacturer = manufacturer;
        this.manufacturerExtendedId = manufacturerExtendedId;
        this.producedFrom = producedFrom;
        this.type = type;
        this.metadata = metadata;
        this.typeid = typeid;
    }

    /**
     * id
     * (Required)
     * 
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * id
     * (Required)
     * 
     */
    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public Decoder withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * id
     * (Required)
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * id
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Decoder withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("firmware")
    public Firmware getFirmware() {
        return firmware;
    }

    @JsonProperty("firmware")
    public void setFirmware(Firmware firmware) {
        this.firmware = firmware;
    }

    public Decoder withFirmware(Firmware firmware) {
        this.firmware = firmware;
        return this;
    }

    /**
     * TODO
     * 
     */
    @JsonProperty("manufacturer")
    public String getManufacturer() {
        return manufacturer;
    }

    /**
     * TODO
     * 
     */
    @JsonProperty("manufacturer")
    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public Decoder withManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
        return this;
    }

    /**
     * TODO
     * 
     */
    @JsonProperty("manufacturerExtendedId")
    public String getManufacturerExtendedId() {
        return manufacturerExtendedId;
    }

    /**
     * TODO
     * 
     */
    @JsonProperty("manufacturerExtendedId")
    public void setManufacturerExtendedId(String manufacturerExtendedId) {
        this.manufacturerExtendedId = manufacturerExtendedId;
    }

    public Decoder withManufacturerExtendedId(String manufacturerExtendedId) {
        this.manufacturerExtendedId = manufacturerExtendedId;
        return this;
    }

    /**
     * TODO
     * 
     */
    @JsonProperty("producedFrom")
    public String getProducedFrom() {
        return producedFrom;
    }

    /**
     * TODO
     * 
     */
    @JsonProperty("producedFrom")
    public void setProducedFrom(String producedFrom) {
        this.producedFrom = producedFrom;
    }

    public Decoder withProducedFrom(String producedFrom) {
        this.producedFrom = producedFrom;
        return this;
    }

    /**
     * type
     * 
     */
    @JsonProperty("type")
    public Decoder.Type getType() {
        return type;
    }

    /**
     * type
     * 
     */
    @JsonProperty("type")
    public void setType(Decoder.Type type) {
        this.type = type;
    }

    public Decoder withType(Decoder.Type type) {
        this.type = type;
        return this;
    }

    @JsonProperty("metadata")
    public Metadata getMetadata() {
        return metadata;
    }

    @JsonProperty("metadata")
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Decoder withMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonProperty("typeid")
    public List<String> getTypeid() {
        return typeid;
    }

    @JsonProperty("typeid")
    public void setTypeid(List<String> typeid) {
        this.typeid = typeid;
    }

    public Decoder withTypeid(List<String> typeid) {
        this.typeid = typeid;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Decoder.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("firmware");
        sb.append('=');
        sb.append(((this.firmware == null)?"<null>":this.firmware));
        sb.append(',');
        sb.append("manufacturer");
        sb.append('=');
        sb.append(((this.manufacturer == null)?"<null>":this.manufacturer));
        sb.append(',');
        sb.append("manufacturerExtendedId");
        sb.append('=');
        sb.append(((this.manufacturerExtendedId == null)?"<null>":this.manufacturerExtendedId));
        sb.append(',');
        sb.append("producedFrom");
        sb.append('=');
        sb.append(((this.producedFrom == null)?"<null>":this.producedFrom));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("metadata");
        sb.append('=');
        sb.append(((this.metadata == null)?"<null>":this.metadata));
        sb.append(',');
        sb.append("typeid");
        sb.append('=');
        sb.append(((this.typeid == null)?"<null>":this.typeid));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.manufacturerExtendedId == null)? 0 :this.manufacturerExtendedId.hashCode()));
        result = ((result* 31)+((this.metadata == null)? 0 :this.metadata.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.typeid == null)? 0 :this.typeid.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.firmware == null)? 0 :this.firmware.hashCode()));
        result = ((result* 31)+((this.manufacturer == null)? 0 :this.manufacturer.hashCode()));
        result = ((result* 31)+((this.producedFrom == null)? 0 :this.producedFrom.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Decoder) == false) {
            return false;
        }
        Decoder rhs = ((Decoder) other);
        return ((((((((((this.manufacturerExtendedId == rhs.manufacturerExtendedId)||((this.manufacturerExtendedId!= null)&&this.manufacturerExtendedId.equals(rhs.manufacturerExtendedId)))&&((this.metadata == rhs.metadata)||((this.metadata!= null)&&this.metadata.equals(rhs.metadata))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.typeid == rhs.typeid)||((this.typeid!= null)&&this.typeid.equals(rhs.typeid))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.firmware == rhs.firmware)||((this.firmware!= null)&&this.firmware.equals(rhs.firmware))))&&((this.manufacturer == rhs.manufacturer)||((this.manufacturer!= null)&&this.manufacturer.equals(rhs.manufacturer))))&&((this.producedFrom == rhs.producedFrom)||((this.producedFrom!= null)&&this.producedFrom.equals(rhs.producedFrom))));
    }


    /**
     * type
     * 
     */
    @Generated("jsonschema2pojo")
    public enum Type {

        LOCO("loco"),
        LOCO_SOUND("loco-sound"),
        FUNCTION("function"),
        CAR("car"),
        CAR_SOUND("car-sound"),
        SUSI("susi"),
        SUSI_SOUND("susi-sound"),
        STANDARD_ACCESSORY("standardAccessory"),
        EXTENDED_ACCESSORY("extendedAccessory");
        private final String value;
        private final static Map<String, Decoder.Type> CONSTANTS = new HashMap<String, Decoder.Type>();

        static {
            for (Decoder.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Decoder.Type fromValue(String value) {
            Decoder.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
