/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidib.decoder.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "value"})
public class Expression {
    @JsonProperty(value="type")
    private Type type;
    @JsonProperty(value="value")
    private Object value;

    public Expression() {
    }

    public Expression(Type type, Object value) {
        this.type = type;
        this.value = value;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    public Expression withType(Type type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="value")
    public Object getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(Object value) {
        this.value = value;
    }

    public Expression withValue(Object value) {
        this.value = value;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Expression.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(this.value == null ? "<null>" : this.value);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Expression)) {
            return false;
        }
        Expression rhs = (Expression)other;
        return (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.value == rhs.value || this.value != null && this.value.equals(rhs.value));
    }

    public static enum Type {
        COMPARISON("comparison"),
        LOGICAL("logical"),
        VALUE_REFERENCE("valueReference"),
        LITERAL("literal");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

