/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidib.decoder.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.bidib.jbidib.decoder.json.Editor;
import org.bidib.jbidib.decoder.json.Metadata;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"version", "name", "metadata", "typeid", "options", "cv", "editor"})
public class Firmware {
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="id")
    @NotNull
    private String version;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of the firmware")
    private String name;
    @JsonProperty(value="metadata")
    @Valid
    private Metadata metadata;
    @JsonProperty(value="typeid")
    @Size(min=0)
    @Valid
    private @Size(min=0) @Valid List<String> typeid = new ArrayList<String>();
    @JsonProperty(value="options")
    private String options;
    @JsonProperty(value="cv")
    @JsonPropertyDescription(value="The CVs")
    @Valid
    private List<Object> cv = new ArrayList<Object>();
    @JsonProperty(value="editor")
    @JsonPropertyDescription(value="CV editor for one Decoder")
    @Valid
    private Editor editor;

    public Firmware() {
    }

    public Firmware(String version, String name, Metadata metadata, List<String> typeid, String options, List<Object> cv, Editor editor) {
        this.version = version;
        this.name = name;
        this.metadata = metadata;
        this.typeid = typeid;
        this.options = options;
        this.cv = cv;
        this.editor = editor;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    public Firmware withVersion(String version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Firmware withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="metadata")
    public Metadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Firmware withMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonProperty(value="typeid")
    public List<String> getTypeid() {
        return this.typeid;
    }

    @JsonProperty(value="typeid")
    public void setTypeid(List<String> typeid) {
        this.typeid = typeid;
    }

    public Firmware withTypeid(List<String> typeid) {
        this.typeid = typeid;
        return this;
    }

    @JsonProperty(value="options")
    public String getOptions() {
        return this.options;
    }

    @JsonProperty(value="options")
    public void setOptions(String options) {
        this.options = options;
    }

    public Firmware withOptions(String options) {
        this.options = options;
        return this;
    }

    @JsonProperty(value="cv")
    public List<Object> getCv() {
        return this.cv;
    }

    @JsonProperty(value="cv")
    public void setCv(List<Object> cv) {
        this.cv = cv;
    }

    public Firmware withCv(List<Object> cv) {
        this.cv = cv;
        return this;
    }

    @JsonProperty(value="editor")
    public Editor getEditor() {
        return this.editor;
    }

    @JsonProperty(value="editor")
    public void setEditor(Editor editor) {
        this.editor = editor;
    }

    public Firmware withEditor(Editor editor) {
        this.editor = editor;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Firmware.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("metadata");
        sb.append('=');
        sb.append(this.metadata == null ? "<null>" : this.metadata);
        sb.append(',');
        sb.append("typeid");
        sb.append('=');
        sb.append(this.typeid == null ? "<null>" : this.typeid);
        sb.append(',');
        sb.append("options");
        sb.append('=');
        sb.append(this.options == null ? "<null>" : this.options);
        sb.append(',');
        sb.append("cv");
        sb.append('=');
        sb.append(this.cv == null ? "<null>" : this.cv);
        sb.append(',');
        sb.append("editor");
        sb.append('=');
        sb.append(this.editor == null ? "<null>" : this.editor);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.editor == null ? 0 : this.editor.hashCode());
        result = result * 31 + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = result * 31 + (this.cv == null ? 0 : this.cv.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.options == null ? 0 : this.options.hashCode());
        result = result * 31 + (this.typeid == null ? 0 : this.typeid.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Firmware)) {
            return false;
        }
        Firmware rhs = (Firmware)other;
        return (this.editor == rhs.editor || this.editor != null && this.editor.equals(rhs.editor)) && (this.metadata == rhs.metadata || this.metadata != null && this.metadata.equals(rhs.metadata)) && (this.cv == rhs.cv || this.cv != null && this.cv.equals(rhs.cv)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.options == rhs.options || this.options != null && this.options.equals(rhs.options)) && (this.typeid == rhs.typeid || this.typeid != null && this.typeid.equals(rhs.typeid)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version));
    }
}

