
package org.bidib.jbidib.decoder.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "id",
    "typename",
    "type",
    "mode",
    "cv"
})
@Generated("jsonschema2pojo")
public class Cvgroup {

    /**
     * id
     * (Required)
     * 
     */
    @JsonProperty("id")
    @JsonPropertyDescription("id")
    @NotNull
    private String id;
    /**
     * typename
     * 
     */
    @JsonProperty("typename")
    @JsonPropertyDescription("typename")
    private String typename;
    /**
     * type
     * 
     */
    @JsonProperty("type")
    @JsonPropertyDescription("type")
    private Cvgroup.Type type;
    /**
     * mode
     * 
     */
    @JsonProperty("mode")
    @JsonPropertyDescription("mode")
    private String mode;
    @JsonProperty("cv")
    @Valid
    private List<Cv> cv = new ArrayList<Cv>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public Cvgroup() {
    }

    /**
     * 
     * @param mode
     *     mode.
     * @param id
     *     id.
     * @param type
     *     type.
     * @param typename
     *     typename.
     */
    public Cvgroup(String id, String typename, Cvgroup.Type type, String mode, List<Cv> cv) {
        super();
        this.id = id;
        this.typename = typename;
        this.type = type;
        this.mode = mode;
        this.cv = cv;
    }

    /**
     * id
     * (Required)
     * 
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * id
     * (Required)
     * 
     */
    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public Cvgroup withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * typename
     * 
     */
    @JsonProperty("typename")
    public String getTypename() {
        return typename;
    }

    /**
     * typename
     * 
     */
    @JsonProperty("typename")
    public void setTypename(String typename) {
        this.typename = typename;
    }

    public Cvgroup withTypename(String typename) {
        this.typename = typename;
        return this;
    }

    /**
     * type
     * 
     */
    @JsonProperty("type")
    public Cvgroup.Type getType() {
        return type;
    }

    /**
     * type
     * 
     */
    @JsonProperty("type")
    public void setType(Cvgroup.Type type) {
        this.type = type;
    }

    public Cvgroup withType(Cvgroup.Type type) {
        this.type = type;
        return this;
    }

    /**
     * mode
     * 
     */
    @JsonProperty("mode")
    public String getMode() {
        return mode;
    }

    /**
     * mode
     * 
     */
    @JsonProperty("mode")
    public void setMode(String mode) {
        this.mode = mode;
    }

    public Cvgroup withMode(String mode) {
        this.mode = mode;
        return this;
    }

    @JsonProperty("cv")
    public List<Cv> getCv() {
        return cv;
    }

    @JsonProperty("cv")
    public void setCv(List<Cv> cv) {
        this.cv = cv;
    }

    public Cvgroup withCv(List<Cv> cv) {
        this.cv = cv;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Cvgroup.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("typename");
        sb.append('=');
        sb.append(((this.typename == null)?"<null>":this.typename));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("mode");
        sb.append('=');
        sb.append(((this.mode == null)?"<null>":this.mode));
        sb.append(',');
        sb.append("cv");
        sb.append('=');
        sb.append(((this.cv == null)?"<null>":this.cv));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.mode == null)? 0 :this.mode.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.cv == null)? 0 :this.cv.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.typename == null)? 0 :this.typename.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Cvgroup) == false) {
            return false;
        }
        Cvgroup rhs = ((Cvgroup) other);
        return ((((((this.mode == rhs.mode)||((this.mode!= null)&&this.mode.equals(rhs.mode)))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.cv == rhs.cv)||((this.cv!= null)&&this.cv.equals(rhs.cv))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.typename == rhs.typename)||((this.typename!= null)&&this.typename.equals(rhs.typename))));
    }


    /**
     * type
     * 
     */
    @Generated("jsonschema2pojo")
    public enum Type {

        LIST("list"),
        DCC_LONG_ADDR("dccLongAddr"),
        DCC_SPEED_CURVE("dccSpeedCurve"),
        DCC_ACC_ADDR("dccAccAddr"),
        INT("int"),
        LONG("long"),
        MATRIX("matrix"),
        STRING("string"),
        DCC_ADDR_RG("dccAddrRG"),
        DCC_LONG_CONSIST("dccLongConsist"),
        RGB_COLOR("rgbColor"),
        CENTESIMAL_INT("centesimalInt");
        private final String value;
        private final static Map<String, Cvgroup.Type> CONSTANTS = new HashMap<String, Cvgroup.Type>();

        static {
            for (Cvgroup.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Cvgroup.Type fromValue(String value) {
            Cvgroup.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
