
package org.bidib.jbidib.decoder.json;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.Generated;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * The CV Object
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "id",
    "typename",
    "value",
    "cvAddress",
    "type",
    "mode",
    "possibleValues",
    "metadata"
})
@Generated("jsonschema2pojo")
public class Cv {

    /**
     * id
     * (Required)
     * 
     */
    @JsonProperty("id")
    @JsonPropertyDescription("id")
    @NotNull
    private String id;
    /**
     * typename
     * 
     */
    @JsonProperty("typename")
    @JsonPropertyDescription("typename")
    private String typename;
    /**
     * value or null
     * 
     */
    @JsonProperty("value")
    @JsonPropertyDescription("value or null")
    private Double value;
    @JsonProperty("cvAddress")
    @Valid
    private CvAddress cvAddress;
    /**
     * type
     * (Required)
     * 
     */
    @JsonProperty("type")
    @JsonPropertyDescription("type")
    @NotNull
    private Cv.Type type;
    /**
     * mode
     * (Required)
     * 
     */
    @JsonProperty("mode")
    @JsonPropertyDescription("mode")
    @NotNull
    private Cv.Mode mode;
    /**
     * Possible values. TODO: maybe seperate Object?
     * 
     */
    @JsonProperty("possibleValues")
    @JsonPropertyDescription("Possible values. TODO: maybe seperate Object?")
    private String possibleValues;
    @JsonProperty("metadata")
    @Valid
    private Metadata metadata;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Cv() {
    }

    /**
     * 
     * @param mode
     *     mode.
     * @param possibleValues
     *     Possible values. TODO: maybe seperate Object?.
     * @param metadata
     *     metadata.
     * @param id
     *     id.
     * @param type
     *     type.
     * @param value
     *     value or null.
     * @param typename
     *     typename.
     */
    public Cv(String id, String typename, Double value, CvAddress cvAddress, Cv.Type type, Cv.Mode mode, String possibleValues, Metadata metadata) {
        super();
        this.id = id;
        this.typename = typename;
        this.value = value;
        this.cvAddress = cvAddress;
        this.type = type;
        this.mode = mode;
        this.possibleValues = possibleValues;
        this.metadata = metadata;
    }

    /**
     * id
     * (Required)
     * 
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * id
     * (Required)
     * 
     */
    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public Cv withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * typename
     * 
     */
    @JsonProperty("typename")
    public String getTypename() {
        return typename;
    }

    /**
     * typename
     * 
     */
    @JsonProperty("typename")
    public void setTypename(String typename) {
        this.typename = typename;
    }

    public Cv withTypename(String typename) {
        this.typename = typename;
        return this;
    }

    /**
     * value or null
     * 
     */
    @JsonProperty("value")
    public Double getValue() {
        return value;
    }

    /**
     * value or null
     * 
     */
    @JsonProperty("value")
    public void setValue(Double value) {
        this.value = value;
    }

    public Cv withValue(Double value) {
        this.value = value;
        return this;
    }

    @JsonProperty("cvAddress")
    public CvAddress getCvAddress() {
        return cvAddress;
    }

    @JsonProperty("cvAddress")
    public void setCvAddress(CvAddress cvAddress) {
        this.cvAddress = cvAddress;
    }

    public Cv withCvAddress(CvAddress cvAddress) {
        this.cvAddress = cvAddress;
        return this;
    }

    /**
     * type
     * (Required)
     * 
     */
    @JsonProperty("type")
    public Cv.Type getType() {
        return type;
    }

    /**
     * type
     * (Required)
     * 
     */
    @JsonProperty("type")
    public void setType(Cv.Type type) {
        this.type = type;
    }

    public Cv withType(Cv.Type type) {
        this.type = type;
        return this;
    }

    /**
     * mode
     * (Required)
     * 
     */
    @JsonProperty("mode")
    public Cv.Mode getMode() {
        return mode;
    }

    /**
     * mode
     * (Required)
     * 
     */
    @JsonProperty("mode")
    public void setMode(Cv.Mode mode) {
        this.mode = mode;
    }

    public Cv withMode(Cv.Mode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Possible values. TODO: maybe seperate Object?
     * 
     */
    @JsonProperty("possibleValues")
    public String getPossibleValues() {
        return possibleValues;
    }

    /**
     * Possible values. TODO: maybe seperate Object?
     * 
     */
    @JsonProperty("possibleValues")
    public void setPossibleValues(String possibleValues) {
        this.possibleValues = possibleValues;
    }

    public Cv withPossibleValues(String possibleValues) {
        this.possibleValues = possibleValues;
        return this;
    }

    @JsonProperty("metadata")
    public Metadata getMetadata() {
        return metadata;
    }

    @JsonProperty("metadata")
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Cv withMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Cv.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("typename");
        sb.append('=');
        sb.append(((this.typename == null)?"<null>":this.typename));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("cvAddress");
        sb.append('=');
        sb.append(((this.cvAddress == null)?"<null>":this.cvAddress));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("mode");
        sb.append('=');
        sb.append(((this.mode == null)?"<null>":this.mode));
        sb.append(',');
        sb.append("possibleValues");
        sb.append('=');
        sb.append(((this.possibleValues == null)?"<null>":this.possibleValues));
        sb.append(',');
        sb.append("metadata");
        sb.append('=');
        sb.append(((this.metadata == null)?"<null>":this.metadata));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.cvAddress == null)? 0 :this.cvAddress.hashCode()));
        result = ((result* 31)+((this.mode == null)? 0 :this.mode.hashCode()));
        result = ((result* 31)+((this.possibleValues == null)? 0 :this.possibleValues.hashCode()));
        result = ((result* 31)+((this.metadata == null)? 0 :this.metadata.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        result = ((result* 31)+((this.typename == null)? 0 :this.typename.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Cv) == false) {
            return false;
        }
        Cv rhs = ((Cv) other);
        return (((((((((this.cvAddress == rhs.cvAddress)||((this.cvAddress!= null)&&this.cvAddress.equals(rhs.cvAddress)))&&((this.mode == rhs.mode)||((this.mode!= null)&&this.mode.equals(rhs.mode))))&&((this.possibleValues == rhs.possibleValues)||((this.possibleValues!= null)&&this.possibleValues.equals(rhs.possibleValues))))&&((this.metadata == rhs.metadata)||((this.metadata!= null)&&this.metadata.equals(rhs.metadata))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))))&&((this.typename == rhs.typename)||((this.typename!= null)&&this.typename.equals(rhs.typename))));
    }


    /**
     * mode
     * 
     */
    @Generated("jsonschema2pojo")
    public enum Mode {

        RW("rw"),
        RO("ro"),
        WO("wo");
        private final String value;
        private final static Map<String, Cv.Mode> CONSTANTS = new HashMap<String, Cv.Mode>();

        static {
            for (Cv.Mode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Mode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Cv.Mode fromValue(String value) {
            Cv.Mode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }


    /**
     * type
     * 
     */
    @Generated("jsonschema2pojo")
    public enum Type {

        BYTE("byte"),
        SELECT("select"),
        SINGED_BYTE("singedByte");
        private final String value;
        private final static Map<String, Cv.Type> CONSTANTS = new HashMap<String, Cv.Type>();

        static {
            for (Cv.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Cv.Type fromValue(String value) {
            Cv.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
