/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidib.decoder.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.bidib.jbidib.decoder.json.Condition;
import org.bidib.jbidib.decoder.json.Cv;
import org.bidib.jbidib.decoder.json.Cvgroup;
import org.bidib.jbidib.decoder.json.Step;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "condition", "cvgroup", "cv", "step"})
public class Detection {
    @JsonProperty(value="name")
    @NotNull
    private String name;
    @JsonProperty(value="condition")
    @Valid
    private Condition condition;
    @JsonProperty(value="cvgroup")
    @Valid
    private Cvgroup cvgroup;
    @JsonProperty(value="cv")
    @JsonPropertyDescription(value="The CV Object")
    @Valid
    private Cv cv;
    @JsonProperty(value="step")
    @Valid
    @NotNull
    private List<Step> step = new ArrayList<Step>();

    public Detection() {
    }

    public Detection(String name, Condition condition, Cvgroup cvgroup, Cv cv, List<Step> step) {
        this.name = name;
        this.condition = condition;
        this.cvgroup = cvgroup;
        this.cv = cv;
        this.step = step;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Detection withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="condition")
    public Condition getCondition() {
        return this.condition;
    }

    @JsonProperty(value="condition")
    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public Detection withCondition(Condition condition) {
        this.condition = condition;
        return this;
    }

    @JsonProperty(value="cvgroup")
    public Cvgroup getCvgroup() {
        return this.cvgroup;
    }

    @JsonProperty(value="cvgroup")
    public void setCvgroup(Cvgroup cvgroup) {
        this.cvgroup = cvgroup;
    }

    public Detection withCvgroup(Cvgroup cvgroup) {
        this.cvgroup = cvgroup;
        return this;
    }

    @JsonProperty(value="cv")
    public Cv getCv() {
        return this.cv;
    }

    @JsonProperty(value="cv")
    public void setCv(Cv cv) {
        this.cv = cv;
    }

    public Detection withCv(Cv cv) {
        this.cv = cv;
        return this;
    }

    @JsonProperty(value="step")
    public List<Step> getStep() {
        return this.step;
    }

    @JsonProperty(value="step")
    public void setStep(List<Step> step) {
        this.step = step;
    }

    public Detection withStep(List<Step> step) {
        this.step = step;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Detection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("condition");
        sb.append('=');
        sb.append(this.condition == null ? "<null>" : this.condition);
        sb.append(',');
        sb.append("cvgroup");
        sb.append('=');
        sb.append(this.cvgroup == null ? "<null>" : this.cvgroup);
        sb.append(',');
        sb.append("cv");
        sb.append('=');
        sb.append(this.cv == null ? "<null>" : this.cv);
        sb.append(',');
        sb.append("step");
        sb.append('=');
        sb.append(this.step == null ? "<null>" : this.step);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.cvgroup == null ? 0 : this.cvgroup.hashCode());
        result = result * 31 + (this.condition == null ? 0 : this.condition.hashCode());
        result = result * 31 + (this.step == null ? 0 : this.step.hashCode());
        result = result * 31 + (this.cv == null ? 0 : this.cv.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Detection)) {
            return false;
        }
        Detection rhs = (Detection)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.cvgroup == rhs.cvgroup || this.cvgroup != null && this.cvgroup.equals(rhs.cvgroup)) && (this.condition == rhs.condition || this.condition != null && this.condition.equals(rhs.condition)) && (this.step == rhs.step || this.step != null && this.step.equals(rhs.step)) && (this.cv == rhs.cv || this.cv != null && this.cv.equals(rhs.cv));
    }
}

