/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.decoder.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bidib.jbidibc.decoder.version.AbstractDecoderVersion;

public class PatternBVersion
extends AbstractDecoderVersion {
    public static final String PATTERN_B = "[0-9]+";
    private Integer minorVersion;
    private Integer microVersion;

    public PatternBVersion(String pattern) {
        super(pattern);
    }

    @Override
    public Integer getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public Integer getMicroVersion() {
        return this.microVersion;
    }

    protected void setMinorVersion(Integer minorVersion) {
        this.minorVersion = minorVersion;
    }

    protected void setMicroVersion(Integer microVersion) {
        this.microVersion = microVersion;
    }

    @Override
    public void parse(String versionString) {
        Matcher m = Pattern.compile(PATTERN_B).matcher(versionString);
        int index = 0;
        while (m.find()) {
            String text = m.group(0);
            switch (index) {
                case 0: {
                    this.setMajorVersion(Integer.parseInt(text));
                    break;
                }
                case 1: {
                    this.setMinorVersion(Integer.parseInt(text));
                    break;
                }
                default: {
                    this.setMicroVersion(Integer.parseInt(text));
                }
            }
            ++index;
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.microVersion == null ? 0 : this.microVersion.hashCode());
        result = 31 * result + (this.minorVersion == null ? 0 : this.minorVersion.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatternBVersion other = (PatternBVersion)obj;
        if (this.microVersion == null ? other.microVersion != null : !this.microVersion.equals(other.microVersion)) {
            return false;
        }
        return !(this.minorVersion == null ? other.minorVersion != null : !this.minorVersion.equals(other.minorVersion));
    }
}

