/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.decoder.decoderdb;

import com.github.markusbernhardt.proxy.ProxySearch;
import com.github.markusbernhardt.proxy.util.Logger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Optional;
import org.apache.hc.core5.http.HttpHost;
import org.bidib.jbidibc.decoder.decoderdb.Slf4jLogBackEnd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyUtils.class);

    /*
     * Enabled aggressive block sorting
     */
    public static Proxy findProxy(URI uri) throws URISyntaxException {
        ProxySearch proxySearch;
        ProxySelector proxySelector;
        if (com.github.markusbernhardt.proxy.util.Logger.getBackend() == null) {
            com.github.markusbernhardt.proxy.util.Logger.setBackend((Logger.LogBackEnd)new Slf4jLogBackEnd());
        }
        if ((proxySelector = (proxySearch = ProxySearch.getDefaultProxySearch()).getProxySelector()) == null) {
            LOGGER.info("No proxy selector available.");
            return Proxy.NO_PROXY;
        }
        ProxySelector.setDefault(proxySelector);
        Proxy proxy = ProxySelector.getDefault().select(uri).iterator().next();
        LOGGER.info("proxy type: {}", (Object)proxy.type());
        InetSocketAddress addr = (InetSocketAddress)proxy.address();
        if (addr == null) {
            LOGGER.info("No Proxy");
            return Proxy.NO_PROXY;
        }
        LOGGER.info("proxy hostname: {}", (Object)addr.getHostName());
        LOGGER.info("proxy port: {}", (Object)addr.getPort());
        return proxy;
    }

    public static Optional<HttpHost> getProxy(String url) {
        Proxy proxy = null;
        try {
            proxy = ProxyUtils.findProxy(new URL(url).toURI());
        }
        catch (Exception ex) {
            LOGGER.warn("Find proxy failed.", (Throwable)ex);
        }
        if (!Proxy.NO_PROXY.equals(proxy)) {
            try {
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                String proxyUrl = addr.getHostName();
                int port = addr.getPort();
                try {
                    InetAddress.getByName(proxyUrl);
                    return Optional.of(new HttpHost(proxyUrl, port));
                }
                catch (UnknownHostException e) {
                    LOGGER.warn("The proxy host is not resolvable. Fallback to NO_PROXY.", (Throwable)e);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Prepare proxy HttpHost failed.", (Throwable)ex);
            }
        }
        return Optional.empty();
    }
}

