/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.decoder.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bidib.jbidibc.decoder.version.AbstractDecoderVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternCVersion
extends AbstractDecoderVersion {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatternCVersion.class);
    private static final String PATTERN_C_VERSION = "V([0-9]\\.?){1,2}";
    private static final String PATTERN_C_REVISION = "R[0-9]+";
    public static final String PATTERN_B = "[0-9]+";
    private Integer minorVersion;
    private Integer microVersion;
    private static final String PATTERN_C = "^V(\\{([0-9]){1,2}\\:M([0-9]|x){1,4}\\}\\.?){1,2}R\\{([0-9]){1,2}\\}$";

    public PatternCVersion(String pattern) {
        super(pattern);
    }

    @Override
    public Integer getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public Integer getMicroVersion() {
        return this.microVersion;
    }

    public Integer getRevision() {
        return this.microVersion;
    }

    protected void setMinorVersion(Integer minorVersion) {
        this.minorVersion = minorVersion;
    }

    protected void setMicroVersion(Integer microVersion) {
        this.microVersion = microVersion;
    }

    @Override
    public void parse(String versionString) {
        this.parseVersion(versionString);
        this.parseRevision(versionString);
    }

    protected void parseVersion(String versionString) {
        Matcher m = Pattern.compile(PATTERN_C_VERSION).matcher(versionString);
        while (m.find()) {
            String text = m.group(0);
            Matcher m1 = Pattern.compile(PATTERN_B).matcher(text);
            int index = 0;
            while (m1.find()) {
                String textVersion = m1.group(0);
                switch (index) {
                    case 0: {
                        this.setMajorVersion(Integer.parseInt(textVersion));
                        break;
                    }
                    case 1: {
                        this.setMinorVersion(Integer.parseInt(textVersion));
                        break;
                    }
                    default: {
                        this.setMicroVersion(Integer.parseInt(textVersion));
                    }
                }
                ++index;
            }
        }
    }

    protected void parseRevision(String versionString) {
        Matcher m = Pattern.compile(PATTERN_C_REVISION).matcher(versionString);
        while (m.find()) {
            String text = m.group(0);
            Matcher m1 = Pattern.compile(PATTERN_B).matcher(text);
            int index = 0;
            while (m1.find()) {
                String textVersion = m1.group(0);
                switch (index) {
                    case 0: {
                        this.setMicroVersion(Integer.parseInt(textVersion));
                        break;
                    }
                }
                ++index;
            }
        }
    }

    public static PatternCVersion parsePattern(String pattern) {
        String versionPatternStart = "V(\\{([0-9]){1,2}\\:M([0-9]|x){1,4}\\}\\.?){1,2}";
        String versionPattern = "\\{([0-9]){1,2}\\:M([0-9]|x){1,4}\\}";
        String revisionPatternStart = "R\\{([0-9]){1,2}\\}";
        String revisionPattern = "([0-9]){1,2}";
        Matcher m = Pattern.compile(PATTERN_C).matcher(pattern);
        if (m.matches()) {
            Matcher revisionStartMatcher;
            String currentGroup;
            LOGGER.info("The pattern matches! Current group: {}", (Object)m.group());
            int groupCount = m.groupCount();
            LOGGER.info("Current groupCount: {}", (Object)groupCount);
            for (int i = 0; i < groupCount; ++i) {
                LOGGER.info("Current index: {}, group: {}", (Object)i, (Object)m.group(i));
            }
            Matcher versionStartMatcher = Pattern.compile("V(\\{([0-9]){1,2}\\:M([0-9]|x){1,4}\\}\\.?){1,2}").matcher(pattern);
            if (versionStartMatcher.find()) {
                String versionGroup = versionStartMatcher.group();
                LOGGER.info("VersionStart, current group: {}", (Object)versionGroup);
                int index = 0;
                Matcher versionMatcher = Pattern.compile("\\{([0-9]){1,2}\\:M([0-9]|x){1,4}\\}").matcher(versionGroup);
                while (versionMatcher.find()) {
                    currentGroup = versionMatcher.group();
                    LOGGER.info("Version, current group: {}, index: {}", (Object)currentGroup, (Object)index);
                    int groupCnt = versionMatcher.groupCount();
                    for (int group = 0; group < groupCnt; ++group) {
                        LOGGER.info("Current group: {}", (Object)versionMatcher.group(group));
                    }
                    ++index;
                }
            }
            if ((revisionStartMatcher = Pattern.compile("R\\{([0-9]){1,2}\\}").matcher(pattern)).find()) {
                String currentRevisionGroup = revisionStartMatcher.group();
                LOGGER.info("RevisionStart, current group: {}", (Object)currentRevisionGroup);
                Matcher revisionMatcher = Pattern.compile("([0-9]){1,2}").matcher(currentRevisionGroup);
                if (revisionMatcher.find()) {
                    currentGroup = revisionMatcher.group();
                    LOGGER.info("Revision, current group: {}", (Object)currentGroup);
                }
            }
        } else {
            LOGGER.warn("The pattern does not match!");
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.microVersion == null ? 0 : this.microVersion.hashCode());
        result = 31 * result + (this.minorVersion == null ? 0 : this.minorVersion.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatternCVersion other = (PatternCVersion)obj;
        if (this.microVersion == null ? other.microVersion != null : !this.microVersion.equals(other.microVersion)) {
            return false;
        }
        return !(this.minorVersion == null ? other.minorVersion != null : !this.minorVersion.equals(other.minorVersion));
    }
}

