
package org.bidib.jbidib.decoder.json;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "condition",
    "cvgroup",
    "cv",
    "step"
})
@Generated("jsonschema2pojo")
public class Detection {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("name")
    @NotNull
    private String name;
    @JsonProperty("condition")
    @Valid
    private Condition condition;
    @JsonProperty("cvgroup")
    @Valid
    private Cvgroup cvgroup;
    /**
     * The CV Object
     * 
     */
    @JsonProperty("cv")
    @JsonPropertyDescription("The CV Object")
    @Valid
    private Cv cv;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("step")
    @Valid
    @NotNull
    private List<Step> step = new ArrayList<Step>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public Detection() {
    }

    public Detection(String name, Condition condition, Cvgroup cvgroup, Cv cv, List<Step> step) {
        super();
        this.name = name;
        this.condition = condition;
        this.cvgroup = cvgroup;
        this.cv = cv;
        this.step = step;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Detection withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("condition")
    public Condition getCondition() {
        return condition;
    }

    @JsonProperty("condition")
    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public Detection withCondition(Condition condition) {
        this.condition = condition;
        return this;
    }

    @JsonProperty("cvgroup")
    public Cvgroup getCvgroup() {
        return cvgroup;
    }

    @JsonProperty("cvgroup")
    public void setCvgroup(Cvgroup cvgroup) {
        this.cvgroup = cvgroup;
    }

    public Detection withCvgroup(Cvgroup cvgroup) {
        this.cvgroup = cvgroup;
        return this;
    }

    /**
     * The CV Object
     * 
     */
    @JsonProperty("cv")
    public Cv getCv() {
        return cv;
    }

    /**
     * The CV Object
     * 
     */
    @JsonProperty("cv")
    public void setCv(Cv cv) {
        this.cv = cv;
    }

    public Detection withCv(Cv cv) {
        this.cv = cv;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("step")
    public List<Step> getStep() {
        return step;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("step")
    public void setStep(List<Step> step) {
        this.step = step;
    }

    public Detection withStep(List<Step> step) {
        this.step = step;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Detection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("condition");
        sb.append('=');
        sb.append(((this.condition == null)?"<null>":this.condition));
        sb.append(',');
        sb.append("cvgroup");
        sb.append('=');
        sb.append(((this.cvgroup == null)?"<null>":this.cvgroup));
        sb.append(',');
        sb.append("cv");
        sb.append('=');
        sb.append(((this.cv == null)?"<null>":this.cv));
        sb.append(',');
        sb.append("step");
        sb.append('=');
        sb.append(((this.step == null)?"<null>":this.step));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.cvgroup == null)? 0 :this.cvgroup.hashCode()));
        result = ((result* 31)+((this.condition == null)? 0 :this.condition.hashCode()));
        result = ((result* 31)+((this.step == null)? 0 :this.step.hashCode()));
        result = ((result* 31)+((this.cv == null)? 0 :this.cv.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Detection) == false) {
            return false;
        }
        Detection rhs = ((Detection) other);
        return ((((((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name)))&&((this.cvgroup == rhs.cvgroup)||((this.cvgroup!= null)&&this.cvgroup.equals(rhs.cvgroup))))&&((this.condition == rhs.condition)||((this.condition!= null)&&this.condition.equals(rhs.condition))))&&((this.step == rhs.step)||((this.step!= null)&&this.step.equals(rhs.step))))&&((this.cv == rhs.cv)||((this.cv!= null)&&this.cv.equals(rhs.cv))));
    }

}
