/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidib.decoder.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.bidib.jbidib.decoder.json.CvAddress;
import org.bidib.jbidib.decoder.json.Metadata;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "typename", "value", "cvAddress", "type", "mode", "possibleValues", "metadata"})
public class Cv {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="id")
    @NotNull
    private String id;
    @JsonProperty(value="typename")
    @JsonPropertyDescription(value="typename")
    private String typename;
    @JsonProperty(value="value")
    @JsonPropertyDescription(value="value or null")
    private Double value;
    @JsonProperty(value="cvAddress")
    @Valid
    private CvAddress cvAddress;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="type")
    @NotNull
    private Type type;
    @JsonProperty(value="mode")
    @JsonPropertyDescription(value="mode")
    @NotNull
    private Mode mode;
    @JsonProperty(value="possibleValues")
    @JsonPropertyDescription(value="Possible values. TODO: maybe seperate Object?")
    private String possibleValues;
    @JsonProperty(value="metadata")
    @Valid
    private Metadata metadata;

    public Cv() {
    }

    public Cv(String id, String typename, Double value, CvAddress cvAddress, Type type, Mode mode, String possibleValues, Metadata metadata) {
        this.id = id;
        this.typename = typename;
        this.value = value;
        this.cvAddress = cvAddress;
        this.type = type;
        this.mode = mode;
        this.possibleValues = possibleValues;
        this.metadata = metadata;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public Cv withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="typename")
    public String getTypename() {
        return this.typename;
    }

    @JsonProperty(value="typename")
    public void setTypename(String typename) {
        this.typename = typename;
    }

    public Cv withTypename(String typename) {
        this.typename = typename;
        return this;
    }

    @JsonProperty(value="value")
    public Double getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(Double value) {
        this.value = value;
    }

    public Cv withValue(Double value) {
        this.value = value;
        return this;
    }

    @JsonProperty(value="cvAddress")
    public CvAddress getCvAddress() {
        return this.cvAddress;
    }

    @JsonProperty(value="cvAddress")
    public void setCvAddress(CvAddress cvAddress) {
        this.cvAddress = cvAddress;
    }

    public Cv withCvAddress(CvAddress cvAddress) {
        this.cvAddress = cvAddress;
        return this;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    public Cv withType(Type type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="mode")
    public Mode getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Cv withMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    @JsonProperty(value="possibleValues")
    public String getPossibleValues() {
        return this.possibleValues;
    }

    @JsonProperty(value="possibleValues")
    public void setPossibleValues(String possibleValues) {
        this.possibleValues = possibleValues;
    }

    public Cv withPossibleValues(String possibleValues) {
        this.possibleValues = possibleValues;
        return this;
    }

    @JsonProperty(value="metadata")
    public Metadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Cv withMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Cv.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("typename");
        sb.append('=');
        sb.append(this.typename == null ? "<null>" : this.typename);
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(this.value == null ? "<null>" : this.value);
        sb.append(',');
        sb.append("cvAddress");
        sb.append('=');
        sb.append(this.cvAddress == null ? "<null>" : this.cvAddress);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("mode");
        sb.append('=');
        sb.append(this.mode == null ? "<null>" : this.mode);
        sb.append(',');
        sb.append("possibleValues");
        sb.append('=');
        sb.append(this.possibleValues == null ? "<null>" : this.possibleValues);
        sb.append(',');
        sb.append("metadata");
        sb.append('=');
        sb.append(this.metadata == null ? "<null>" : this.metadata);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.cvAddress == null ? 0 : this.cvAddress.hashCode());
        result = result * 31 + (this.mode == null ? 0 : this.mode.hashCode());
        result = result * 31 + (this.possibleValues == null ? 0 : this.possibleValues.hashCode());
        result = result * 31 + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        result = result * 31 + (this.typename == null ? 0 : this.typename.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Cv)) {
            return false;
        }
        Cv rhs = (Cv)other;
        return (this.cvAddress == rhs.cvAddress || this.cvAddress != null && this.cvAddress.equals(rhs.cvAddress)) && (this.mode == rhs.mode || this.mode != null && this.mode.equals((Object)rhs.mode)) && (this.possibleValues == rhs.possibleValues || this.possibleValues != null && this.possibleValues.equals(rhs.possibleValues)) && (this.metadata == rhs.metadata || this.metadata != null && this.metadata.equals(rhs.metadata)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.value == rhs.value || this.value != null && this.value.equals(rhs.value)) && (this.typename == rhs.typename || this.typename != null && this.typename.equals(rhs.typename));
    }

    public static enum Type {
        BYTE("byte"),
        SELECT("select"),
        SINGED_BYTE("singedByte");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Mode {
        RW("rw"),
        RO("ro"),
        WO("wo");

        private final String value;
        private static final Map<String, Mode> CONSTANTS;

        private Mode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Mode fromValue(String value) {
            Mode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Mode>();
            for (Mode c : Mode.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

