/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.decoder.decoderdb;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.apache.hc.client5.http.fluent.Content;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.core5.util.Timeout;
import org.bidib.jbidibc.decoder.decoderdb.ProxyUtils;
import org.bidib.jbidibc.decoder.exception.DecoderDbAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDecoderDbAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDecoderDbAccess.class);
    protected static final String REST_SERVICE_URI = "https://www.decoderdb.de";

    public static <T> T fetch(String login, char[] password, String urlPath, Class<T> responseType, DataFormat format) {
        Request request = Request.get((String)urlPath).connectTimeout(Timeout.ofMilliseconds((long)5000L));
        ProxyUtils.getProxy(urlPath).ifPresent(proxy -> {
            LOGGER.debug("Use proxy: {}", proxy);
            request.viaProxy(proxy);
        });
        try {
            Content content = request.execute().returnContent();
            String received = content.asString(StandardCharsets.UTF_8);
            LOGGER.debug("Received: {}", (Object)received);
            XmlMapper objectMapper = null;
            if (DataFormat.xml == format) {
                JacksonXmlModule xmlModule = new JacksonXmlModule();
                xmlModule.setDefaultUseWrapper(false);
                objectMapper = new XmlMapper(xmlModule);
                objectMapper.registerModule((Module)new JaxbAnnotationModule());
            } else {
                objectMapper = new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
            }
            Object responseBody = objectMapper.readValue(received, responseType);
            LOGGER.info("Retrieved responseBody: {}", responseBody);
            return (T)responseBody;
        }
        catch (Exception ex) {
            LOGGER.warn("Fetch data from decoderDb failed.", (Throwable)ex);
            throw new DecoderDbAccessException("Fetch data from decoderDb failed.", ex);
        }
    }

    public static <T> T fetch(String login, char[] password, String urlPath, Function<String, T> mapper) {
        Request request = Request.get((String)urlPath).connectTimeout(Timeout.ofMilliseconds((long)5000L));
        ProxyUtils.getProxy(urlPath).ifPresent(proxy -> {
            LOGGER.debug("Use proxy: {}", proxy);
            request.viaProxy(proxy);
        });
        try {
            Content content = request.execute().returnContent();
            String received = content.asString(StandardCharsets.UTF_8);
            LOGGER.debug("Received: {}", (Object)received);
            T responseBody = mapper.apply(received);
            LOGGER.info("Retrieved responseBody: {}", responseBody);
            return responseBody;
        }
        catch (Exception ex) {
            LOGGER.warn("Fetch data from decoderDb failed.", (Throwable)ex);
            throw new DecoderDbAccessException("Fetch data from decoderDb failed.", ex);
        }
    }

    public static enum DataFormat {
        json,
        xml;

    }
}

