/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.decoder.version;

import org.assertj.core.api.Assertions;
import org.bidib.jbidibc.decoder.version.DecoderVersion;
import org.bidib.jbidibc.decoder.version.PatternBVersion;
import org.bidib.jbidibc.decoder.version.PatternCVersion;
import org.bidib.jbidibc.decoder.version.VersionMatcher;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionMatcherTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionMatcherTest.class);

    @Test
    public void patternATest() {
        String versionString = "123";
        VersionMatcher versionMatcher = new VersionMatcher();
        DecoderVersion result = versionMatcher.detectVersion(versionString);
        Assertions.assertThat((Integer)result.getMajorVersion()).isEqualTo((Object)Integer.valueOf(versionString));
    }

    @Test
    public void patternAplusTest() {
        VersionMatcher.VersionCheck versionCheck = new VersionMatcher.VersionCheck("^([0-9]{1,4})$", "1.2.3");
        String result = versionCheck.check(VersionMatcher.versionMatcher);
        Assertions.assertThat((String)result).isNull();
        result = new VersionMatcher.VersionCheck("^([0-9]{1,4})$", "102").check(VersionMatcher.versionMatcher);
        Assertions.assertThat((String)result).isEqualTo("102");
    }

    @Test
    public void patternBTest() {
        String versionString = "1.2.3";
        VersionMatcher versionMatcher = new VersionMatcher();
        DecoderVersion result = versionMatcher.detectVersion(versionString);
        PatternBVersion expected = new PatternBVersion(versionString);
        expected.setMajorVersion(Integer.valueOf(1));
        expected.setMinorVersion(Integer.valueOf(2));
        expected.setMicroVersion(Integer.valueOf(3));
        Assertions.assertThat((Object)result).isEqualTo((Object)expected);
    }

    @Test
    public void patternCTest() {
        String versionString = "V1.2R3";
        VersionMatcher versionMatcher = new VersionMatcher();
        DecoderVersion result = versionMatcher.detectVersion(versionString);
        PatternCVersion expected = new PatternCVersion(versionString);
        expected.setMajorVersion(Integer.valueOf(1));
        expected.setMinorVersion(Integer.valueOf(2));
        expected.setMicroVersion(Integer.valueOf(3));
        Assertions.assertThat((Object)result).isEqualTo((Object)expected);
        PatternCVersion patternCVersion = (PatternCVersion)result;
        Assertions.assertThat((Integer)patternCVersion.getRevision()).isEqualTo((Object)3);
    }

    @Test
    public void patternCExtTest() {
        String pattern = "V{0:M0x07}.{0:M0x78}R{1}";
        PatternCVersion patternVersion = PatternCVersion.parsePattern((String)pattern);
    }
}

