/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.decoder.external;

import eu.esu._2010.lokprogrammer.metadata.FunctionType;
import eu.esu._2010.lokprogrammer.metadata.MetaType;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.bidib.jbidibc.decoder.external.EsuXReader;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsuXReaderTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(EsuXReaderTest.class);

    @Test
    void readEsuXFile() throws FileNotFoundException, IOException {
        InputStream esuXFile = EsuXReaderTest.class.getResourceAsStream("/external/Re620.esux");
        EsuXReader esuXReader = new EsuXReader();
        String metaData = esuXReader.getMetaData(esuXFile);
        Assertions.assertThat((String)metaData).isNotBlank();
        LOGGER.info("Len of meta: {}", (Object)metaData.length());
        Assertions.assertThat((String)metaData).endsWith((CharSequence)"</meta>");
        MetaType meta = esuXReader.getMetaType(metaData);
        Assertions.assertThat((Object)meta).isNotNull();
        LOGGER.info("Returned meta: {}", (Object)meta);
    }

    @Test
    void parseMeta() throws IOException {
        String metaData = IOUtils.resourceToString((String)"/external/Re620.xml", (Charset)StandardCharsets.UTF_8);
        EsuXReader esuXReader = new EsuXReader();
        MetaType meta = esuXReader.getMetaType(metaData);
        Assertions.assertThat((Object)meta).isNotNull();
        LOGGER.info("Returned meta: {}", (Object)meta);
        String language = "de";
        List functions = meta.getFunction();
        for (FunctionType function : functions) {
            int functionId = function.getId().intValue();
            FunctionType.Description description = function.getDescription().stream().filter(desc -> desc.getLang().equals("de")).findFirst().orElseThrow(() -> new IllegalArgumentException("No description for language available: de"));
            LOGGER.info("Current function id: {}, description: {}", (Object)functionId, (Object)description.getValue());
        }
        StringBuilder sb = new StringBuilder();
        String languageEn = "en";
        for (FunctionType function : functions) {
            int functionId = function.getId().intValue();
            FunctionType.Description description = function.getDescription().stream().filter(desc -> desc.getLang().equals("en")).findFirst().orElseThrow(() -> new IllegalArgumentException("No description for language available: en"));
            LOGGER.info("Current function id: {}, description: {}", (Object)functionId, (Object)description.getValue());
            sb.append(functionId).append("\t\t").append(description.getValue()).append("\t\t").append(System.lineSeparator());
        }
        try {
            StringSelection stringSelection = new StringSelection(sb.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
        catch (Exception ex) {
            LOGGER.warn("Copy functions to clipboard failed.", (Throwable)ex);
        }
    }
}

