/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.decoder.decoderdb;

import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.assertj.core.api.Assertions;
import org.bidib.jbidibc.decoder.decoderdb.DecoderDetectionAccess;
import org.bidib.jbidibc.decoder.schema.commontypes.ProtocolTypeType;
import org.bidib.jbidibc.decoder.schema.decoderdetection.DecoderDetection;
import org.bidib.jbidibc.decoder.schema.decoderdetection.DecoderDetectionProtocolType;
import org.bidib.jbidibc.decoder.schema.decoderdetection.ManufacturerType;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoderDetectionAccessTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecoderDetectionAccessTest.class);

    @Test
    public void fetch() {
        LOGGER.info("Fetch decoderDetection from DecoderDB.");
        DecoderDetectionAccess decoderDetectionAccess = new DecoderDetectionAccess();
        DecoderDetection decoderDetection = decoderDetectionAccess.fetch("cv", "cv".toCharArray());
        LOGGER.info("Retrieved decoderDetection: {}", (Object)decoderDetection);
        Assertions.assertThat((Object)decoderDetection).isNotNull();
        Assertions.assertThat((Object)decoderDetection.getProtocols()).isNotNull();
        Assertions.assertThat((List)decoderDetection.getProtocols().getProtocol()).isNotNull();
        Assertions.assertThat((List)decoderDetection.getProtocols().getProtocol()).isNotEmpty();
        List protocols = decoderDetection.getProtocols().getProtocol();
        DecoderDetectionProtocolType dccProtocol = (DecoderDetectionProtocolType)IterableUtils.find((Iterable)protocols, (Predicate)new Predicate<DecoderDetectionProtocolType>(){

            public boolean evaluate(DecoderDetectionProtocolType protocol) {
                return ProtocolTypeType.DCC.equals((Object)protocol.getType());
            }
        });
        Assertions.assertThat((Object)dccProtocol).isNotNull();
        int ID = 13;
        List manufacturers = dccProtocol.getManufacturer();
        ManufacturerType manufacturerDiy = (ManufacturerType)IterableUtils.find((Iterable)manufacturers, (Predicate)new Predicate<ManufacturerType>(){

            public boolean evaluate(ManufacturerType manufacturer) {
                return manufacturer.getId() == 13;
            }
        });
        Assertions.assertThat((Object)manufacturerDiy).isNotNull();
        LOGGER.info("Found DIY manufacturer: {}", (Object)manufacturerDiy);
        final Integer EXTENDED_ID_OPENCAR = 257;
        ManufacturerType manufacturerOpenDcc = (ManufacturerType)IterableUtils.find((Iterable)manufacturers, (Predicate)new Predicate<ManufacturerType>(){

            public boolean evaluate(ManufacturerType manufacturer) {
                return manufacturer.getId() == 13 && EXTENDED_ID_OPENCAR.equals(manufacturer.getExtendedId());
            }
        });
        Assertions.assertThat((Object)manufacturerOpenDcc).isNotNull();
        LOGGER.info("Found OpenCar manufacturer: {}", (Object)manufacturerOpenDcc);
    }
}

