
package org.bidib.jbidib.decoder.json;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "type",
    "cv",
    "expression"
})
@Generated("jsonschema2pojo")
public class Condition {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    @NotNull
    private String type;
    /**
     * An array containing CVs and CvGroups
     * (Required)
     * 
     */
    @JsonProperty("cv")
    @JsonPropertyDescription("An array containing CVs and CvGroups")
    @Valid
    @NotNull
    private List<Object> cv = new ArrayList<Object>();
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("expression")
    @Valid
    @NotNull
    private Expression expression;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Condition() {
    }

    public Condition(String type, List<Object> cv, Expression expression) {
        super();
        this.type = type;
        this.cv = cv;
        this.expression = expression;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    public Condition withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * An array containing CVs and CvGroups
     * (Required)
     * 
     */
    @JsonProperty("cv")
    public List<Object> getCv() {
        return cv;
    }

    /**
     * An array containing CVs and CvGroups
     * (Required)
     * 
     */
    @JsonProperty("cv")
    public void setCv(List<Object> cv) {
        this.cv = cv;
    }

    public Condition withCv(List<Object> cv) {
        this.cv = cv;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("expression")
    public Expression getExpression() {
        return expression;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("expression")
    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Condition withExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Condition.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("cv");
        sb.append('=');
        sb.append(((this.cv == null)?"<null>":this.cv));
        sb.append(',');
        sb.append("expression");
        sb.append('=');
        sb.append(((this.expression == null)?"<null>":this.expression));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.cv == null)? 0 :this.cv.hashCode()));
        result = ((result* 31)+((this.expression == null)? 0 :this.expression.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Condition) == false) {
            return false;
        }
        Condition rhs = ((Condition) other);
        return ((((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type)))&&((this.cv == rhs.cv)||((this.cv!= null)&&this.cv.equals(rhs.cv))))&&((this.expression == rhs.expression)||((this.expression!= null)&&this.expression.equals(rhs.expression))));
    }

}
