
package org.bidib.jbidib.decoder.json;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;


/**
 * Decoderbase
 * <p>
 * Description of the Decoderbase
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "manufacturer",
    "decoder",
    "firmware",
    "detection",
    "additionalProperties",
    "required"
})
@Generated("jsonschema2pojo")
public class Decoderschema {

    /**
     * Name
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Name")
    private String name;
    @JsonProperty("manufacturer")
    @Valid
    private List<Manufacturer> manufacturer = new ArrayList<Manufacturer>();
    @JsonProperty("decoder")
    @Valid
    private List<Decoder> decoder = new ArrayList<Decoder>();
    @JsonProperty("firmware")
    @Valid
    private List<Firmware> firmware = new ArrayList<Firmware>();
    @JsonProperty("detection")
    @Valid
    private Detection detection;
    @JsonProperty("additionalProperties")
    private Object additionalProperties;
    @JsonProperty("required")
    private Object required;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Decoderschema() {
    }

    /**
     * 
     * @param name
     *     Name.
     */
    public Decoderschema(String name, List<Manufacturer> manufacturer, List<Decoder> decoder, List<Firmware> firmware, Detection detection, Object additionalProperties, Object required) {
        super();
        this.name = name;
        this.manufacturer = manufacturer;
        this.decoder = decoder;
        this.firmware = firmware;
        this.detection = detection;
        this.additionalProperties = additionalProperties;
        this.required = required;
    }

    /**
     * Name
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * Name
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Decoderschema withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("manufacturer")
    public List<Manufacturer> getManufacturer() {
        return manufacturer;
    }

    @JsonProperty("manufacturer")
    public void setManufacturer(List<Manufacturer> manufacturer) {
        this.manufacturer = manufacturer;
    }

    public Decoderschema withManufacturer(List<Manufacturer> manufacturer) {
        this.manufacturer = manufacturer;
        return this;
    }

    @JsonProperty("decoder")
    public List<Decoder> getDecoder() {
        return decoder;
    }

    @JsonProperty("decoder")
    public void setDecoder(List<Decoder> decoder) {
        this.decoder = decoder;
    }

    public Decoderschema withDecoder(List<Decoder> decoder) {
        this.decoder = decoder;
        return this;
    }

    @JsonProperty("firmware")
    public List<Firmware> getFirmware() {
        return firmware;
    }

    @JsonProperty("firmware")
    public void setFirmware(List<Firmware> firmware) {
        this.firmware = firmware;
    }

    public Decoderschema withFirmware(List<Firmware> firmware) {
        this.firmware = firmware;
        return this;
    }

    @JsonProperty("detection")
    public Detection getDetection() {
        return detection;
    }

    @JsonProperty("detection")
    public void setDetection(Detection detection) {
        this.detection = detection;
    }

    public Decoderschema withDetection(Detection detection) {
        this.detection = detection;
        return this;
    }

    @JsonProperty("additionalProperties")
    public Object getAdditionalProperties() {
        return additionalProperties;
    }

    @JsonProperty("additionalProperties")
    public void setAdditionalProperties(Object additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public Decoderschema withAdditionalProperties(Object additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonProperty("required")
    public Object getRequired() {
        return required;
    }

    @JsonProperty("required")
    public void setRequired(Object required) {
        this.required = required;
    }

    public Decoderschema withRequired(Object required) {
        this.required = required;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Decoderschema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("manufacturer");
        sb.append('=');
        sb.append(((this.manufacturer == null)?"<null>":this.manufacturer));
        sb.append(',');
        sb.append("decoder");
        sb.append('=');
        sb.append(((this.decoder == null)?"<null>":this.decoder));
        sb.append(',');
        sb.append("firmware");
        sb.append('=');
        sb.append(((this.firmware == null)?"<null>":this.firmware));
        sb.append(',');
        sb.append("detection");
        sb.append('=');
        sb.append(((this.detection == null)?"<null>":this.detection));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        sb.append("required");
        sb.append('=');
        sb.append(((this.required == null)?"<null>":this.required));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.detection == null)? 0 :this.detection.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.decoder == null)? 0 :this.decoder.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.firmware == null)? 0 :this.firmware.hashCode()));
        result = ((result* 31)+((this.required == null)? 0 :this.required.hashCode()));
        result = ((result* 31)+((this.manufacturer == null)? 0 :this.manufacturer.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Decoderschema) == false) {
            return false;
        }
        Decoderschema rhs = ((Decoderschema) other);
        return ((((((((this.detection == rhs.detection)||((this.detection!= null)&&this.detection.equals(rhs.detection)))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.decoder == rhs.decoder)||((this.decoder!= null)&&this.decoder.equals(rhs.decoder))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.firmware == rhs.firmware)||((this.firmware!= null)&&this.firmware.equals(rhs.firmware))))&&((this.required == rhs.required)||((this.required!= null)&&this.required.equals(rhs.required))))&&((this.manufacturer == rhs.manufacturer)||((this.manufacturer!= null)&&this.manufacturer.equals(rhs.manufacturer))));
    }

}
