package org.bidib.jbidibc.decoder.json;

import java.time.LocalDate;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DecoderDbStatusResponse {

    private long version;

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class ManufacturersStatusResponse extends StatusResponse {

        private LocalDate nmraListDate;

        /**
         * @return the nmraListDate
         */
        public LocalDate getNmraListDate() {
            return nmraListDate;
        }

        /**
         * @param nmraListDate
         *            the nmraListDate to set
         */
        public void setNmraListDate(LocalDate nmraListDate) {
            this.nmraListDate = nmraListDate;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class DecoderDetectionsStatusResponse extends StatusResponse {

        private String sha1;

        private long fileSize;

        /**
         * @return the sha1
         */
        public String getSha1() {
            return sha1;
        }

        /**
         * @param sha1
         *            the sha1 to set
         */
        public void setSha1(String sha1) {
            this.sha1 = sha1;
        }

        /**
         * @return the fileSize
         */
        public long getFileSize() {
            return fileSize;
        }

        /**
         * @param fileSize
         *            the fileSize to set
         */
        public void setFileSize(long fileSize) {
            this.fileSize = fileSize;
        }

    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class DecoderStatusResponse extends StatusResponse {
        private Integer manufacturerId;

        private Integer manufacturerExtendedId;

        private String name;

        public Integer getManufacturerId() {
            return manufacturerId;
        }

        public void setManufacturerId(Integer manufacturerId) {
            this.manufacturerId = manufacturerId;
        }

        /**
         * @return the manufacturerExtendedId
         */
        public Integer getManufacturerExtendedId() {
            return manufacturerExtendedId;
        }

        /**
         * @param manufacturerExtendedId
         *            the manufacturerExtendedId to set
         */
        public void setManufacturerExtendedId(Integer manufacturerExtendedId) {
            this.manufacturerExtendedId = manufacturerExtendedId;
        }

        /**
         * @return the name
         */
        public String getName() {
            return name;
        }

        /**
         * @param name
         *            the name to set
         */
        public void setName(String name) {
            this.name = name;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class FirmwareStatusResponse extends StatusResponse {
        private String manufacturerId;

        private String manufacturerExtendedId;

        private String version;

        private String versionExtension;

        public String getManufacturerId() {
            return manufacturerId;
        }

        public void setManufacturerId(String manufacturerId) {
            this.manufacturerId = manufacturerId;
        }

        /**
         * @return the manufacturerExtendedId
         */
        public String getManufacturerExtendedId() {
            return manufacturerExtendedId;
        }

        /**
         * @param manufacturerExtendedId
         *            the manufacturerExtendedId to set
         */
        public void setManufacturerExtendedId(String manufacturerExtendedId) {
            this.manufacturerExtendedId = manufacturerExtendedId;
        }

        /**
         * @return the version
         */
        public String getVersion() {
            return version;
        }

        /**
         * @param version
         *            the version to set
         */
        public void setVersion(String version) {
            this.version = version;
        }

        /**
         * @return the versionExtension
         */
        public String getVersionExtension() {
            return versionExtension;
        }

        /**
         * @param versionExtension
         *            the versionExtension to set
         */
        public void setVersionExtension(String versionExtension) {
            this.versionExtension = versionExtension;
        }
    }

    private ManufacturersStatusResponse manufacturers;

    /**
     * @return the version
     */
    public long getVersion() {
        return version;
    }

    /**
     * @param version
     *            the version to set
     */
    public void setVersion(long version) {
        this.version = version;
    }

    /**
     * @return the manufacturers
     */
    public ManufacturersStatusResponse getManufacturers() {
        return manufacturers;
    }

    /**
     * @param manufacturers
     *            the manufacturers to set
     */
    public void setManufacturers(ManufacturersStatusResponse manufacturers) {
        this.manufacturers = manufacturers;
    }

    private DecoderDetectionsStatusResponse decoderDetections;

    /**
     * @return the decoderDetectionStatuses
     */
    public DecoderDetectionsStatusResponse getDecoderDetections() {
        return decoderDetections;
    }

    /**
     * @param decoderDetectionStatuses
     *            the decoderDetectionStatuses to set
     */
    public void setDecoderDetections(DecoderDetectionsStatusResponse decoderDetections) {
        this.decoderDetections = decoderDetections;
    }

    private DecoderStatusResponse[] decoder;

    /**
     * @return the decoderStatuses
     */
    public DecoderStatusResponse[] getDecoder() {
        return decoder;
    }

    /**
     * @param decoderStatuses
     *            the decoderStatuses to set
     */
    public void setDecoder(DecoderStatusResponse[] decoder) {
        this.decoder = decoder;
    }

    private FirmwareStatusResponse[] firmware;

    /**
     * @return the firmware
     */
    public FirmwareStatusResponse[] getFirmware() {
        return firmware;
    }

    /**
     * @param firmware
     *            the firmware to set
     */
    public void setFirmware(FirmwareStatusResponse[] firmware) {
        this.firmware = firmware;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
