/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidib.decoder.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bidib.jbidib.decoder.json.Firmware;
import org.bidib.jbidib.decoder.json.Metadata;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "firmware", "manufacturer", "manufacturerExtendedId", "producedFrom", "type", "metadata", "typeid"})
public class Decoder {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="id")
    @NotNull
    private String id;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="id")
    @NotNull
    private String name;
    @JsonProperty(value="firmware")
    @Valid
    private Firmware firmware;
    @JsonProperty(value="manufacturer")
    @JsonPropertyDescription(value="TODO")
    private String manufacturer;
    @JsonProperty(value="manufacturerExtendedId")
    @JsonPropertyDescription(value="TODO")
    private String manufacturerExtendedId;
    @JsonProperty(value="producedFrom")
    @JsonPropertyDescription(value="TODO")
    private String producedFrom;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="type")
    private Type type;
    @JsonProperty(value="metadata")
    @Valid
    private Metadata metadata;
    @JsonProperty(value="typeid")
    @Size(min=0)
    @Valid
    private @Size(min=0) @Valid List<String> typeid = new ArrayList<String>();

    public Decoder() {
    }

    public Decoder(String id, String name, Firmware firmware, String manufacturer, String manufacturerExtendedId, String producedFrom, Type type, Metadata metadata, List<String> typeid) {
        this.id = id;
        this.name = name;
        this.firmware = firmware;
        this.manufacturer = manufacturer;
        this.manufacturerExtendedId = manufacturerExtendedId;
        this.producedFrom = producedFrom;
        this.type = type;
        this.metadata = metadata;
        this.typeid = typeid;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public Decoder withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Decoder withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="firmware")
    public Firmware getFirmware() {
        return this.firmware;
    }

    @JsonProperty(value="firmware")
    public void setFirmware(Firmware firmware) {
        this.firmware = firmware;
    }

    public Decoder withFirmware(Firmware firmware) {
        this.firmware = firmware;
        return this;
    }

    @JsonProperty(value="manufacturer")
    public String getManufacturer() {
        return this.manufacturer;
    }

    @JsonProperty(value="manufacturer")
    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public Decoder withManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
        return this;
    }

    @JsonProperty(value="manufacturerExtendedId")
    public String getManufacturerExtendedId() {
        return this.manufacturerExtendedId;
    }

    @JsonProperty(value="manufacturerExtendedId")
    public void setManufacturerExtendedId(String manufacturerExtendedId) {
        this.manufacturerExtendedId = manufacturerExtendedId;
    }

    public Decoder withManufacturerExtendedId(String manufacturerExtendedId) {
        this.manufacturerExtendedId = manufacturerExtendedId;
        return this;
    }

    @JsonProperty(value="producedFrom")
    public String getProducedFrom() {
        return this.producedFrom;
    }

    @JsonProperty(value="producedFrom")
    public void setProducedFrom(String producedFrom) {
        this.producedFrom = producedFrom;
    }

    public Decoder withProducedFrom(String producedFrom) {
        this.producedFrom = producedFrom;
        return this;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    public Decoder withType(Type type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="metadata")
    public Metadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Decoder withMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonProperty(value="typeid")
    public List<String> getTypeid() {
        return this.typeid;
    }

    @JsonProperty(value="typeid")
    public void setTypeid(List<String> typeid) {
        this.typeid = typeid;
    }

    public Decoder withTypeid(List<String> typeid) {
        this.typeid = typeid;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Decoder.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("firmware");
        sb.append('=');
        sb.append(this.firmware == null ? "<null>" : this.firmware);
        sb.append(',');
        sb.append("manufacturer");
        sb.append('=');
        sb.append(this.manufacturer == null ? "<null>" : this.manufacturer);
        sb.append(',');
        sb.append("manufacturerExtendedId");
        sb.append('=');
        sb.append(this.manufacturerExtendedId == null ? "<null>" : this.manufacturerExtendedId);
        sb.append(',');
        sb.append("producedFrom");
        sb.append('=');
        sb.append(this.producedFrom == null ? "<null>" : this.producedFrom);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("metadata");
        sb.append('=');
        sb.append(this.metadata == null ? "<null>" : this.metadata);
        sb.append(',');
        sb.append("typeid");
        sb.append('=');
        sb.append(this.typeid == null ? "<null>" : this.typeid);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.manufacturerExtendedId == null ? 0 : this.manufacturerExtendedId.hashCode());
        result = result * 31 + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.typeid == null ? 0 : this.typeid.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.firmware == null ? 0 : this.firmware.hashCode());
        result = result * 31 + (this.manufacturer == null ? 0 : this.manufacturer.hashCode());
        result = result * 31 + (this.producedFrom == null ? 0 : this.producedFrom.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Decoder)) {
            return false;
        }
        Decoder rhs = (Decoder)other;
        return (this.manufacturerExtendedId == rhs.manufacturerExtendedId || this.manufacturerExtendedId != null && this.manufacturerExtendedId.equals(rhs.manufacturerExtendedId)) && (this.metadata == rhs.metadata || this.metadata != null && this.metadata.equals(rhs.metadata)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.typeid == rhs.typeid || this.typeid != null && this.typeid.equals(rhs.typeid)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.firmware == rhs.firmware || this.firmware != null && this.firmware.equals(rhs.firmware)) && (this.manufacturer == rhs.manufacturer || this.manufacturer != null && this.manufacturer.equals(rhs.manufacturer)) && (this.producedFrom == rhs.producedFrom || this.producedFrom != null && this.producedFrom.equals(rhs.producedFrom));
    }

    public static enum Type {
        LOCO("loco"),
        LOCO_SOUND("loco-sound"),
        FUNCTION("function"),
        CAR("car"),
        CAR_SOUND("car-sound"),
        SUSI("susi"),
        SUSI_SOUND("susi-sound"),
        STANDARD_ACCESSORY("standardAccessory"),
        EXTENDED_ACCESSORY("extendedAccessory");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

