/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidib.decoder.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bidib.jbidib.decoder.json.Condition;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "condition", "cv"})
public class Step {
    @JsonProperty(value="type")
    private Type type;
    @JsonProperty(value="condition")
    @Valid
    private List<Condition> condition = new ArrayList<Condition>();
    @JsonProperty(value="cv")
    @JsonPropertyDescription(value="An array containing CVs and CvGroups")
    @Valid
    private List<Object> cv = new ArrayList<Object>();

    public Step() {
    }

    public Step(Type type, List<Condition> condition, List<Object> cv) {
        this.type = type;
        this.condition = condition;
        this.cv = cv;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    public Step withType(Type type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="condition")
    public List<Condition> getCondition() {
        return this.condition;
    }

    @JsonProperty(value="condition")
    public void setCondition(List<Condition> condition) {
        this.condition = condition;
    }

    public Step withCondition(List<Condition> condition) {
        this.condition = condition;
        return this;
    }

    @JsonProperty(value="cv")
    public List<Object> getCv() {
        return this.cv;
    }

    @JsonProperty(value="cv")
    public void setCv(List<Object> cv) {
        this.cv = cv;
    }

    public Step withCv(List<Object> cv) {
        this.cv = cv;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Step.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("condition");
        sb.append('=');
        sb.append(this.condition == null ? "<null>" : this.condition);
        sb.append(',');
        sb.append("cv");
        sb.append('=');
        sb.append(this.cv == null ? "<null>" : this.cv);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.condition == null ? 0 : this.condition.hashCode());
        result = result * 31 + (this.cv == null ? 0 : this.cv.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Step)) {
            return false;
        }
        Step rhs = (Step)other;
        return (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.condition == rhs.condition || this.condition != null && this.condition.equals(rhs.condition)) && (this.cv == rhs.cv || this.cv != null && this.cv.equals(rhs.cv));
    }

    public static enum Type {
        MANUFACTURER_ID("manufacturerId"),
        MANUFACTURER_EXTENDED_ID("manufacturerExtendedId"),
        DECODER_ID("decoderId"),
        FIRMWARE_VERSION("firmwareVersion"),
        SERIAL_NUMBER("serialNumber");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

