
package org.bidib.jbidib.decoder.json;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "version",
    "name",
    "metadata",
    "typeid",
    "options",
    "cv",
    "editor"
})
@Generated("jsonschema2pojo")
public class Firmware {

    /**
     * id
     * (Required)
     * 
     */
    @JsonProperty("version")
    @JsonPropertyDescription("id")
    @NotNull
    private String version;
    /**
     * Name of the firmware
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Name of the firmware")
    private String name;
    @JsonProperty("metadata")
    @Valid
    private Metadata metadata;
    @JsonProperty("typeid")
    @Size(min = 0)
    @Valid
    private List<String> typeid = new ArrayList<String>();
    @JsonProperty("options")
    private String options;
    /**
     * An array containing CVs and CvGroups
     * 
     */
    @JsonProperty("cv")
    @JsonPropertyDescription("An array containing CVs and CvGroups")
    @Valid
    private List<Object> cv = new ArrayList<Object>();
    /**
     * CV editor for one Decoder
     * 
     */
    @JsonProperty("editor")
    @JsonPropertyDescription("CV editor for one Decoder")
    @Valid
    private Editor editor;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Firmware() {
    }

    /**
     * 
     * @param name
     *     Name of the firmware.
     * @param version
     *     id.
     */
    public Firmware(String version, String name, Metadata metadata, List<String> typeid, String options, List<Object> cv, Editor editor) {
        super();
        this.version = version;
        this.name = name;
        this.metadata = metadata;
        this.typeid = typeid;
        this.options = options;
        this.cv = cv;
        this.editor = editor;
    }

    /**
     * id
     * (Required)
     * 
     */
    @JsonProperty("version")
    public String getVersion() {
        return version;
    }

    /**
     * id
     * (Required)
     * 
     */
    @JsonProperty("version")
    public void setVersion(String version) {
        this.version = version;
    }

    public Firmware withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Name of the firmware
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * Name of the firmware
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Firmware withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("metadata")
    public Metadata getMetadata() {
        return metadata;
    }

    @JsonProperty("metadata")
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Firmware withMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonProperty("typeid")
    public List<String> getTypeid() {
        return typeid;
    }

    @JsonProperty("typeid")
    public void setTypeid(List<String> typeid) {
        this.typeid = typeid;
    }

    public Firmware withTypeid(List<String> typeid) {
        this.typeid = typeid;
        return this;
    }

    @JsonProperty("options")
    public String getOptions() {
        return options;
    }

    @JsonProperty("options")
    public void setOptions(String options) {
        this.options = options;
    }

    public Firmware withOptions(String options) {
        this.options = options;
        return this;
    }

    /**
     * An array containing CVs and CvGroups
     * 
     */
    @JsonProperty("cv")
    public List<Object> getCv() {
        return cv;
    }

    /**
     * An array containing CVs and CvGroups
     * 
     */
    @JsonProperty("cv")
    public void setCv(List<Object> cv) {
        this.cv = cv;
    }

    public Firmware withCv(List<Object> cv) {
        this.cv = cv;
        return this;
    }

    /**
     * CV editor for one Decoder
     * 
     */
    @JsonProperty("editor")
    public Editor getEditor() {
        return editor;
    }

    /**
     * CV editor for one Decoder
     * 
     */
    @JsonProperty("editor")
    public void setEditor(Editor editor) {
        this.editor = editor;
    }

    public Firmware withEditor(Editor editor) {
        this.editor = editor;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Firmware.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("version");
        sb.append('=');
        sb.append(((this.version == null)?"<null>":this.version));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("metadata");
        sb.append('=');
        sb.append(((this.metadata == null)?"<null>":this.metadata));
        sb.append(',');
        sb.append("typeid");
        sb.append('=');
        sb.append(((this.typeid == null)?"<null>":this.typeid));
        sb.append(',');
        sb.append("options");
        sb.append('=');
        sb.append(((this.options == null)?"<null>":this.options));
        sb.append(',');
        sb.append("cv");
        sb.append('=');
        sb.append(((this.cv == null)?"<null>":this.cv));
        sb.append(',');
        sb.append("editor");
        sb.append('=');
        sb.append(((this.editor == null)?"<null>":this.editor));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.editor == null)? 0 :this.editor.hashCode()));
        result = ((result* 31)+((this.metadata == null)? 0 :this.metadata.hashCode()));
        result = ((result* 31)+((this.cv == null)? 0 :this.cv.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.options == null)? 0 :this.options.hashCode()));
        result = ((result* 31)+((this.typeid == null)? 0 :this.typeid.hashCode()));
        result = ((result* 31)+((this.version == null)? 0 :this.version.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Firmware) == false) {
            return false;
        }
        Firmware rhs = ((Firmware) other);
        return ((((((((this.editor == rhs.editor)||((this.editor!= null)&&this.editor.equals(rhs.editor)))&&((this.metadata == rhs.metadata)||((this.metadata!= null)&&this.metadata.equals(rhs.metadata))))&&((this.cv == rhs.cv)||((this.cv!= null)&&this.cv.equals(rhs.cv))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.options == rhs.options)||((this.options!= null)&&this.options.equals(rhs.options))))&&((this.typeid == rhs.typeid)||((this.typeid!= null)&&this.typeid.equals(rhs.typeid))))&&((this.version == rhs.version)||((this.version!= null)&&this.version.equals(rhs.version))));
    }

}
