
package org.bidib.jbidib.decoder.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.validation.Valid;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "type",
    "condition",
    "cv"
})
@Generated("jsonschema2pojo")
public class Step {

    @JsonProperty("type")
    private Step.Type type;
    @JsonProperty("condition")
    @Valid
    private List<Condition> condition = new ArrayList<Condition>();
    /**
     * An array containing CVs and CvGroups
     * 
     */
    @JsonProperty("cv")
    @JsonPropertyDescription("An array containing CVs and CvGroups")
    @Valid
    private List<Object> cv = new ArrayList<Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public Step() {
    }

    public Step(Step.Type type, List<Condition> condition, List<Object> cv) {
        super();
        this.type = type;
        this.condition = condition;
        this.cv = cv;
    }

    @JsonProperty("type")
    public Step.Type getType() {
        return type;
    }

    @JsonProperty("type")
    public void setType(Step.Type type) {
        this.type = type;
    }

    public Step withType(Step.Type type) {
        this.type = type;
        return this;
    }

    @JsonProperty("condition")
    public List<Condition> getCondition() {
        return condition;
    }

    @JsonProperty("condition")
    public void setCondition(List<Condition> condition) {
        this.condition = condition;
    }

    public Step withCondition(List<Condition> condition) {
        this.condition = condition;
        return this;
    }

    /**
     * An array containing CVs and CvGroups
     * 
     */
    @JsonProperty("cv")
    public List<Object> getCv() {
        return cv;
    }

    /**
     * An array containing CVs and CvGroups
     * 
     */
    @JsonProperty("cv")
    public void setCv(List<Object> cv) {
        this.cv = cv;
    }

    public Step withCv(List<Object> cv) {
        this.cv = cv;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Step.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("condition");
        sb.append('=');
        sb.append(((this.condition == null)?"<null>":this.condition));
        sb.append(',');
        sb.append("cv");
        sb.append('=');
        sb.append(((this.cv == null)?"<null>":this.cv));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.condition == null)? 0 :this.condition.hashCode()));
        result = ((result* 31)+((this.cv == null)? 0 :this.cv.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Step) == false) {
            return false;
        }
        Step rhs = ((Step) other);
        return ((((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type)))&&((this.condition == rhs.condition)||((this.condition!= null)&&this.condition.equals(rhs.condition))))&&((this.cv == rhs.cv)||((this.cv!= null)&&this.cv.equals(rhs.cv))));
    }

    @Generated("jsonschema2pojo")
    public enum Type {

        MANUFACTURER_ID("manufacturerId"),
        MANUFACTURER_EXTENDED_ID("manufacturerExtendedId"),
        DECODER_ID("decoderId"),
        FIRMWARE_VERSION("firmwareVersion"),
        SERIAL_NUMBER("serialNumber");
        private final String value;
        private final static Map<String, Step.Type> CONSTANTS = new HashMap<String, Step.Type>();

        static {
            for (Step.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Step.Type fromValue(String value) {
            Step.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
