package org.bidib.jbidibc.decoder.decoderdb;

import org.bidib.jbidibc.decoder.json.DecoderDbStatusResponse;
import org.bidib.jbidibc.decoder.json.DecoderDbStatusResponse.DecoderStatusResponse;
import org.bidib.jbidibc.decoder.schema.manufacturers.ManufacturersList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoderFirmwareDefinitionAccess extends AbstractDecoderDbAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecoderFirmwareDefinitionAccess.class);

    public ManufacturersList fetchManufacturers(String login, String password) {

        ManufacturersList listManufacturers =
            fetch(login, password.toCharArray(), REST_SERVICE_URI + "/Manufacturers.json", ManufacturersList.class,
                DataFormat.json);

        LOGGER.info("Retrieved listManufacturers: {}", listManufacturers);

        return listManufacturers;
    }

    public DecoderDbStatusResponse fetchRepository(String login, String password) {
        DecoderDbStatusResponse repository =
            AbstractDecoderDbAccess
                .fetch(login, password.toCharArray(), REST_SERVICE_URI + "/repository.json",
                    DecoderDbStatusResponse.class, DataFormat.json);
        return repository;
    }

    public DecoderStatusResponse[] fetchDecoders(String login, String password) {
        DecoderDbStatusResponse repository =
            AbstractDecoderDbAccess
                .fetch(login, password.toCharArray(), REST_SERVICE_URI + "/repository.json",
                    DecoderDbStatusResponse.class, DataFormat.json);

        return repository.getDecoder();
    }

}
