package org.bidib.jbidibc.decoder.json;

import java.io.IOException;
import java.util.Iterator;

import org.bidib.jbidibc.decoder.schema.manufacturers.ManufacturerType;
import org.bidib.jbidibc.decoder.schema.manufacturers.ManufacturersType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;

public class ManufacturersTypeDeserializer extends StdDeserializer<ManufacturersType> {

    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(ManufacturersTypeDeserializer.class);

    public ManufacturersTypeDeserializer() {
        this(null);
    }

    public ManufacturersTypeDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public ManufacturersType deserialize(JsonParser jp, DeserializationContext ctxt)
        throws IOException, JsonProcessingException {

        JsonNode node = jp.getCodec().readTree(jp);

        LOGGER.debug("Current node: {}", node);

        final ManufacturersType manufacturersType = new ManufacturersType();

        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode) node;
            for (Iterator<JsonNode> element = arrayNode.elements(); element.hasNext();) {
                JsonNode next = element.next();

                JavaType javaType = ctxt.getTypeFactory().constructType(ManufacturerType.class);
                JsonDeserializer<?> deserializer = ctxt.findRootValueDeserializer(javaType);
                JsonParser parser = next.traverse(jp.getCodec());
                parser.nextToken();
                ManufacturerType manufacturerType = (ManufacturerType) deserializer.deserialize(parser, ctxt);

                manufacturersType.getManufacturer().add(manufacturerType);
            }

        }

        // int majorVersion = 0;
        // int minorVersion = 0;
        // if (node instanceof ObjectNode) {
        // majorVersion = (Integer) (((IntNode) node.findValue("major")).numberValue());
        // minorVersion = (Integer) (((IntNode) node.findValue("minor")).numberValue());
        // }
        // else {
        // String[] values = node.textValue().split("\\.");
        //
        // majorVersion = Integer.valueOf(values[0]);
        // minorVersion = Integer.valueOf(values[1]);
        // }
        return manufacturersType;
    }

}
