/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.decoder.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.assertj.core.api.Assertions;
import org.bidib.jbidibc.decoder.decoderdb.AbstractDecoderDbAccess;
import org.bidib.jbidibc.decoder.decoderdb.ProxyUtils;
import org.bidib.jbidibc.decoder.json.DecoderDbStatusResponse;
import org.bidib.jbidibc.decoder.schema.decoderdetection.DecoderDetection;
import org.bidib.jbidibc.decoder.schema.decoderdetection.ProtocolsType;
import org.bidib.jbidibc.decoder.schema.manufacturers.ManufacturerType;
import org.bidib.jbidibc.decoder.schema.manufacturers.ManufacturersList;
import org.bidib.jbidibc.decoderdetection.DecoderDetectionFactory;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class DecoderDbStatusResponseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecoderDbStatusResponseTest.class);
    private static final String REST_SERVICE_URI = "https://www.fichtelbahn.de/files/decoderDB";

    @Test
    @Order(value=1)
    public void loadRepositoryJsonLocal() throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
        InputStream is = DecoderDbStatusResponseTest.class.getResourceAsStream("/json/repository.json");
        Assertions.assertThat((InputStream)is).isNotNull();
        DecoderDbStatusResponse listAll = (DecoderDbStatusResponse)mapper.readValue(is, DecoderDbStatusResponse.class);
        LOGGER.info("Loaded repository.json: {}", (Object)listAll);
        Assertions.assertThat((Object)listAll).isNotNull();
        Assertions.assertThat((Object)listAll.getManufacturers()).isNotNull();
        Assertions.assertThat((String)listAll.getManufacturers().getFilename()).isEqualTo("Manufacturers.decdb");
        LocalDate cal = LocalDate.of(2021, Month.MARCH, 6);
        Assertions.assertThat((LocalDate)listAll.getManufacturers().getNmraListDate()).isEqualTo((Object)cal);
        Assertions.assertThat((Object)listAll.getDecoderDetections()).isNotNull();
        Assertions.assertThat((String)listAll.getDecoderDetections().getFilename()).isEqualTo("DecoderDetection.decdb");
        Assertions.assertThat((String)listAll.getDecoderDetections().getLink()).isEqualTo("https://www.fichtelbahn.de/files/decoderDB/DecoderDetection.decdb");
        Assertions.assertThat((Object[])listAll.getDecoder()).isNotNull();
        Assertions.assertThat((int)listAll.getDecoder().length).isGreaterThan(220);
        DecoderDbStatusResponse.DecoderStatusResponse product = listAll.getDecoder()[0];
        Assertions.assertThat((Object)product).isNotNull();
        Assertions.assertThat((String)product.getFilename()).isEqualTo("Decoder_0_NMRA-Standard.decdb");
        Assertions.assertThat((Integer)product.getManufacturerId()).isEqualTo((Object)0);
        Assertions.assertThat((Integer)product.getManufacturerExtendedId()).isEqualTo(0);
        Assertions.assertThat((String)product.getName()).isEqualTo("NMRA-Standard");
        product = listAll.getDecoder()[1];
        Assertions.assertThat((Object)product).isNotNull();
        Assertions.assertThat((String)product.getFilename()).isEqualTo("Decoder_0_StandardSUSI.decdb");
        Assertions.assertThat((Integer)product.getManufacturerId()).isEqualTo(0);
        Assertions.assertThat((Integer)product.getManufacturerExtendedId()).isEqualTo(0);
        Assertions.assertThat((String)product.getName()).isEqualTo("Standard SUSI");
    }

    @Test
    @Order(value=2)
    public void listManufacturersRemote() throws MalformedURLException, URISyntaxException {
        LOGGER.info("listManufacturersRemote");
        ManufacturersList listManufacturers = (ManufacturersList)AbstractDecoderDbAccess.fetch((String)"cv", (char[])"cv".toCharArray(), (String)"https://www.fichtelbahn.de/files/decoderDB/Manufacturers.decdb", ManufacturersList.class, (AbstractDecoderDbAccess.DataFormat)AbstractDecoderDbAccess.DataFormat.xml);
        LOGGER.info("Retrieved listManufacturers: {}", (Object)listManufacturers);
        Assertions.assertThat((Object)listManufacturers).isNotNull();
        Assertions.assertThat((Object)listManufacturers.getManufacturers()).isNotNull();
        Assertions.assertThat((List)listManufacturers.getManufacturers().getManufacturer()).isNotNull();
        Assertions.assertThat((List)listManufacturers.getManufacturers().getManufacturer()).isNotEmpty();
        int ID = 13;
        List manufacturers = listManufacturers.getManufacturers().getManufacturer();
        ManufacturerType manufacturerDiy = (ManufacturerType)IterableUtils.find((Iterable)manufacturers, (Predicate)new Predicate<ManufacturerType>(){

            public boolean evaluate(ManufacturerType manufacturer) {
                return manufacturer.getId() == 13;
            }
        });
        Assertions.assertThat((Object)manufacturerDiy).isNotNull();
        LOGGER.info("Found DIY manufacturer: {}", (Object)manufacturerDiy);
        final Integer EXTENDED_ID_OPENDCC = 258;
        ManufacturerType manufacturerOpenDcc = (ManufacturerType)IterableUtils.find((Iterable)manufacturers, (Predicate)new Predicate<ManufacturerType>(){

            public boolean evaluate(ManufacturerType manufacturer) {
                return manufacturer.getId() == 13 && EXTENDED_ID_OPENDCC.equals(manufacturer.getExtendedId());
            }
        });
        Assertions.assertThat((Object)manufacturerOpenDcc).isNotNull();
        LOGGER.info("Found OpenDCC manufacturer: {}", (Object)manufacturerOpenDcc);
    }

    @Test
    @Order(value=2)
    public void loadRepositoryJsonRemote() throws MalformedURLException, URISyntaxException {
        LOGGER.info("loadRepositoryJsonRemote");
        DecoderDbStatusResponse repository = (DecoderDbStatusResponse)AbstractDecoderDbAccess.fetch((String)"cv", (char[])"cv".toCharArray(), (String)"https://www.fichtelbahn.de/files/decoderDB/repository.json", DecoderDbStatusResponse.class, (AbstractDecoderDbAccess.DataFormat)AbstractDecoderDbAccess.DataFormat.json);
        LOGGER.info("Retrieved listAll: {}", (Object)repository);
        DecoderDbStatusResponse.ManufacturersStatusResponse manufacturersStatusResponse = repository.getManufacturers();
        Assertions.assertThat((Object)manufacturersStatusResponse).isNotNull();
        LocalDate nmraListDate = manufacturersStatusResponse.getNmraListDate();
        Assertions.assertThat((LocalDate)nmraListDate).isNotNull();
        LocalDateTime lastUpdate = manufacturersStatusResponse.getLastUpdate();
        Assertions.assertThat((LocalDateTime)lastUpdate).isNotNull();
        DecoderDbStatusResponse.DecoderDetectionsStatusResponse decoderDetections = repository.getDecoderDetections();
        Assertions.assertThat((Object)decoderDetections).isNotNull();
        Assertions.assertThat((String)decoderDetections.getLink()).isNotNull();
        Assertions.assertThat((String)decoderDetections.getLink()).isEqualTo("https://www.fichtelbahn.de/files/decoderDB/DecoderDetection.decdb");
        Assertions.assertThat((String)decoderDetections.getFilename()).isNotNull();
        Assertions.assertThat((String)decoderDetections.getFilename()).isEqualTo("DecoderDetection.decdb");
        Object[] decoders = repository.getDecoder();
        Assertions.assertThat((Object[])decoders).isNotNull();
        Assertions.assertThat((int)decoders.length).isGreaterThan(220);
        LOGGER.info("Current decoders: {}", new Object[]{decoders});
        Object[] firmwareItems = repository.getFirmware();
        Assertions.assertThat((Object[])firmwareItems).isNotNull();
        Assertions.assertThat((int)firmwareItems.length).isGreaterThanOrEqualTo(180);
        LOGGER.info("Current firmwareItems: {}", new Object[]{firmwareItems});
        String link = manufacturersStatusResponse.getLink();
        String filename = manufacturersStatusResponse.getFilename();
        LOGGER.info("Current nmraListDate: {}, lastUpdate: {}, filename: {}, link: {}", new Object[]{nmraListDate, lastUpdate, filename, link});
        link = decoderDetections.getLink();
        DecoderDetection decoderDetection = (DecoderDetection)AbstractDecoderDbAccess.fetch((String)"cv", (char[])"cv".toCharArray(), (String)link, val -> new DecoderDetectionFactory().parseDecoderDetection(val));
        Assertions.assertThat((Object)decoderDetection).isNotNull();
        LOGGER.info("Current decoderDetection: {}", (Object)decoderDetection);
        Assertions.assertThat((Object)decoderDetection.getProtocols()).isNotNull();
        ProtocolsType protocolsType = decoderDetection.getProtocols();
        List protocols = protocolsType.getProtocol();
        Assertions.assertThat((List)protocols).hasSizeGreaterThanOrEqualTo(3);
    }

    @Test
    public void proxyTest() throws URISyntaxException, MalformedURLException {
        URL url = new URL("http://www.bidib.org");
        Proxy proxy = ProxyUtils.findProxy((URI)url.toURI());
        LOGGER.info("Current proxy: {}", (Object)proxy);
        if (!Proxy.NO_PROXY.equals(proxy)) {
            try {
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                Properties systemSettings = System.getProperties();
                systemSettings.put("proxySet", "true");
                systemSettings.put("http.proxyHost", addr.getHostName());
                systemSettings.put("http.proxyPort", Integer.toString(addr.getPort()));
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                LOGGER.info(con.getResponseCode() + " : " + con.getResponseMessage());
                LOGGER.info("HTTP_OK: {} ", (Object)(con.getResponseCode() == 200 ? 1 : 0));
            }
            catch (Exception e) {
                LOGGER.warn("Check connection failed.", (Throwable)e);
            }
        }
    }
}

