/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.decoder.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.assertj.core.api.Assertions;
import org.bidib.jbidibc.decoder.decoderdb.DecoderFirmwareDefinitionAccess;
import org.bidib.jbidibc.decoder.json.ManufacturersTypeDeserializer;
import org.bidib.jbidibc.decoder.schema.manufacturers.ManufacturerType;
import org.bidib.jbidibc.decoder.schema.manufacturers.ManufacturersList;
import org.bidib.jbidibc.decoder.schema.manufacturers.ManufacturersType;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManufacturerAccessTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManufacturerAccessTest.class);

    @Test
    public void fetchJson() {
        LOGGER.info("Fetch manufacturers from DecoderDB.");
        DecoderFirmwareDefinitionAccess manufacturerAccess = new DecoderFirmwareDefinitionAccess();
        ManufacturersList listManufacturers = manufacturerAccess.fetchManufacturers("cv", "cv");
        LOGGER.info("Retrieved listManufacturers: {}", (Object)listManufacturers);
        Assertions.assertThat((Object)listManufacturers).isNotNull();
        Assertions.assertThat((Object)listManufacturers.getManufacturers()).isNotNull();
        Assertions.assertThat((List)listManufacturers.getManufacturers().getManufacturer()).isNotNull();
        Assertions.assertThat((List)listManufacturers.getManufacturers().getManufacturer()).isNotEmpty();
        int ID = 13;
        List manufacturers = listManufacturers.getManufacturers().getManufacturer();
        ManufacturerType manufacturerDiy = (ManufacturerType)IterableUtils.find((Iterable)manufacturers, (Predicate)new Predicate<ManufacturerType>(){

            public boolean evaluate(ManufacturerType manufacturer) {
                return manufacturer.getId() == 13;
            }
        });
        Assertions.assertThat((Object)manufacturerDiy).isNotNull();
        LOGGER.info("Found DIY manufacturer: {}", (Object)manufacturerDiy);
        final Integer EXTENDED_ID_OPENDCC = 258;
        ManufacturerType manufacturerOpenDcc = (ManufacturerType)IterableUtils.find((Iterable)manufacturers, (Predicate)new Predicate<ManufacturerType>(){

            public boolean evaluate(ManufacturerType manufacturer) {
                return manufacturer.getId() == 13 && EXTENDED_ID_OPENDCC.equals(manufacturer.getExtendedId());
            }
        });
        Assertions.assertThat((Object)manufacturerOpenDcc).isNotNull();
        LOGGER.info("Found OpenDCC manufacturer: {}", (Object)manufacturerOpenDcc);
    }

    @Test
    public void loadManufacturersJsonLocal() throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
        SimpleModule module = new SimpleModule();
        module.addDeserializer(ManufacturersType.class, (JsonDeserializer)new ManufacturersTypeDeserializer());
        mapper.registerModule((Module)module);
        InputStream is = ManufacturerAccessTest.class.getResourceAsStream("/manufacturers/Manufacturers.json");
        Assertions.assertThat((InputStream)is).isNotNull();
        ManufacturersList listAll = (ManufacturersList)mapper.reader().forType(ManufacturersList.class).readValue(is);
        LOGGER.info("Loaded Manufacturers.json: {}", (Object)listAll);
        Assertions.assertThat((Object)listAll).isNotNull();
        Assertions.assertThat((Object)listAll.getManufacturers()).isNotNull();
        Assertions.assertThat((List)listAll.getManufacturers().getManufacturer()).hasSizeGreaterThan(10);
    }
}

