/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.decoder.external;

import eu.esu._2010.lokprogrammer.metadata.MetaType;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.UnmarshalException;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.bidib.jbidibc.core.schema.exception.InvalidSchemaException;
import org.bidib.jbidibc.decoder.schema.decoder.DecoderDefinitionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EsuXReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(EsuXReader.class);
    private static JAXBContext jaxbContext;
    private static final String JAXB_PACKAGE = "eu.esu._2010.lokprogrammer.metadata";
    public static final String XSD_LOCATION = "/xsd/external/esuMetaData.xsd";
    public static final String XSD_LANGUAGE_LOCATION = "/xsd/external/xml.xsd";

    public String getMetaData(InputStream esuxFile) throws FileNotFoundException, IOException {
        StringBuilder sb;
        block10: {
            sb = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(esuxFile));){
                char[] prolog = new char[3];
                if (br.read(prolog, 0, 3) == 3 && !String.valueOf(prolog).equals("ESU")) {
                    LOGGER.warn("The prolog is invalid. Expected 'ESU'.");
                    throw new IllegalArgumentException("The prolog is invalid. Expected 'ESU'.");
                }
                int last = -1;
                while ((last = br.read()) != 60 && last != -1) {
                }
                if (last == 60) {
                    LOGGER.info("Found the start of the xml declaration.");
                    sb.append("<");
                    String line = null;
                    do {
                        line = br.readLine();
                        LOGGER.info("Current line: {}", (Object)line);
                        int endIndex = -1;
                        endIndex = line.indexOf("</meta>");
                        if (endIndex > 0) {
                            LOGGER.info("Found the end of the meta data at endIndex: {}", (Object)endIndex);
                            sb.append(line.substring(0, endIndex + "</meta>".length()));
                            break block10;
                        }
                        sb.append(line);
                    } while (line != null);
                    break block10;
                }
                LOGGER.warn("No start of the xml declaration found.");
            }
        }
        return sb.toString();
    }

    public MetaType getMetaType(String source) {
        MetaType meta = null;
        try {
            if (jaxbContext == null) {
                LOGGER.info("Create the jaxb context for Meta.");
                jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGE);
            }
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSourceSchemaLanguage = new StreamSource(DecoderDefinitionFactory.class.getResourceAsStream(XSD_LANGUAGE_LOCATION));
            StreamSource streamSourceSchema = new StreamSource(DecoderDefinitionFactory.class.getResourceAsStream(XSD_LOCATION));
            Schema schema = schemaFactory.newSchema(new Source[]{streamSourceSchemaLanguage, streamSourceSchema});
            unmarshaller.setSchema(schema);
            JAXBElement metaElement = (JAXBElement)unmarshaller.unmarshal((Reader)new StringReader(source));
            meta = (MetaType)metaElement.getValue();
        }
        catch (UnmarshalException ex) {
            LOGGER.warn("Load Meta from provided source failed with UnmarshalException.", (Throwable)ex);
            if (ex.getCause() instanceof SAXParseException) {
                throw new InvalidSchemaException("Load Meta from provided source failed.");
            }
            throw new IllegalArgumentException("Load Meta from provided source failed with UnmarshalException.");
        }
        catch (JAXBException | SAXException ex) {
            LOGGER.warn("Load Meta from provided source failed: {}", ex);
            throw new InvalidSchemaException("Load Meta from provided source failed.");
        }
        catch (Exception ex) {
            LOGGER.warn("Load Meta from provided source failed: {}", (Throwable)ex);
            throw new RuntimeException("Load Meta from provided source failed.");
        }
        return meta;
    }
}

