/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.decoderdetection;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.UnmarshalException;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.exception.InvalidContentException;
import org.bidib.jbidibc.core.schema.exception.InvalidSchemaException;
import org.bidib.jbidibc.core.schema.validation.XsdValidationLoggingErrorHandler;
import org.bidib.jbidibc.decoder.schema.decoder.DecoderDefinitionFactory;
import org.bidib.jbidibc.decoder.schema.decoderdetection.DecoderDetection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DecoderDetectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecoderDetectionFactory.class);
    private static JAXBContext jaxbContext;
    private static final String JAXB_PACKAGE = "org.bidib.jbidibc.decoder.schema.decoderdetection";
    public static final String XSD_LOCATION = "/xsd/decoderDetection.xsd";
    public static final String XSD_LOCATION_COMMON_TYPES = "/xsd/commonTypes.xsd";

    public DecoderDetection parseDecoderDetection(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            LOGGER.error("The DecoderDetection value is empty!");
            return null;
        }
        LOGGER.info("Load DecoderDetection from provided string value.");
        DecoderDetection decoderDetection = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));){
            decoderDetection = this.loadDecoderDetectionFile(is);
            LOGGER.trace("Loaded decoderDetection: {}", (Object)decoderDetection);
        }
        catch (InvalidSchemaException ex) {
            LOGGER.warn("Load saved DecoderDetection from file failed with schema exception: {}", (Object)ex.getMessage());
            try {
                ByteArrayInputStream fis = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
                try {
                    List<String> errors = this.validateDecoderDetectionFile(fis, null);
                    throw new InvalidContentException("Validation of decoderDetection from string content failed.", errors);
                }
                catch (Throwable throwable) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.warn("Load saved DecoderDetection for validation from file failed: {}", (Object)e.getMessage());
            }
        }
        catch (InvalidContentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.warn("Load saved DecoderDetection from string content failed: {}", (Object)ex.getMessage());
        }
        return decoderDetection;
    }

    public DecoderDetection loadDecoderDetection(String filePath) {
        DecoderDetection decoderDetection;
        block15: {
            if (StringUtils.isBlank((CharSequence)filePath)) {
                LOGGER.error("The DecoderDetection file must be specified!");
                return null;
            }
            LOGGER.info("Load DecoderDetection from file: {}", (Object)filePath);
            decoderDetection = null;
            FileInputStream is = null;
            File file = null;
            try {
                file = new File(filePath);
                is = new FileInputStream(file);
                decoderDetection = this.loadDecoderDetectionFile(is);
                LOGGER.trace("Loaded decoderDetection: {}", (Object)decoderDetection);
            }
            catch (InvalidSchemaException ex) {
                LOGGER.warn("Load saved DecoderDetection from file failed with schema exception: {}", (Object)ex.getMessage());
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOGGER.warn("Close input stream failed.", (Throwable)e);
                    }
                    is = null;
                }
                if (file == null) break block15;
                try {
                    FileInputStream fis = new FileInputStream(file);
                    try {
                        List<String> errors = this.validateDecoderDetectionFile(fis, filePath);
                        throw new InvalidContentException("Validation of DecoderDetection file failed: " + filePath, errors);
                    }
                    catch (Throwable throwable) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Load saved DecoderDetection for validation from file failed: {}", (Object)e.getMessage());
                }
            }
            catch (FileNotFoundException | IllegalArgumentException ex) {
                LOGGER.warn("Load saved DecoderDetection from file failed: {}", (Object)ex.getMessage());
            }
            catch (InvalidContentException ex) {
                throw ex;
            }
            catch (Exception ex) {
                LOGGER.warn("Load saved DecoderDetection from file failed: {}", (Object)ex.getMessage());
            }
        }
        return decoderDetection;
    }

    protected String getDecoderDetectionFileName() {
        return "test";
    }

    private List<String> validateDecoderDetectionFile(InputStream is, String filePath) {
        LOGGER.info("Validate decoderDetection file: {}", (Object)filePath);
        List errors = null;
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSourceSchemaCommonTypes = new StreamSource(DecoderDefinitionFactory.class.getResourceAsStream(XSD_LOCATION_COMMON_TYPES));
            StreamSource streamSourceSchema = new StreamSource(DecoderDefinitionFactory.class.getResourceAsStream(XSD_LOCATION));
            Schema schema = schemaFactory.newSchema(new Source[]{streamSourceSchemaCommonTypes, streamSourceSchema});
            StreamSource streamSource = new StreamSource(is);
            Validator validator = schema.newValidator();
            XsdValidationLoggingErrorHandler errorHandler = new XsdValidationLoggingErrorHandler();
            validator.setErrorHandler((ErrorHandler)errorHandler);
            validator.validate(streamSource);
            errors = errorHandler.getErrors();
        }
        catch (Exception ex) {
            LOGGER.warn("Validate DecoderDetection from file failed: {}", (Object)this.getDecoderDetectionFileName(), (Object)ex);
            throw new InvalidSchemaException("Load DecoderDetection from file failed.");
        }
        return errors;
    }

    private DecoderDetection loadDecoderDetectionFile(InputStream is) {
        LOGGER.info("Load DecoderDetection file.");
        DecoderDetection decoderDetection = null;
        try {
            if (jaxbContext == null) {
                LOGGER.info("Create the jaxb context for DecoderDetection.");
                jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGE);
            }
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSourceSchemaCommonTypes = new StreamSource(DecoderDefinitionFactory.class.getResourceAsStream(XSD_LOCATION_COMMON_TYPES));
            StreamSource streamSourceSchema = new StreamSource(DecoderDefinitionFactory.class.getResourceAsStream(XSD_LOCATION));
            Schema schema = schemaFactory.newSchema(new Source[]{streamSourceSchemaCommonTypes, streamSourceSchema});
            unmarshaller.setSchema(schema);
            decoderDetection = (DecoderDetection)unmarshaller.unmarshal(is);
        }
        catch (UnmarshalException ex) {
            LOGGER.warn("Load DecoderDetection from file failed with UnmarshalException.", (Throwable)ex);
            if (ex.getCause() instanceof SAXParseException) {
                throw new InvalidSchemaException("Load DecoderDetection from file failed");
            }
            throw new IllegalArgumentException("Load DecoderDetection from file failed with UnmarshalException.");
        }
        catch (JAXBException | SAXException ex) {
            LOGGER.warn("Load DecoderDetection from file failed: {}", (Object)this.getDecoderDetectionFileName(), (Object)ex);
            throw new InvalidSchemaException("Load DecoderDetection from file failed: " + this.getDecoderDetectionFileName());
        }
        catch (Exception ex) {
            LOGGER.warn("Load DecoderDetection from file failed: {}", (Object)this.getDecoderDetectionFileName(), (Object)ex);
            throw new RuntimeException("Load DecoderDetection from file failed: " + this.getDecoderDetectionFileName());
        }
        return decoderDetection;
    }
}

