/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.gateway;

import com.google.common.eventbus.EventBus;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bidib.jbidib.pi.BiDiBPiConnector;
import org.bidib.jbidibc.core.AbstractBidib;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.ConnectionListener;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.MessageReceiver;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.exception.PortNotFoundException;
import org.bidib.jbidibc.core.exception.PortNotOpenedException;
import org.bidib.jbidibc.core.helpers.Context;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.bidib.jbidibc.gateway.GatewayMessageReceiver;
import org.bidib.jbidibc.gateway.GatewayNetMessageHandler;
import org.bidib.jbidibc.gateway.event.PortEvent;
import org.bidib.jbidibc.gateway.event.PortEventListener;
import org.bidib.jbidibc.net.NetBidibPort;
import org.bidib.jbidibc.net.NetBidibServerTcpPort;
import org.bidib.jbidibc.net.NetBidibUdpPort;
import org.bidib.jbidibc.net.NetMessageHandler;
import org.bidib.jbidibc.net.exception.ClientNotAcceptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayBidib
extends AbstractBidib {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayBidib.class);
    private NetBidibPort port;
    private Thread portWorker;
    private NetMessageHandler netMessageHandler;
    private String connectedPortName;
    private InetAddress address;
    private int portNumber;
    private String protocol;
    private BiDiBPiConnector piConnector;
    private ConnectionListener localConnectionListener;
    private PortEventListener portEventListener;
    private EventBus eventBus;

    public static BidibInterface createInstance() {
        LOGGER.info("Create new instance of GatewayBidib.");
        GatewayBidib instance = new GatewayBidib();
        instance.initialize();
        return instance;
    }

    private GatewayBidib() {
    }

    protected void initialize() {
        this.portEventListener = new PortEventListener(){

            @Override
            protected void handlePortEvent(PortEvent event) {
                super.handlePortEvent(event);
            }
        };
        this.eventBus = new EventBus(GatewayBidib.class.getSimpleName());
        this.eventBus.register((Object)this.portEventListener);
        try {
            GpioProvider gpioProvider = GpioFactory.getDefaultProvider();
            if (gpioProvider != null) {
                LOGGER.info("Found GpioProvider. Prepare the BiDiBPiConnector.");
                this.piConnector = new BiDiBPiConnector();
                this.piConnector.connect();
            } else {
                LOGGER.info("No GpioProvider found. Cannot prepare the BiDiBPiConnector.");
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Get GPIO provider failed.", (Throwable)ex);
        }
        catch (UnsatisfiedLinkError ex) {
            LOGGER.warn("Get GPIO provider failed.", (Throwable)ex);
        }
        super.initialize();
    }

    protected BidibMessageProcessor createMessageReceiver(NodeRegistry nodeFactory) {
        return new GatewayMessageReceiver(nodeFactory);
    }

    private MessageReceiver getNetMessageReceiver() {
        return (MessageReceiver)this.getMessageReceiver();
    }

    public void setConnectionListener(final ConnectionListener connectionListener) {
        this.localConnectionListener = new ConnectionListener(){

            public void status(String messageKey) {
                LOGGER.info("Status was signaled: {}", (Object)messageKey);
                connectionListener.status(messageKey);
            }

            public void opened(String port) {
                LOGGER.info("Port was opened: {}", (Object)port);
                GatewayBidib.this.eventBus.post((Object)new PortEvent("Port was opened: " + port));
                connectionListener.opened(port);
            }

            public void closed(String port) {
                LOGGER.info("Port was closed: {}", (Object)port);
                GatewayBidib.this.eventBus.post((Object)new PortEvent("Port was closed: " + port));
                connectionListener.closed(port);
            }
        };
        super.setConnectionListener(this.localConnectionListener);
    }

    public void open(String portName, ConnectionListener connectionListener, Set<NodeListener> nodeListeners, Set<MessageListener> messageListeners, Set<TransferListener> transferListeners, Context context) throws PortNotFoundException, PortNotOpenedException {
        LOGGER.info("Open port: {}", (Object)portName);
        try {
            this.close();
        }
        catch (Exception ex) {
            LOGGER.warn("Make sure port is closed before open port and send magic failed.", (Throwable)ex);
        }
        this.setConnectionListener(connectionListener);
        this.registerListeners(nodeListeners, messageListeners, transferListeners);
        if (this.port == null) {
            LOGGER.info("Open port with name: {}", (Object)portName);
            if (portName == null || portName.trim().isEmpty()) {
                throw new PortNotFoundException("");
            }
            if (portName.indexOf(":") < 0) {
                portName = portName + ":62875";
                LOGGER.info("Added portnumber to portName: {}", (Object)portName);
            }
            try {
                this.port = this.internalOpen(portName, context);
                this.connectedPortName = portName;
                LOGGER.info("Port is opened, send the magic. The connected port is: {}", (Object)this.connectedPortName);
                this.getRootNode();
            }
            catch (Exception ex) {
                LOGGER.warn("Open port and send magic failed.", (Throwable)ex);
                throw new PortNotOpenedException(portName, "unknown");
            }
        } else {
            LOGGER.warn("Port is already opened.");
        }
    }

    private NetBidibPort internalOpen(String portName, Context context) throws IOException {
        LOGGER.info("Internal open port: {}", (Object)portName);
        String[] hostAndPort = portName.split(":");
        if (hostAndPort.length > 2) {
            this.protocol = hostAndPort[0];
            this.address = InetAddress.getByName(hostAndPort[1]);
            this.portNumber = Integer.parseInt(hostAndPort[2]);
        } else {
            this.protocol = "tcp";
            this.address = InetAddress.getByName(hostAndPort[0]);
            this.portNumber = Integer.parseInt(hostAndPort[1]);
        }
        LOGGER.info("Configured address: {}, portNumber: {}, protocol: {}", new Object[]{this.address, this.portNumber, this.protocol});
        BidibMessageProcessor messageReceiver = this.getMessageReceiver();
        if (context != null) {
            Boolean ignoreWrongMessageNumber = (Boolean)context.get("ignoreWrongMessageNumber", Boolean.class, (Object)Boolean.FALSE);
            messageReceiver.setIgnoreWrongMessageNumber(ignoreWrongMessageNumber.booleanValue());
        }
        this.getNetMessageReceiver().enable();
        this.netMessageHandler = new GatewayNetMessageHandler(messageReceiver){

            @Override
            public void acceptClient(String remoteHost) {
                LOGGER.info("A new client applied for a connection: {}", (Object)remoteHost);
                if (GatewayBidib.this.piConnector != null) {
                    boolean pairingAllowed = GatewayBidib.this.piConnector.acceptClient(remoteHost);
                    if (!pairingAllowed) {
                        LOGGER.warn("Pairing is not allowed! Current remoteHost: {}", (Object)remoteHost);
                        throw new ClientNotAcceptedException("Pairing is not allowed for remoteHost: " + remoteHost);
                    }
                    LOGGER.info("Pairing is allowed!");
                } else {
                    super.acceptClient(remoteHost);
                }
            }
        };
        NetBidibServerTcpPort netBidibPort = null;
        if ("tcp".equalsIgnoreCase(this.protocol)) {
            LOGGER.info("Create a NetBidibTcpPort with the portnumber: {}", (Object)62875);
            netBidibPort = new NetBidibServerTcpPort(62875, null, this.netMessageHandler);
        } else {
            LOGGER.info("Create a NetBidibUdpPort with the portnumber: {}", (Object)62875);
            netBidibPort = new NetBidibUdpPort(Integer.valueOf(62875), this.netMessageHandler);
        }
        LOGGER.info("Prepare and start the port worker for netBidibPort: {}", (Object)netBidibPort);
        this.startReceiverAndQueues(messageReceiver, context);
        this.portWorker = new Thread((Runnable)netBidibPort);
        this.portWorker.start();
        return netBidibPort;
    }

    public boolean isOpened() {
        return this.port != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LOGGER.info("Close the port.");
        if (!this.isOpened()) {
            LOGGER.info("The port is not opened. Skip close processing.");
            return;
        }
        if (this.port != null) {
            LOGGER.info("Stop the port.");
            this.port.stop();
            if (this.portWorker != null) {
                Thread thread = this.portWorker;
                synchronized (thread) {
                    try {
                        this.portWorker.join(5000L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warn("Wait for termination of port worker failed.", (Throwable)ex);
                    }
                    this.portWorker = null;
                }
            }
            this.port = null;
        }
        this.stopReceiverAndQueues(null);
        if (this.getConnectionListener() != null) {
            this.getConnectionListener().closed(this.connectedPortName);
        }
        this.connectedPortName = null;
        if (this.piConnector != null) {
            LOGGER.info("Disconnect the piConnector.");
            try {
                this.piConnector.disconnect();
            }
            catch (Exception ex) {
                LOGGER.warn("Disconnect the piConnector failed.", (Throwable)ex);
            }
            this.piConnector = null;
            LOGGER.info("Released the piConnector.");
        }
        LOGGER.info("Close the port finished.");
    }

    public List<String> getPortIdentifiers() {
        return Collections.emptyList();
    }

    protected void sendData(ByteArrayOutputStream data) {
        LOGGER.info("Send data to host/client: {}, netMessageHandler: {}", (Object)ByteUtils.bytesToHex((byte[])data.toByteArray()), (Object)this.netMessageHandler);
        this.netMessageHandler.send(this.port, data.toByteArray());
    }
}

