/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.gateway;

import com.serialpundit.core.SerialComException;
import com.serialpundit.serial.ISerialComDataListener;
import com.serialpundit.serial.ISerialComEventListener;
import com.serialpundit.serial.SerialComLineEvent;
import com.serialpundit.serial.SerialComManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.exception.InvalidLibraryException;
import org.bidib.jbidibc.core.helpers.Context;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.bidib.jbidibc.gateway.GatewayResponseReceiver;
import org.bidib.jbidibc.serial.AbstractSerialBidib;
import org.bidib.jbidibc.serial.SerialMessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewaySerialBidib
extends AbstractSerialBidib {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewaySerialBidib.class);
    private static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"RAW");
    private SerialComManager scm;
    private long handle = -1L;
    private ISerialComDataListener dataListener;
    private ISerialComEventListener eventListener;
    private boolean addEventListener = false;
    private boolean useHardwareFlowControl = false;
    private ByteArrayOutputStream output = new ByteArrayOutputStream(100);

    private GatewaySerialBidib() {
    }

    public static BidibInterface createInstance() {
        LOGGER.info("Create new instance of GatewaySerialBidib.");
        GatewaySerialBidib instance = new GatewaySerialBidib();
        instance.initialize();
        return instance;
    }

    protected BidibMessageProcessor createMessageReceiver(NodeRegistry nodeRegistry) {
        LOGGER.info("Set the ignoreMissingTransferListeners flag on the NodeRegistry.");
        nodeRegistry.setIgnoreMissingTransferListeners(true);
        return new GatewayResponseReceiver(nodeRegistry);
    }

    public void close() {
        if (this.scm != null) {
            LOGGER.info("Close the port, handle: {}", (Object)this.handle);
            long start = System.currentTimeMillis();
            LOGGER.info("Unregister data listener: {}", (Object)this.dataListener);
            if (this.dataListener != null && this.handle > 0L) {
                try {
                    this.scm.unregisterDataListener(this.handle, this.dataListener);
                }
                catch (SerialComException ex) {
                    LOGGER.warn("Unregister dataListener failed.", (Throwable)ex);
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Sleep after unregister data listener failed.", (Throwable)ex);
                }
            }
            this.dataListener = null;
            if (this.eventListener != null && this.handle > 0L) {
                LOGGER.info("Unregister line event listener.");
                try {
                    this.scm.unregisterLineEventListener(this.handle, this.eventListener);
                }
                catch (SerialComException ex) {
                    LOGGER.warn("Unregister lineEventListener failed.", (Throwable)ex);
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Sleep after unregister line event listener failed.", (Throwable)ex);
                }
            }
            this.eventListener = null;
            BidibMessageProcessor serialMessageReceiver = this.getMessageReceiver();
            this.stopReceiverAndQueues(serialMessageReceiver);
            if (this.handle > 0L) {
                try {
                    LOGGER.info("Close the COM port: {}", (Object)this.handle);
                    this.scm.closeComPort(this.handle);
                }
                catch (Exception e) {
                    LOGGER.warn("Close port failed.", (Throwable)e);
                }
            } else {
                LOGGER.info("Don't close port because handle is not valid.");
            }
            long end = System.currentTimeMillis();
            LOGGER.info("Closed the port. duration: {}", (Object)(end - start));
            this.setConnected(false);
            this.scm = null;
            this.handle = -1L;
            this.cleanupAfterClose(serialMessageReceiver);
        } else {
            LOGGER.info("No port to close available.");
        }
    }

    public List<String> getPortIdentifiers() {
        ArrayList<String> portIdentifiers = new ArrayList<String>();
        try {
            String[] ports;
            String tempDir = System.getProperty("java.io.tmpdir");
            File temp = new File(tempDir, "jbidibc");
            if (this.scm == null) {
                LOGGER.info("Create the scm instance.");
                this.scm = new SerialComManager("scm", temp.getAbsolutePath(), true, false);
            }
            for (String portIdentifier : ports = this.scm.listAvailableComPorts()) {
                portIdentifiers.add(portIdentifier);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)ule);
            throw new InvalidLibraryException(ule.getMessage(), ule.getCause());
        }
        catch (Error error) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)error);
            throw new RuntimeException(error.getMessage(), error.getCause());
        }
        catch (IOException ex) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)ex);
            throw new InvalidLibraryException(ex.getMessage(), ex.getCause());
        }
        return portIdentifiers;
    }

    protected boolean isImplAvaiable() {
        return this.scm != null;
    }

    private SerialComManager.BAUDRATE getBaudRate(int baudRate) {
        for (SerialComManager.BAUDRATE br : SerialComManager.BAUDRATE.values()) {
            if (br.getValue() != baudRate) continue;
            return br;
        }
        return SerialComManager.BAUDRATE.B115200;
    }

    protected void internalOpen(String portName, Context context) throws Exception {
        BidibMessageProcessor serialMessageReceiver = this.getMessageReceiver();
        String tempDir = System.getProperty("java.io.tmpdir");
        File temp = new File(tempDir, "jbidibc");
        this.scm = new SerialComManager("scm", temp.getAbsolutePath(), true, false);
        LOGGER.info("Open port with portName: {}", (Object)portName);
        this.handle = this.scm.openComPort(portName, true, true, true);
        LOGGER.info("Opened serial port, handle: {}", (Object)this.handle);
        if (this.useHardwareFlowControl) {
            this.scm.configureComPortControl(this.handle, SerialComManager.FLOWCONTROL.RTS_CTS, 'x', 'x', false, true);
        } else {
            this.scm.configureComPortControl(this.handle, SerialComManager.FLOWCONTROL.NONE, 'x', 'x', false, true);
        }
        Integer baudRate = (Integer)context.get("serial.baudrate", Integer.class, (Object)115200);
        LOGGER.info("Open port with baudRate: {}", (Object)baudRate);
        SerialComManager.BAUDRATE scmBaudRate = this.getBaudRate(baudRate);
        this.scm.configureComPortData(this.handle, SerialComManager.DATABITS.DB_8, SerialComManager.STOPBITS.SB_1, SerialComManager.PARITY.P_NONE, scmBaudRate, 0);
        this.startReceiverAndQueues(serialMessageReceiver, context);
        this.setConnected(true);
        if (this.addEventListener) {
            this.eventListener = new ISerialComEventListener(){

                public void onNewSerialEvent(SerialComLineEvent lineEvent) {
                    LOGGER.error("eventCTS : {}, eventDSR : {}", (Object)lineEvent.getCTS(), (Object)lineEvent.getDSR());
                }
            };
            this.scm.registerLineEventListener(this.handle, this.eventListener);
        }
        this.dataListener = new ISerialComDataListener(){

            public void onNewSerialDataAvailable(byte[] data) {
                MSG_RAW_LOGGER.info("<<<< Serial data available, len: {}", (Object)data.length);
                GatewaySerialBidib.this.receive(data, data.length);
                MSG_RAW_LOGGER.info("<<<< Serial data received.");
            }

            public void onDataListenerError(int errorNum) {
                LOGGER.error("Data listener notified an error: {}", (Object)errorNum);
                if (GatewaySerialBidib.this.isConnected()) {
                    LOGGER.info("Close the port.");
                    GatewaySerialBidib.this.setConnected(false);
                    if (GatewaySerialBidib.this.dataListener != null) {
                        try {
                            LOGGER.info("Unregister data listener.");
                            GatewaySerialBidib.this.scm.unregisterDataListener(GatewaySerialBidib.this.handle, GatewaySerialBidib.this.dataListener);
                            GatewaySerialBidib.this.dataListener = null;
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Unregister data listener after error detection failed.", (Throwable)ex);
                        }
                    }
                    Thread t1 = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            LOGGER.info("Error detected. Close the port.");
                            if (GatewaySerialBidib.this.dataListener != null) {
                                try {
                                    GatewaySerialBidib.this.scm.unregisterDataListener(GatewaySerialBidib.this.handle, GatewaySerialBidib.this.dataListener);
                                    GatewaySerialBidib.this.dataListener = null;
                                }
                                catch (Exception ex) {
                                    LOGGER.warn("Unregister data listener after error detection failed.", (Throwable)ex);
                                }
                            }
                            if (GatewaySerialBidib.this.eventListener != null) {
                                try {
                                    GatewaySerialBidib.this.scm.unregisterLineEventListener(GatewaySerialBidib.this.handle, GatewaySerialBidib.this.eventListener);
                                    GatewaySerialBidib.this.eventListener = null;
                                }
                                catch (Exception ex) {
                                    LOGGER.warn("Unregister event listener after error detection failed.", (Throwable)ex);
                                }
                            }
                            try {
                                GatewaySerialBidib.this.close();
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Close scm port failed.", (Throwable)ex);
                            }
                        }
                    });
                    t1.start();
                } else {
                    LOGGER.info("Port is closed.");
                }
            }
        };
        LOGGER.info("Registering data listener fro handle: {}.", (Object)this.handle);
        this.scm.registerDataListener(this.handle, this.dataListener);
        LOGGER.info("Registered data listener.");
        if (this.useHardwareFlowControl) {
            try {
                LOGGER.info("Activate RTS.");
                this.scm.setRTS(this.handle, true);
            }
            catch (Exception e) {
                LOGGER.warn("Set RTS true failed.", (Throwable)e);
            }
        }
    }

    public boolean isOpened() {
        boolean isOpened = this.handle > 0L;
        return isOpened;
    }

    protected void sendData(ByteArrayOutputStream data) {
        if (this.handle > 0L && data != null) {
            byte[] bytes = data.toByteArray();
            try {
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> [{}] - {}", (Object)bytes.length, (Object)ByteUtils.bytesToHex((byte[])bytes));
                }
                this.output.reset();
                SerialMessageEncoder.encodeMessage((ByteArrayOutputStream)data, (OutputStream)this.output);
                int sent = this.scm.writeBytes(this.handle, this.output.toByteArray());
                if (sent == 0) {
                    MSG_RAW_LOGGER.warn(">> sent bytes: {}", (Object)sent);
                    LOGGER.error("The message has not been sent to handle: {}, message: {}", (Object)this.handle, (Object)ByteUtils.bytesToHex((byte[])bytes));
                    throw new RuntimeException("Write message to output failed: " + ByteUtils.bytesToHex((byte[])bytes));
                }
                MSG_RAW_LOGGER.info(">> sent bytes: {}", (Object)sent);
            }
            catch (Exception ex) {
                LOGGER.warn("Send message to output stream failed: [{}] - {}", new Object[]{bytes.length, ByteUtils.bytesToHex((byte[])bytes), ex});
                throw new RuntimeException("Send message to output stream failed: " + ByteUtils.bytesToHex((byte[])bytes), ex);
            }
            finally {
                this.output.reset();
            }
        }
    }
}

