/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.gateway;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.MessageReceiver;
import org.bidib.jbidibc.core.exception.ProtocolException;
import org.bidib.jbidibc.core.message.BidibCommand;
import org.bidib.jbidibc.core.message.BidibMessage;
import org.bidib.jbidibc.core.message.BidibResponseFactory;
import org.bidib.jbidibc.core.message.RequestFactory;
import org.bidib.jbidibc.core.message.ResponseFactory;
import org.bidib.jbidibc.core.node.BidibNode;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.bidib.jbidibc.gateway.GatewayMessagePeer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayMessageReceiver
extends MessageReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayMessageReceiver.class);
    private AtomicBoolean escapeHot = new AtomicBoolean();
    private ByteArrayOutputStream output = new ByteArrayOutputStream(2048);
    private RequestFactory requestFactory;
    private GatewayMessagePeer gatewayMessagePeer;

    public GatewayMessageReceiver(NodeRegistry nodeRegistry) {
        super(nodeRegistry, (ResponseFactory)new BidibResponseFactory(), false);
    }

    private synchronized RequestFactory getRequestFactory() {
        if (this.requestFactory == null) {
            this.requestFactory = new RequestFactory();
        }
        return this.requestFactory;
    }

    public void setGatewayMessagePeer(GatewayMessagePeer gatewayMessagePeer) {
        LOGGER.info("Set the gatewayMessagePeer: {}", (Object)gatewayMessagePeer);
        this.gatewayMessagePeer = gatewayMessagePeer;
    }

    public void enable() {
        LOGGER.info("enable is called.");
        this.escapeHot.set(false);
        MSG_RAW_LOGGER.info("++++ Enable the message receiver.");
        try {
            this.output.reset();
        }
        catch (Exception ex) {
            LOGGER.warn("Reset buffered received data failed.", (Throwable)ex);
        }
        super.enable();
    }

    public void disable() {
        LOGGER.info("Disable is called.");
        super.disable();
        MSG_RAW_LOGGER.info("++++ Disable the message receiver.");
        this.escapeHot.set(false);
    }

    public void receive(ByteArrayOutputStream data) {
        if (!this.running.get()) {
            LOGGER.info("The receiver is not running. Skip processing of messages.");
            try {
                byte[] rawdata = data.toByteArray();
                LOGGER.info("Receiver is stopped, number of bytes read: {}, buffer: {}", (Object)rawdata.length, (Object)ByteUtils.bytesToHex((byte[])rawdata));
            }
            catch (Exception ex) {
                LOGGER.warn("Read data from input stream to buffer failed.", (Throwable)ex);
            }
            return;
        }
        MSG_RAW_LOGGER.info("<<<< start parse input");
        try {
            byte[] rawdata = data.toByteArray();
            LOGGER.info("Received data: {}", (Object)ByteUtils.bytesToHex((byte[])rawdata));
            this.parseInput(rawdata, rawdata.length);
        }
        catch (Exception e) {
            LOGGER.warn("Exception detected in message receiver!", (Throwable)e);
            if (this.escapeHot.get()) {
                LOGGER.warn("Reset the escapeHot to false.");
                this.escapeHot.set(false);
            }
            throw new RuntimeException(e);
        }
        finally {
            MSG_RAW_LOGGER.info("<<<< finished parse input");
        }
    }

    protected void parseInput(byte[] receivedData, int len) throws ProtocolException {
        if (receivedData != null) {
            int data = 0;
            StringBuilder logRecord = new StringBuilder();
            MSG_RAW_LOGGER.info("<<<< len: {}, data: {}", (Object)len, (Object)ByteUtils.bytesToHex((byte[])receivedData, (int)len));
            for (int index = 0; index < len; ++index) {
                data = receivedData[index] & 0xFF;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("received data: {}", (Object)ByteUtils.byteToHex((int)data));
                }
                logRecord.append(ByteUtils.byteToHex((int)data)).append(" ");
                if (data == 254) {
                    LOGGER.debug("Received raw message: {}", (Object)logRecord);
                    if (MSG_RAW_LOGGER.isInfoEnabled()) {
                        MSG_RAW_LOGGER.info("<< [{}] - {}", (Object)(logRecord.length() / 3), (Object)logRecord);
                    }
                    logRecord.setLength(0);
                    try {
                        if (this.output.size() > 0) {
                            this.processMessages(this.output);
                            continue;
                        }
                        LOGGER.warn("No data in output buffer.");
                    }
                    catch (ProtocolException ex) {
                        LOGGER.warn("Process messages failed.", (Throwable)ex);
                        this.escapeHot.set(false);
                    }
                    continue;
                }
                if (data == 253) {
                    this.escapeHot.set(true);
                    continue;
                }
                if (this.escapeHot.get()) {
                    data ^= 0x20;
                    this.escapeHot.set(false);
                }
                this.output.write(ByteUtils.getLowByte((int)data));
            }
            LOGGER.debug("Leaving receive loop, RUNNING: {}", (Object)this.running);
            if (this.output != null && this.output.size() > 0) {
                byte[] remaining = this.output.toByteArray();
                String remainingString = ByteUtils.bytesToHex((byte[])remaining);
                LOGGER.debug("Data remaining in output: {}", (Object)remainingString);
            }
            if (logRecord != null && logRecord.length() > 0) {
                LOGGER.debug("Data remaining in logRecord: {}", (Object)logRecord);
            }
        } else {
            LOGGER.error("No input available.");
        }
    }

    public synchronized void processMessages(ByteArrayOutputStream output) throws ProtocolException {
        LOGGER.info("Received messages to process: {}", (Object)ByteUtils.bytesToHex((byte[])output.toByteArray()));
        try {
            ArrayList bidibMessages = new ArrayList();
            this.getRequestFactory().createFromRaw(output.toByteArray(), bidibMessages);
            if (CollectionUtils.isNotEmpty(bidibMessages)) {
                for (BidibCommand bidibCommand : bidibMessages) {
                    LOGGER.info("Process the current bidibCommand: {}", (Object)bidibCommand);
                    if (this.gatewayMessagePeer == null) continue;
                    this.gatewayMessagePeer.forwardMessage(bidibCommand);
                }
            } else {
                LOGGER.warn("No commands in packet received.");
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create BiDiB message failed.", (Throwable)ex);
        }
        output.reset();
    }

    protected void evaluateMessage(BidibNode bidibNode, BidibMessage message) throws ProtocolException {
        LOGGER.info("Received message to evaluate: {}", (Object)message);
        super.evaluateMessage(bidibNode, message);
    }
}

