/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.gateway;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.CRC8;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.bidib.jbidibc.net.BidibNetAddress;
import org.bidib.jbidibc.net.DataPacket;
import org.bidib.jbidibc.net.NetBidibPort;
import org.bidib.jbidibc.net.NetMessageHandler;
import org.bidib.jbidibc.net.exception.ClientNotAcceptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayNetMessageHandler
implements NetMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayNetMessageHandler.class);
    private BidibMessageProcessor messageReceiverDelegate;
    private List<BidibNetAddress> knownBidibHosts = new LinkedList<BidibNetAddress>();

    public GatewayNetMessageHandler(BidibMessageProcessor messageReceiverDelegate) {
        this.messageReceiverDelegate = messageReceiverDelegate;
    }

    public void receive(DataPacket packet) {
        BidibNetAddress current;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Received a packet from address: {}, port: {}, data: {}", new Object[]{packet.getAddress(), packet.getPort(), ByteUtils.bytesToHex((byte[])packet.getData())});
        }
        if (!this.knownBidibHosts.contains(current = new BidibNetAddress(packet.getAddress(), packet.getPort()))) {
            LOGGER.info("Adding new known Bidib host: {}", (Object)current);
            this.knownBidibHosts.add(current);
        }
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            output.write(packet.getData());
            LOGGER.info("Forward received message to messageReceiverDelegate: {}", (Object)this.messageReceiverDelegate);
            this.messageReceiverDelegate.receive(output);
        }
        catch (Exception ex) {
            LOGGER.warn("Process messages failed.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public void send(NetBidibPort port, byte[] message) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Send message to port: {}, message: {}", (Object)port, (Object)ByteUtils.bytesToHex((byte[])message));
        }
        if (port != null) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                for (BidibNetAddress host : this.knownBidibHosts) {
                    bos.reset();
                    this.addDelimiter(bos);
                    int length = message[0];
                    this.escape(bos, (byte)length);
                    int txCrc = CRC8.getCrcValue((int)length);
                    for (int i = 1; i <= length; ++i) {
                        this.escape(bos, message[i]);
                        txCrc = CRC8.getCrcValue((int)((message[i] ^ txCrc) & 0xFF));
                    }
                    this.escape(bos, (byte)txCrc);
                    this.addDelimiter(bos);
                    LOGGER.info("Send message to address: {}, port: {}", (Object)host.getAddress(), (Object)host.getPortNumber());
                    port.send(bos.toByteArray(), host.getAddress(), host.getPortNumber());
                }
            }
            catch (IOException ex) {
                LOGGER.warn("Send message to port failed.", (Throwable)ex);
                throw new RuntimeException("Send message to datagram socket failed.", ex);
            }
        } else {
            LOGGER.warn("Send not possible, the port is closed.");
        }
    }

    private void addDelimiter(ByteArrayOutputStream output) {
        output.write(-2);
    }

    private void escape(ByteArrayOutputStream output, byte c) {
        if (c == -2 || c == -3) {
            output.write(-3);
            c = (byte)(c ^ 0x20);
        }
        output.write(c);
    }

    public void acceptClient(String remoteHost) {
        LOGGER.info("Accept client with address: {}", (Object)remoteHost);
        if (!this.knownBidibHosts.isEmpty()) {
            LOGGER.warn("Deny access for more than 1 client!");
            throw new ClientNotAcceptedException("Only a single client is currently supported.");
        }
        LOGGER.info("Check if we can accept the client: {}", (Object)remoteHost);
    }

    public void cleanup(final String remoteHost) {
        LOGGER.info("Cleanup client with address: {}", (Object)remoteHost);
        BidibNetAddress foundHost = (BidibNetAddress)IterableUtils.find(this.knownBidibHosts, (Predicate)new Predicate<BidibNetAddress>(){

            public boolean evaluate(BidibNetAddress other) {
                return remoteHost.equals(other.getAddress().getHostAddress());
            }
        });
        if (foundHost != null) {
            LOGGER.info("Remove client from knownBidibHosts: {}", (Object)foundHost);
            this.knownBidibHosts.remove(foundHost);
        } else {
            LOGGER.warn("No client found in knownBidibHosts with address: {}", (Object)remoteHost);
        }
    }
}

