/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.gateway;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bidib.jbidibc.core.AbstractBidib;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.ConnectionListener;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.MessageReceiver;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.exception.PortNotFoundException;
import org.bidib.jbidibc.core.exception.PortNotOpenedException;
import org.bidib.jbidibc.core.helpers.Context;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.bidib.jbidibc.gateway.GatewayMessageReceiver;
import org.bidib.jbidibc.gateway.GatewayNetMessageHandler;
import org.bidib.jbidibc.net.NetBidibPort;
import org.bidib.jbidibc.net.NetBidibServerTcpPort;
import org.bidib.jbidibc.net.NetBidibUdpPort;
import org.bidib.jbidibc.net.NetMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayBidib
extends AbstractBidib {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayBidib.class);
    private static GatewayBidib instance;
    private NetBidibPort port;
    private Thread portWorker;
    private NetMessageHandler netMessageHandler;
    private String connectedPortName;
    private InetAddress address;
    private int portNumber;
    private String protocol;

    public static synchronized BidibInterface getInstance() {
        if (instance == null) {
            instance = new GatewayBidib();
            instance.initialize();
        }
        return instance;
    }

    protected BidibMessageProcessor createMessageReceiver(NodeRegistry nodeFactory) {
        return new GatewayMessageReceiver(nodeFactory);
    }

    private MessageReceiver getNetMessageReceiver() {
        return (MessageReceiver)this.getMessageReceiver();
    }

    public void open(String portName, ConnectionListener connectionListener, Set<NodeListener> nodeListeners, Set<MessageListener> messageListeners, Set<TransferListener> transferListeners, Context context) throws PortNotFoundException, PortNotOpenedException {
        LOGGER.info("Open port: {}", (Object)portName);
        this.setConnectionListener(connectionListener);
        this.registerListeners(nodeListeners, messageListeners, transferListeners);
        if (this.port == null) {
            LOGGER.info("Open port with name: {}", (Object)portName);
            if (portName == null || portName.trim().isEmpty()) {
                throw new PortNotFoundException("");
            }
            if (portName.indexOf(":") < 0) {
                portName = portName + ":62875";
                LOGGER.info("Added portnumber to portName: {}", (Object)portName);
            }
            try {
                this.close();
                this.port = this.internalOpen(portName, context);
                this.connectedPortName = portName;
                LOGGER.info("Port is opened, send the magic. The connected port is: {}", (Object)this.connectedPortName);
                this.getRootNode();
            }
            catch (Exception ex) {
                LOGGER.warn("Open port and send magic failed.", (Throwable)ex);
                throw new PortNotOpenedException(portName, "unknown");
            }
        } else {
            LOGGER.warn("Port is already opened.");
        }
    }

    private NetBidibPort internalOpen(String portName, Context context) throws IOException {
        LOGGER.info("Internal open port: {}", (Object)portName);
        String[] hostAndPort = portName.split(":");
        if (hostAndPort.length > 2) {
            this.protocol = hostAndPort[0];
            this.address = InetAddress.getByName(hostAndPort[1]);
            this.portNumber = Integer.parseInt(hostAndPort[2]);
        } else {
            this.protocol = "tcp";
            this.address = InetAddress.getByName(hostAndPort[0]);
            this.portNumber = Integer.parseInt(hostAndPort[1]);
        }
        LOGGER.info("Configured address: {}, portNumber: {}, protocol: {}", new Object[]{this.address, this.portNumber, this.protocol});
        BidibMessageProcessor messageReceiver = this.getMessageReceiver();
        if (context != null) {
            Boolean ignoreWrongMessageNumber = (Boolean)context.get("ignoreWrongMessageNumber", Boolean.class, (Object)Boolean.FALSE);
            messageReceiver.setIgnoreWrongMessageNumber(ignoreWrongMessageNumber.booleanValue());
        }
        this.getNetMessageReceiver().enable();
        this.netMessageHandler = new GatewayNetMessageHandler(messageReceiver);
        NetBidibServerTcpPort netBidibPort = null;
        if ("tcp".equalsIgnoreCase(this.protocol)) {
            LOGGER.info("Create a NetBidibTcpPort with the portnumber: {}", (Object)62875);
            netBidibPort = new NetBidibServerTcpPort(62875, null, this.netMessageHandler);
        } else {
            LOGGER.info("Create a NetBidibUdpPort with the portnumber: {}", (Object)62875);
            netBidibPort = new NetBidibUdpPort(Integer.valueOf(62875), this.netMessageHandler);
        }
        LOGGER.info("Prepare and start the port worker for netBidibPort: {}", (Object)netBidibPort);
        this.startReceiverAndQueues(messageReceiver, context);
        this.portWorker = new Thread((Runnable)netBidibPort);
        this.portWorker.start();
        return netBidibPort;
    }

    public boolean isOpened() {
        return this.port != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LOGGER.info("Close the port.");
        if (this.port != null) {
            LOGGER.info("Stop the port.");
            this.port.stop();
            if (this.portWorker != null) {
                Thread thread = this.portWorker;
                synchronized (thread) {
                    try {
                        this.portWorker.join(5000L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warn("Wait for termination of port worker failed.", (Throwable)ex);
                    }
                    this.portWorker = null;
                }
            }
            this.port = null;
        }
        this.stopReceiverAndQueues(null);
        if (this.getConnectionListener() != null) {
            this.getConnectionListener().closed(this.connectedPortName);
        }
        this.connectedPortName = null;
        LOGGER.info("Close the port finished.");
    }

    public List<String> getPortIdentifiers() {
        return Collections.emptyList();
    }

    protected void sendData(byte[] data) {
        LOGGER.info("Send data to host/client: {}, netMessageHandler: {}", (Object)ByteUtils.bytesToHex((byte[])data), (Object)this.netMessageHandler);
        this.netMessageHandler.send(this.port, data);
    }
}

