/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.net.serialovertcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.map.HashedMap;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.bidib.jbidibc.net.NetBidibPort;
import org.bidib.jbidibc.net.NetMessageHandler;
import org.bidib.jbidibc.net.exception.ClientNotAcceptedException;
import org.bidib.jbidibc.net.serialovertcp.NetBidibPlainTcpServerSocketHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBidibServerPlainTcpPort
implements NetBidibPort {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibServerPlainTcpPort.class);
    private final NetMessageHandler messageReceiver;
    private AtomicBoolean runEnabled = new AtomicBoolean();
    private ServerSocket serverSocket;
    private final ScheduledExecutorService acceptWorker = Executors.newScheduledThreadPool(1);
    private Map<Integer, Socket> clientMap = MapUtils.synchronizedMap((Map)new HashedMap());

    public NetBidibServerPlainTcpPort(int portNumber, InetAddress bindAddress, NetMessageHandler messageReceiver) throws IOException {
        this.messageReceiver = messageReceiver;
        if (bindAddress != null) {
            this.serverSocket = new ServerSocket(portNumber, 50, bindAddress);
            LOGGER.info("Created TCP server socket for bind address: {},  port number: {}", (Object)bindAddress, (Object)portNumber);
        } else {
            this.serverSocket = new ServerSocket(portNumber);
            LOGGER.info("Created TCP server socket on port number: {}", (Object)portNumber);
        }
    }

    public void run() {
        LOGGER.info("Start the TCP socket.");
        this.runEnabled.set(true);
        this.acceptWorker.submit(new Runnable(){

            @Override
            public void run() {
                while (NetBidibServerPlainTcpPort.this.runEnabled.get()) {
                    try {
                        LOGGER.info("Wait for client to connect.");
                        Socket socket = NetBidibServerPlainTcpPort.this.serverSocket.accept();
                        LOGGER.info("The client connection was accepted byte the server socket, socket: {}", (Object)socket);
                        InetAddress remoteAddress = socket.getInetAddress();
                        if (remoteAddress != null) {
                            String remoteIpAddress = remoteAddress.getHostAddress();
                            try {
                                NetBidibServerPlainTcpPort.this.messageReceiver.acceptClient(remoteIpAddress);
                                NetBidibServerPlainTcpPort.this.clientMap.put(socket.getPort(), socket);
                                NetBidibPlainTcpServerSocketHandler handler = new NetBidibPlainTcpServerSocketHandler(socket, NetBidibServerPlainTcpPort.this.messageReceiver);
                                handler.start();
                            }
                            catch (ClientNotAcceptedException e) {
                                LOGGER.warn("Client was not accepted.", (Throwable)e);
                                try {
                                    socket.close();
                                }
                                catch (Exception e1) {
                                    LOGGER.warn("Close socket of unaccepted client.", (Throwable)e1);
                                }
                            }
                            continue;
                        }
                        LOGGER.warn("No remote address available for socket.");
                        try {
                            socket.close();
                        }
                        catch (Exception e) {
                            LOGGER.warn("Close socket without remote address available failed.", (Throwable)e);
                        }
                    }
                    catch (IOException ex) {
                        LOGGER.error("Start listen on server socket failed.", (Throwable)ex);
                        NetBidibServerPlainTcpPort.this.runEnabled.set(false);
                        return;
                    }
                }
                LOGGER.info("The server socket acceptor has finished.");
            }
        });
        LOGGER.info("Start server port has passed.");
    }

    public void stop() {
        LOGGER.info("Stop the TCP packet receiver, serverSocket: {}", (Object)this.serverSocket);
        this.runEnabled.set(false);
        if (this.serverSocket != null) {
            LOGGER.info("Close the server socket.");
            try {
                this.serverSocket.close();
            }
            catch (IOException ex) {
                LOGGER.warn("Close serverSocket failed.", (Throwable)ex);
            }
            try {
                LOGGER.info("Shutdown acceptWorker.");
                this.acceptWorker.shutdown();
                this.acceptWorker.awaitTermination(2000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception ex) {
                LOGGER.warn("Wait for shutdown of acceptWorker failed.", (Throwable)ex);
            }
            this.serverSocket = null;
        }
    }

    public void send(byte[] sendData, InetAddress address, int portNumber) throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Send data, port: {}, bytes: {}", (Object)portNumber, (Object)ByteUtils.bytesToHex((byte[])sendData));
        }
        for (Socket socket : this.clientMap.values()) {
            if (socket != null) {
                LOGGER.info("Send data to socket: {}", (Object)socket, (Object)ByteUtils.bytesToHex((byte[])sendData));
                socket.getOutputStream().write(sendData);
                socket.getOutputStream().flush();
                continue;
            }
            LOGGER.warn("Send data is discarded because no socket registered for port: {}, address: {}", (Object)portNumber, (Object)address);
        }
    }
}

