/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.net.serialovertcp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bidib.jbidibc.core.AbstractBidib;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.ConnectionListener;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.MessageReceiver;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.exception.PortNotFoundException;
import org.bidib.jbidibc.core.exception.PortNotOpenedException;
import org.bidib.jbidibc.core.exception.ProtocolException;
import org.bidib.jbidibc.core.helpers.Context;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.core.node.RootNode;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.bidib.jbidibc.net.NetBidibPort;
import org.bidib.jbidibc.net.NetMessageHandler;
import org.bidib.jbidibc.net.NetMessageReceiver;
import org.bidib.jbidibc.net.serialovertcp.DefaultNetMessageHandler;
import org.bidib.jbidibc.net.serialovertcp.NetBidibPlainTcpPort;
import org.bidib.jbidibc.serial.SerialMessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBidib
extends AbstractBidib {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidib.class);
    public static final int BIDIB_UDP_PORT_NUMBER = 62875;
    private NetBidibPort port;
    private NetMessageHandler netMessageHandler;
    private Thread portWorker;
    private String connectedPortName;
    private InetAddress address;
    private int portNumber;
    private String protocol;
    private ConnectionListener connectionListener;
    private ByteArrayOutputStream output = new ByteArrayOutputStream(100);

    protected NetBidib() {
        LOGGER.info("Create new instance of plain tcp NetBidib.");
    }

    protected BidibMessageProcessor createMessageReceiver(NodeRegistry nodeFactory) {
        return new NetMessageReceiver(nodeFactory, true);
    }

    private MessageReceiver getNetMessageReceiver() {
        return (MessageReceiver)this.getMessageReceiver();
    }

    public void setConnectionListener(final ConnectionListener connectionListener) {
        this.connectionListener = new ConnectionListener(){
            private boolean active;

            public void status(String messageKey) {
                connectionListener.status(messageKey);
            }

            public void opened(String port) {
                connectionListener.opened(port);
            }

            public void closed(String port) {
                if (this.active) {
                    connectionListener.closed(port);
                    return;
                }
                try {
                    this.active = true;
                    NetBidib.this.close();
                }
                finally {
                    this.active = false;
                }
            }
        };
        super.setConnectionListener(this.connectionListener);
    }

    public static BidibInterface createInstance() {
        LOGGER.info("Create new instance of NetBidib.");
        NetBidib instance = new NetBidib();
        instance.initialize();
        return instance;
    }

    public void open(String portName, ConnectionListener connectionListener, Set<NodeListener> nodeListeners, Set<MessageListener> messageListeners, Set<TransferListener> transferListeners, Context context) throws PortNotFoundException, PortNotOpenedException {
        LOGGER.info("Open port: {}", (Object)portName);
        this.setConnectionListener(connectionListener);
        this.registerListeners(nodeListeners, messageListeners, transferListeners);
        if (this.port == null) {
            LOGGER.info("Open port with name: {}", (Object)portName);
            if (portName == null || portName.trim().isEmpty()) {
                throw new PortNotFoundException("");
            }
            if (portName.indexOf(":") < 0) {
                portName = portName + ":62875";
                LOGGER.info("Added portnumber to portName: {}", (Object)portName);
            }
            try {
                this.port = this.internalOpen(portName, context);
                this.connectedPortName = portName;
                LOGGER.info("Port is opened, send the magic. The connected port is: {}", (Object)this.connectedPortName);
                this.sendMagic();
            }
            catch (Exception ex) {
                LOGGER.warn("Open port and send magic failed.", (Throwable)ex);
                throw new PortNotOpenedException(portName, "unknown");
            }
            LOGGER.info("Open port passed: {}", (Object)portName);
        } else {
            LOGGER.warn("Port is already opened.");
        }
    }

    private NetBidibPort internalOpen(String portName, Context context) throws IOException {
        LOGGER.info("Internal open port: {}", (Object)portName);
        String[] hostAndPort = portName.split(":");
        if (hostAndPort.length > 2) {
            this.protocol = hostAndPort[0];
            this.address = InetAddress.getByName(hostAndPort[1]);
            this.portNumber = Integer.parseInt(hostAndPort[2]);
        } else {
            this.protocol = "tcp";
            this.address = InetAddress.getByName(hostAndPort[0]);
            this.portNumber = Integer.parseInt(hostAndPort[1]);
        }
        LOGGER.info("Configured address: {}, portNumber: {}, protocol: {}", new Object[]{this.address, this.portNumber, this.protocol});
        BidibMessageProcessor messageReceiver = this.getMessageReceiver();
        if (context != null) {
            Boolean ignoreWrongMessageNumber = (Boolean)context.get("ignoreWrongMessageNumber", Boolean.class, (Object)Boolean.FALSE);
            messageReceiver.setIgnoreWrongMessageNumber(ignoreWrongMessageNumber.booleanValue());
        }
        this.getNetMessageReceiver().enable();
        this.netMessageHandler = new DefaultNetMessageHandler(messageReceiver, this.address, this.portNumber, this.connectionListener);
        NetBidibPlainTcpPort netBidibPort = null;
        netBidibPort = new NetBidibPlainTcpPort(this.address, this.portNumber, this.netMessageHandler);
        LOGGER.info("Prepare and start the port worker for netBidibPort: {}", (Object)netBidibPort);
        this.startReceiverAndQueues(messageReceiver, context);
        this.portWorker = new Thread((Runnable)((Object)netBidibPort));
        this.portWorker.start();
        return netBidibPort;
    }

    public boolean isOpened() {
        return this.port != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LOGGER.info("Close the port.");
        if (this.port != null) {
            LOGGER.info("Stop the port.");
            this.port.stop();
            if (this.portWorker != null) {
                Thread thread = this.portWorker;
                synchronized (thread) {
                    try {
                        this.portWorker.join(5000L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warn("Wait for termination of port worker failed.", (Throwable)ex);
                    }
                    this.portWorker = null;
                }
            }
            this.port = null;
        }
        this.stopReceiverAndQueues(null);
        if (this.getConnectionListener() != null) {
            this.getConnectionListener().closed(this.connectedPortName);
        }
        this.connectedPortName = null;
        this.cleanupAfterClose(null);
        LOGGER.info("Close the port finished.");
    }

    public void sendData(ByteArrayOutputStream data) {
        if (this.port != null) {
            LOGGER.info("Send message to net message handler: {}, port: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)data), (Object)this.port);
            try {
                SerialMessageEncoder.encodeMessage((ByteArrayOutputStream)data, (OutputStream)this.output);
                LOGGER.info("Send, after encoding: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)this.output));
                this.netMessageHandler.send(this.port, this.output.toByteArray());
            }
            catch (Exception ex) {
                LOGGER.warn("Forward message to send with netMessageReceiver failed.", (Throwable)ex);
                throw new RuntimeException("Forward message to send with netMessageReceiver failed.", ex);
            }
            finally {
                this.output.reset();
            }
        } else {
            LOGGER.warn("Send not possible, the port is closed.");
        }
    }

    private int sendMagic() throws ProtocolException {
        RootNode rootNode = this.getRootNode();
        int magic = -1;
        try {
            magic = rootNode.getMagic(Integer.valueOf(15000));
        }
        catch (Exception e) {
            magic = rootNode.getMagic(Integer.valueOf(15000));
        }
        LOGGER.info("The node returned magic: {}", (Object)magic);
        return magic;
    }

    public void setResponseTimeout(int timeout) {
        LOGGER.info("Set the response timeout to: {}", (Object)timeout);
        super.setResponseTimeout(timeout);
    }

    public List<String> getPortIdentifiers() {
        return Collections.emptyList();
    }
}

