/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.net.serialovertcp;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bidib.jbidibc.core.exception.ProtocolException;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.bidib.jbidibc.net.serialovertcp.DataPacket;
import org.bidib.jbidibc.net.serialovertcp.NetMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBidibPlainTcpServerSocketHandler
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibPlainTcpServerSocketHandler.class);
    protected static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"RAW");
    private Socket socket;
    private final NetMessageHandler messageReceiver;
    private AtomicBoolean runEnabled = new AtomicBoolean();
    private ByteArrayOutputStream receiveBuffer = new ByteArrayOutputStream(2048);
    private final String remoteHost;
    private boolean escapeHot;
    private ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream(100);

    public NetBidibPlainTcpServerSocketHandler(Socket socket, NetMessageHandler messageReceiver) {
        this.socket = socket;
        this.messageReceiver = messageReceiver;
        this.remoteHost = socket.getInetAddress().getHostAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.runEnabled.set(true);
        byte[] receiveData = new byte[1024];
        try (BufferedInputStream in = new BufferedInputStream(this.socket.getInputStream());){
            int receivedCount = 0;
            while ((receivedCount = in.read(receiveData)) > 0 && this.runEnabled.get()) {
                if (this.messageReceiver != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Received data: {}", (Object)ByteUtils.bytesToHex((byte[])receiveData, (int)receivedCount));
                    }
                    InetAddress address = this.socket.getInetAddress();
                    int portNumber = this.socket.getPort();
                    this.receiveBuffer.write(receiveData, 0, receivedCount);
                    try {
                        this.parsePackets(this.receiveBuffer, this.messageReceiver, address, portNumber);
                        continue;
                    }
                    catch (Exception pex) {
                        LOGGER.warn("Receive message failed.", (Throwable)pex);
                        continue;
                    }
                    finally {
                        this.receiveBuffer.reset();
                        continue;
                    }
                }
                LOGGER.warn("No message receiver configured, data: {}", (Object)ByteUtils.bytesToHex((byte[])receiveData, (int)receivedCount));
            }
        }
        catch (IOException ex) {
            if (this.runEnabled.get()) {
                LOGGER.warn("--- Interrupt NetBidibTcpPort-run", (Throwable)ex);
            } else {
                LOGGER.info("The NetBidibTcpPort worker is terminating.");
            }
        }
        finally {
            LOGGER.info("The socket connection was closed.");
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close socket failed.", (Throwable)ex);
                }
                this.socket = null;
            }
            if (this.messageReceiver != null) {
                LOGGER.info("Cleanup the messageReceiver.");
                this.messageReceiver.cleanup(this.remoteHost);
            }
            LOGGER.info("Cleanup work after close socked has finished.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parsePackets(ByteArrayOutputStream output, NetMessageHandler messageReceiver, InetAddress address, int portNumber) throws ProtocolException {
        try {
            this.parseInput(output, messageReceiver, address, portNumber);
        }
        catch (RuntimeException pex) {
            LOGGER.warn("Receive message failed, reason: {}", (Object)pex.getMessage());
        }
        finally {
            output.reset();
        }
    }

    private void processMessages(ByteArrayOutputStream output, NetMessageHandler messageReceiver, InetAddress address, int portNumber) throws ProtocolException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Process messages will put data into DataPacket: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)output));
        }
        DataPacket receivedPacket = new DataPacket(output.toByteArray(), 0, output.size(), address, portNumber);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Received data: {}", (Object)ByteUtils.bytesToHex((byte[])receivedPacket.getData()));
        }
        messageReceiver.receive(receivedPacket);
    }

    protected void parseInput(ByteArrayOutputStream receiveData, NetMessageHandler messageReceiver, InetAddress address, int portNumber) throws ProtocolException {
        if (receiveData != null) {
            int data = 0;
            int receivedCount = receiveData.size();
            byte[] receivedData = receiveData.toByteArray();
            MSG_RAW_LOGGER.info("<<<< len: {}, data: {}", (Object)receivedCount, (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)receiveData));
            for (int index = 0; index < receivedCount; ++index) {
                data = receivedData[index] & 0xFF;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("received data: {}", (Object)ByteUtils.byteToHex((int)data));
                }
                if (data == 254) {
                    if (this.outputBuffer.size() == 0) {
                        LOGGER.debug("Skip leading MAGIC packet.");
                        continue;
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Received raw message: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)this.outputBuffer));
                    }
                    if (MSG_RAW_LOGGER.isInfoEnabled()) {
                        MSG_RAW_LOGGER.info("<< [{}] - {}", (Object)this.outputBuffer.size(), (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)this.outputBuffer));
                    }
                    try {
                        this.processMessages(this.outputBuffer, messageReceiver, address, portNumber);
                        this.outputBuffer.reset();
                    }
                    catch (ProtocolException ex) {
                        LOGGER.warn("Process messages failed.", (Throwable)ex);
                        this.escapeHot = false;
                    }
                    continue;
                }
                if (data == 253) {
                    this.escapeHot = true;
                    continue;
                }
                if (this.escapeHot) {
                    data ^= 0x20;
                    this.escapeHot = false;
                }
                this.outputBuffer.write(ByteUtils.getLowByte((int)data));
            }
            if (this.outputBuffer != null && this.outputBuffer.size() > 0) {
                byte[] remaining = this.outputBuffer.toByteArray();
                String remainingString = ByteUtils.bytesToHex((byte[])remaining);
                LOGGER.debug("Data remaining in output: {}", (Object)remainingString);
            }
        } else {
            LOGGER.error("No input available.");
        }
    }
}

