/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.net.serialovertcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.bidib.jbidibc.net.serialovertcp.NetBidibPlainTcpServerSocketHandler;
import org.bidib.jbidibc.net.serialovertcp.NetBidibPort;
import org.bidib.jbidibc.net.serialovertcp.NetMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBidibPlainTcpPort
implements NetBidibPort {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibPlainTcpPort.class);
    private final InetAddress address;
    private final int portNumber;
    private final NetMessageHandler messageReceiver;
    private AtomicBoolean runEnabled = new AtomicBoolean();
    private Socket socket;
    private final ScheduledExecutorService acceptWorker = Executors.newScheduledThreadPool(1);

    public NetBidibPlainTcpPort(InetAddress address, int portNumber, NetMessageHandler messageReceiver) throws IOException {
        this.messageReceiver = messageReceiver;
        this.address = address;
        this.portNumber = portNumber;
        if (address == null) {
            throw new IllegalArgumentException("address must not be null!");
        }
        this.socket = new Socket(address, portNumber);
        LOGGER.info("Created TCP socket for address: {},  port number: {}", (Object)address, (Object)portNumber);
    }

    @Override
    public void run() {
        LOGGER.info("Start the TCP socket.");
        this.runEnabled.set(true);
        LOGGER.info("Start client receiver handler.");
        this.acceptWorker.submit(new NetBidibPlainTcpServerSocketHandler(this.socket, this.messageReceiver));
        LOGGER.info("Start client receiver handler has passed.");
        LOGGER.info("Start has passed.");
    }

    @Override
    public void stop() {
        LOGGER.info("Stop the TCP packet receiver, socket: {}", (Object)this.socket);
        this.runEnabled.set(false);
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                LOGGER.warn("Close socket failed.", (Throwable)ex);
            }
            this.socket = null;
        }
    }

    @Override
    public void send(byte[] sendData, InetAddress address, int portNumber) throws IOException {
        LOGGER.info("Send data to socket, port: {}, bytes: {}", (Object)portNumber, (Object)ByteUtils.bytesToHex((byte[])sendData));
        this.socket.getOutputStream().write(sendData);
        this.socket.getOutputStream().flush();
    }
}

