/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.net.serialovertcp;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.core.AbstractMessageReceiver;
import org.bidib.jbidibc.core.message.ResponseFactory;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetMessageReceiver
extends AbstractMessageReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetMessageReceiver.class);
    private ByteArrayOutputStream output = new ByteArrayOutputStream(2048);

    public NetMessageReceiver(NodeRegistry nodeFactory, ResponseFactory responseFactory, boolean checkCRC) {
        super(nodeFactory, responseFactory, checkCRC);
    }

    public void enable() {
        LOGGER.info("enable is called.");
        MSG_RAW_LOGGER.info("++++ Enable the message receiver.");
        try {
            this.output.reset();
        }
        catch (Exception ex) {
            LOGGER.warn("Reset buffered received data failed.", (Throwable)ex);
        }
        super.enable();
    }

    public void disable() {
        LOGGER.info("Disable is called.");
        super.disable();
        MSG_RAW_LOGGER.info("++++ Disable the message receiver.");
    }

    public void receive(ByteArrayOutputStream data) {
        if (!this.isEnabled()) {
            LOGGER.info("The receiver is not running. Skip processing of messages.");
            try {
                byte[] rawdata = data.toByteArray();
                LOGGER.info("Receiver is stopped, number of bytes read: {}, buffer: {}", (Object)rawdata.length, (Object)ByteUtils.bytesToHex((byte[])rawdata));
            }
            catch (Exception ex) {
                LOGGER.warn("Read data from input stream to buffer failed.", (Throwable)ex);
            }
            return;
        }
        MSG_RAW_LOGGER.info("<<<< start parse input: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)data));
        try {
            this.parseInput(data);
        }
        catch (Exception e) {
            LOGGER.warn("Exception detected in message receiver!", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            MSG_RAW_LOGGER.info("<<<< finished parse input");
        }
    }

    protected void parseInput(ByteArrayOutputStream input) throws ProtocolException {
        MSG_RAW_LOGGER.info("<<<< len: {}, data: {}", (Object)input.size(), (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)input));
        try {
            this.processMessages(input);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Process messages failed.", (Throwable)ex);
        }
    }
}

