/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.net.serialovertcp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import org.bidib.jbidibc.core.ConnectionListener;
import org.bidib.jbidibc.core.MessageReceiver;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.net.serialovertcp.BidibNetAddress;
import org.bidib.jbidibc.net.serialovertcp.DataPacket;
import org.bidib.jbidibc.net.serialovertcp.NetBidibPort;
import org.bidib.jbidibc.net.serialovertcp.NetMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNetMessageHandler
implements NetMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultNetMessageHandler.class);
    private MessageReceiver messageReceiverDelegate;
    private BidibNetAddress remoteAddress;
    private final ConnectionListener connectionListener;

    public DefaultNetMessageHandler(MessageReceiver messageReceiverDelegate, InetAddress address, int port, ConnectionListener connectionListener) {
        this.messageReceiverDelegate = messageReceiverDelegate;
        this.connectionListener = connectionListener;
        LOGGER.info("Set the remote address: {}, port: {}", (Object)address, (Object)port);
        this.remoteAddress = new BidibNetAddress(address, port);
    }

    @Override
    public void receive(DataPacket packet) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Received a packet from address: {}, port: {}, data: {}", new Object[]{packet.getAddress(), packet.getPort(), ByteUtils.bytesToHex((byte[])packet.getData())});
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        output.write(packet.getData(), 0, packet.getData().length);
        LOGGER.debug("Forward received message to messageReceiverDelegate: {}", (Object)this.messageReceiverDelegate);
        try {
            this.messageReceiverDelegate.receive(output);
        }
        catch (Exception ex) {
            LOGGER.warn("Process messages failed.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void send(NetBidibPort port, byte[] bytes) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Send message to port: {}, message: {}", (Object)port, (Object)ByteUtils.bytesToHex((byte[])bytes));
        }
        if (this.remoteAddress == null) {
            LOGGER.warn("### No remote addresses available. The message will not be sent!");
            return;
        }
        if (port != null) {
            try {
                LOGGER.info("Send message to remote address, address: {}, port: {}", (Object)this.remoteAddress.getAddress(), (Object)this.remoteAddress.getPortNumber());
                port.send(bytes, this.remoteAddress.getAddress(), this.remoteAddress.getPortNumber());
            }
            catch (IOException ex) {
                LOGGER.warn("Send message to port failed.", (Throwable)ex);
                throw new RuntimeException("Send message to datagram socket failed.", ex);
            }
        } else {
            LOGGER.warn("Send not possible, the port is closed.");
        }
    }

    @Override
    public void acceptClient(String remoteHost) {
        LOGGER.info("Accept client with address: {}", (Object)remoteHost);
    }

    @Override
    public void cleanup(String remoteHost) {
        LOGGER.info("Cleanup client with address: {}", (Object)remoteHost);
        this.connectionListener.closed(remoteHost);
    }
}

