/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.net.serialovertcp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bidib.jbidibc.core.AbstractBidib;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.core.node.RootNode;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.MessageReceiver;
import org.bidib.jbidibc.messages.base.AbstractBaseBidib;
import org.bidib.jbidibc.messages.base.RawMessageListener;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.exception.PortNotFoundException;
import org.bidib.jbidibc.messages.exception.PortNotOpenedException;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.message.BidibResponseFactory;
import org.bidib.jbidibc.messages.message.ResponseFactory;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.net.serialovertcp.DefaultNetMessageHandler;
import org.bidib.jbidibc.net.serialovertcp.NetBidibPlainTcpPort;
import org.bidib.jbidibc.net.serialovertcp.NetBidibPort;
import org.bidib.jbidibc.net.serialovertcp.NetMessageHandler;
import org.bidib.jbidibc.net.serialovertcp.NetMessageReceiver;
import org.bidib.jbidibc.serial.SerialMessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBidib
extends AbstractBidib<NetMessageReceiver> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidib.class);
    public static final int BIDIB_UDP_PORT_NUMBER = 62875;
    private NetBidibPort port;
    private NetMessageHandler netMessageHandler;
    private Thread portWorker;
    private String connectedPortName;
    private InetAddress address;
    private int portNumber;
    private String protocol;
    private ConnectionListener connectionListener;
    private NetConnector connector;
    private ByteArrayOutputStream output = new ByteArrayOutputStream(100);

    protected NetBidib() {
        LOGGER.info("Create new instance of plain tcp NetBidib.");
    }

    protected NetMessageReceiver createMessageReceiver(NodeRegistry nodeFactory, RawMessageListener rawMessageListener, Context context) {
        BidibResponseFactory responseFactory = new BidibResponseFactory();
        responseFactory.initialize();
        NetMessageReceiver messageReceiver = new NetMessageReceiver(nodeFactory, (ResponseFactory)responseFactory, true);
        messageReceiver.setRawMessageListener(rawMessageListener);
        messageReceiver.init(context);
        return messageReceiver;
    }

    public void setConnectionListener(final ConnectionListener connectionListener) {
        this.connectionListener = new ConnectionListener(){

            public void status(String messageKey, Context context) {
                LOGGER.info("The status was signalled: {}, context: {}", (Object)messageKey, (Object)context);
                connectionListener.status(messageKey, context);
            }

            public void opened(String port) {
                LOGGER.info("The port was opened: {}", (Object)port);
                connectionListener.opened(port);
            }

            public void closed(String port) {
                LOGGER.info("The port was closed: {}", (Object)port);
                connectionListener.closed(port);
            }

            public void stall(boolean stall) {
                connectionListener.stall(stall);
            }
        };
        super.setConnectionListener(this.connectionListener);
    }

    public static BidibInterface createInstance(Context context) {
        LOGGER.info("Create new instance of NetBidib.");
        NetBidib instance = new NetBidib();
        instance.initialize(context);
        return instance;
    }

    public void initialize(Context context) {
        LOGGER.info("Initialize. Create the connector.");
        super.initialize(context);
        this.connector = new NetConnector();
        NetMessageReceiver messageReceiver = (NetMessageReceiver)this.getMessageReceiver();
        this.connector.setMessageReceiver((MessageReceiver)messageReceiver);
        this.initializeConnector(this.connector);
    }

    public void open(String portName, ConnectionListener connectionListener, Set<NodeListener> nodeListeners, Set<MessageListener> messageListeners, Set<TransferListener> transferListeners, Context context) throws PortNotFoundException, PortNotOpenedException {
        LOGGER.info("Open port: {}", portName);
        this.setConnectionListener(connectionListener);
        this.registerListeners(nodeListeners, messageListeners, transferListeners);
        if (this.port == null) {
            LOGGER.info("Open port with name: {}", portName);
            if (portName == null || ((String)portName).trim().isEmpty()) {
                throw new PortNotFoundException("");
            }
            if (((String)portName).indexOf(":") < 0) {
                portName = (String)portName + ":62875";
                LOGGER.info("Added portnumber to portName: {}", portName);
            }
            try {
                this.port = this.internalOpen((String)portName, context);
                this.connectedPortName = portName;
                LOGGER.info("Port is opened, send the magic. The connected port is: {}", (Object)this.connectedPortName);
                this.sendMagic();
                LOGGER.info("Startup sequence is finished. Notify the communiction that we are finished.");
                this.getConnectionListener().opened((String)portName);
            }
            catch (ConnectException ex) {
                LOGGER.warn("Open port failed because connect failed.", (Throwable)ex);
                throw new PortNotOpenedException((String)portName, "connectFailed").withFailureReason(PortNotOpenedException.FailureReason.CONNECT_FAILED);
            }
            catch (Exception ex) {
                LOGGER.warn("Open port and send magic failed.", (Throwable)ex);
                throw new PortNotOpenedException((String)portName, "unknown").withFailureReason(PortNotOpenedException.FailureReason.UNKNOWN);
            }
            LOGGER.info("Open port passed: {}", portName);
        } else {
            LOGGER.warn("Port is already opened.");
        }
    }

    private NetBidibPort internalOpen(String portName, Context context) throws IOException {
        LOGGER.info("Internal open port: {}", (Object)portName);
        String[] hostAndPort = portName.split(":");
        if (hostAndPort.length > 2) {
            this.protocol = hostAndPort[0];
            this.address = InetAddress.getByName(hostAndPort[1]);
            this.portNumber = Integer.parseInt(hostAndPort[2]);
        } else {
            this.protocol = "tcp";
            this.address = InetAddress.getByName(hostAndPort[0]);
            this.portNumber = Integer.parseInt(hostAndPort[1]);
        }
        LOGGER.info("Configured address: {}, portNumber: {}, protocol: {}", new Object[]{this.address, this.portNumber, this.protocol});
        NetMessageReceiver messageReceiver = (NetMessageReceiver)this.getMessageReceiver();
        messageReceiver.enable();
        this.netMessageHandler = new DefaultNetMessageHandler((MessageReceiver)messageReceiver, this.address, this.portNumber, this.connectionListener);
        NetBidibPlainTcpPort netBidibPort = null;
        netBidibPort = new NetBidibPlainTcpPort(this.address, this.portNumber, this.netMessageHandler);
        LOGGER.info("Prepare and start the port worker for netBidibPort: {}", (Object)netBidibPort);
        this.connector.startReceiverAndQueues((MessageReceiver)((NetMessageReceiver)this.getMessageReceiver()), context);
        this.portWorker = new Thread(netBidibPort);
        this.portWorker.start();
        return netBidibPort;
    }

    public boolean isOpened() {
        return this.port != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LOGGER.info("Close the port.");
        if (this.port != null) {
            LOGGER.info("Stop the port.");
            NetBidibPort portToClose = this.port;
            this.port = null;
            portToClose.stop();
            if (this.portWorker != null) {
                LOGGER.info("Wait for the port worker to finish.");
                Thread thread = this.portWorker;
                synchronized (thread) {
                    try {
                        this.portWorker.join(5000L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warn("Wait for termination of port worker failed.", (Throwable)ex);
                    }
                    this.portWorker = null;
                    LOGGER.info("The port worker has finished.");
                }
            }
        } else {
            LOGGER.info("No port to close available.");
        }
        this.connector.stopReceiverAndQueues(null);
        if (this.connectedPortName != null) {
            String connectedPortNameToClose = this.connectedPortName;
            this.connectedPortName = null;
            this.fireConnectionClosed(connectedPortNameToClose);
        } else {
            LOGGER.info("The connectedPortName is not available.");
        }
        super.close();
        this.cleanupAfterClose(null);
        LOGGER.info("Close the port has finished.");
    }

    private int sendMagic() throws ProtocolException {
        RootNode rootNode = this.getRootNode();
        int magic = -1;
        try {
            magic = rootNode.getMagic(Integer.valueOf(15000));
        }
        catch (Exception e) {
            magic = rootNode.getMagic(Integer.valueOf(15000));
        }
        LOGGER.info("The node returned magic: {}", (Object)magic);
        return magic;
    }

    public void setResponseTimeout(int timeout) {
        LOGGER.info("Set the response timeout to: {}", (Object)timeout);
        super.setResponseTimeout(timeout);
    }

    public List<String> getPortIdentifiers() {
        return Collections.emptyList();
    }

    public void send(byte[] data) {
        this.connector.send(data);
    }

    protected int contactInterface() {
        return 0;
    }

    private class NetConnector
    extends AbstractBaseBidib<NetMessageReceiver> {
        private NetConnector() {
        }

        protected void sendData(ByteArrayOutputStream data, RawMessageListener rawMessageListener) {
            if (NetBidib.this.port != null) {
                LOGGER.info("Send message to net message handler: {}, port: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)data), (Object)NetBidib.this.port);
                try {
                    SerialMessageEncoder.encodeMessage((ByteArrayOutputStream)data, (OutputStream)NetBidib.this.output);
                    LOGGER.info("Send, after encoding: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)NetBidib.this.output));
                    if (rawMessageListener != null) {
                        rawMessageListener.notifySend(NetBidib.this.output.toByteArray());
                    }
                    NetBidib.this.netMessageHandler.send(NetBidib.this.port, NetBidib.this.output.toByteArray());
                }
                catch (Exception ex) {
                    LOGGER.warn("Forward message to send with netMessageReceiver failed.", (Throwable)ex);
                    throw new RuntimeException("Forward message to send with netMessageReceiver failed.", ex);
                }
                finally {
                    NetBidib.this.output.reset();
                }
            } else {
                LOGGER.warn("Send not possible, the port is closed.");
            }
        }

        protected void internalOpen(String portName, Context context) throws PortNotFoundException, PortNotOpenedException {
            LOGGER.info("Internal open port: {}", (Object)portName);
            try {
                String[] hostAndPort = portName.split(":");
                if (hostAndPort.length > 2) {
                    NetBidib.this.protocol = hostAndPort[0];
                    NetBidib.this.address = InetAddress.getByName(hostAndPort[1]);
                    NetBidib.this.portNumber = Integer.parseInt(hostAndPort[2]);
                } else {
                    NetBidib.this.protocol = "tcp";
                    NetBidib.this.address = InetAddress.getByName(hostAndPort[0]);
                    NetBidib.this.portNumber = Integer.parseInt(hostAndPort[1]);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Prepare address and portnumber for netBidibPort failed.", (Throwable)ex);
                throw new InvalidConfigurationException("Prepare address and portnumber for netBidibPort failed.");
            }
            LOGGER.info("Configured address: {}, portNumber: {}, protocol: {}", new Object[]{NetBidib.this.address, NetBidib.this.portNumber, NetBidib.this.protocol});
            NetMessageReceiver messageReceiver = (NetMessageReceiver)this.getMessageReceiver();
            messageReceiver.enable();
            NetBidib.this.netMessageHandler = new DefaultNetMessageHandler((MessageReceiver)messageReceiver, NetBidib.this.address, NetBidib.this.portNumber, NetBidib.this.connectionListener);
            NetBidibPlainTcpPort netBidibPort = null;
            try {
                netBidibPort = new NetBidibPlainTcpPort(NetBidib.this.address, NetBidib.this.portNumber, NetBidib.this.netMessageHandler);
            }
            catch (IOException ex) {
                LOGGER.warn("Configure NetBidibPlainTcpPort failed.", (Throwable)ex);
                throw new InvalidConfigurationException("Configure NetBidibPlainTcpPort failed.");
            }
            LOGGER.info("Prepare and start the port worker for netBidibPort: {}", (Object)netBidibPort);
            NetBidib.this.portWorker = new Thread(netBidibPort);
            NetBidib.this.portWorker.start();
            NetBidib.this.port = netBidibPort;
        }
    }
}

