/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.server.adapter;

import java.util.function.Function;
import org.bidib.jbidibc.messages.BidibMessagePublisher;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.MessageReceiver;
import org.bidib.jbidibc.messages.SequenceNumberProvider;
import org.bidib.jbidibc.messages.base.BaseBidib;
import org.bidib.jbidibc.messages.base.DataTransferStatusListener;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.exception.PortNotFoundException;
import org.bidib.jbidibc.messages.exception.PortNotOpenedException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.StringUtils;
import org.bidib.jbidibc.netbidib.server.adapter.DefaultHostAdapter;
import org.bidib.jbidibc.purejavacomm.PureJavaCommSerialConnector;
import org.bidib.jbidibc.serial.LineStatusListener;
import org.bidib.jbidibc.serial.raw.MessagePublisher;
import org.bidib.jbidibc.serial.raw.SerialRawMessageReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PJCSerialHostAdapter<T>
extends DefaultHostAdapter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PJCSerialHostAdapter.class);
    private static final Logger LOGGER_CONNECTOR = LoggerFactory.getLogger(PureJavaCommSerialConnector.class);
    private BaseBidib rawSerialBidib;
    private PureJavaCommSerialConnector connector;
    private SerialRawMessageReceiver serialMessageReceiver;
    private String configuredPort;
    private String connectedPort;

    public PJCSerialHostAdapter(Function<BidibMessageInterface, T> messageContentSupplier) {
        super(messageContentSupplier);
    }

    @Override
    public void initialize(Context context) {
        super.initialize(context);
        LOGGER.info("Create the PureJavaCommSerialConnector instance for communication with the backend.");
        this.connector = new PureJavaCommSerialConnector(){

            public void open(String portName, ConnectionListener connectionListener, Context context) throws PortNotFoundException, PortNotOpenedException {
                this.internalOpen(portName, context);
                if (connectionListener != null) {
                    connectionListener.opened(portName);
                }
            }
        };
        org.bidib.jbidibc.messages.logger.Logger connectorLogger = new org.bidib.jbidibc.messages.logger.Logger(){

            public void debug(String format, Object ... arguments) {
                LOGGER_CONNECTOR.debug(format, arguments);
            }

            public void info(String format, Object ... arguments) {
                LOGGER_CONNECTOR.info(format, arguments);
            }

            public void warn(String format, Object ... arguments) {
                LOGGER_CONNECTOR.warn(format, arguments);
            }

            public void error(String format, Object ... arguments) {
                LOGGER_CONNECTOR.error(format, arguments);
            }
        };
        this.connector.setLogger(connectorLogger);
        this.serialMessageReceiver = this.createMessageReceiver(context);
        this.connector.setMessageReceiver((MessageReceiver)this.serialMessageReceiver);
        this.connector.setLineStatusListener(new LineStatusListener(){

            public void notifyLineStatusChanged(boolean ready, boolean manualEvent) {
            }
        });
        this.connector.setDataTransferStatusListener(new DataTransferStatusListener(){

            public void notifySendStarted() {
            }

            public void notifySendStopped() {
            }

            public void notifyReceiveStarted() {
            }

            public void notifyReceiveStopped() {
            }
        });
        this.connector.initialize();
        this.rawSerialBidib = this.connector;
    }

    private SerialRawMessageReceiver createMessageReceiver(Context context) {
        LOGGER.info("Create the serial message receiver.");
        SerialRawMessageReceiver serialMessageReceiver = new SerialRawMessageReceiver(true, new MessagePublisher(){

            public void publishMessage(BidibMessageInterface bidibMessage) {
                PJCSerialHostAdapter.this.getToGuestPublisher().publishBidibMessage(null, PJCSerialHostAdapter.this.messageContentSupplier.apply(bidibMessage));
            }
        });
        serialMessageReceiver.init(context);
        return serialMessageReceiver;
    }

    public BaseBidib getRawSerialBidib() {
        return this.rawSerialBidib;
    }

    public void setRawSerialBidib(BaseBidib rawSerialBidib) {
        this.rawSerialBidib = rawSerialBidib;
    }

    public String getConfiguredPort() {
        return this.configuredPort;
    }

    @Override
    public void signalConnectionOpened(Context context) {
        if (this.rawSerialBidib == null) {
            LOGGER.error("No backend configured. Abort connect to backend.");
            throw new InvalidConfigurationException("No backend configured. Abort connect to backend.");
        }
        String portName = (String)context.get("port", String.class, null);
        if (StringUtils.isBlank((CharSequence)portName)) {
            LOGGER.error("No backend portName configured. Abort connect to backend.");
            throw new InvalidConfigurationException("No backend portName configured. Abort connect to backend.");
        }
        final ConnectionListener connectionListener = (ConnectionListener)context.get("connectionListener", ConnectionListener.class, null);
        LOGGER.info("Connect the backend, port: {}, connectionListener: {}", (Object)portName, (Object)connectionListener);
        ConnectionListener localConnectionListener = new ConnectionListener(){

            public void status(String messageKey, Context context) {
                if (connectionListener != null) {
                    connectionListener.status(messageKey, context);
                }
            }

            public void opened(String port) {
                LOGGER.info("Port was opened, notify the connection listener.");
                if (connectionListener != null) {
                    connectionListener.opened(port);
                }
            }

            public void closed(String port) {
                if (connectionListener != null) {
                    connectionListener.closed(port);
                }
                LOGGER.info("Port was closed, stop receiver and queues.");
                PJCSerialHostAdapter.this.connector.stopReceiverAndQueues(null);
            }

            public void stall(boolean stall) {
            }
        };
        this.configuredPort = portName;
        try {
            this.rawSerialBidib.open(portName, localConnectionListener, context);
            this.connectedPort = portName;
            this.setToBackendPublisher(new BidibMessagePublisher<T>(){

                public void publishBidibMessage(SequenceNumberProvider node, T message) {
                    byte[] content = null;
                    if (message instanceof BidibMessageInterface) {
                        content = (byte[])PJCSerialHostAdapter.this.messageContentSupplier.apply((BidibMessageInterface)message);
                    } else if (message instanceof byte[]) {
                        content = (byte[])message;
                    }
                    if (content != null) {
                        LOGGER.info("Publish the bidib message content from stream to the backend: {}", (Object)ByteUtils.bytesToHex((byte[])content));
                        PJCSerialHostAdapter.this.connector.send(content);
                    } else {
                        LOGGER.warn("No content to send available.");
                    }
                }
            });
            this.serialMessageReceiver.enable();
        }
        catch (PortNotFoundException ex) {
            LOGGER.warn("Open port failed.", (Throwable)ex);
            this.fireClosed(portName);
            InvalidConfigurationException icex = new InvalidConfigurationException("Open port failed.", (Throwable)ex);
            throw icex;
        }
        catch (PortNotOpenedException ex) {
            LOGGER.warn("Open port failed.", (Throwable)ex);
            this.fireClosed(portName);
            InvalidConfigurationException icex = new InvalidConfigurationException("Open port failed.", (Throwable)ex);
            icex.setReason(ex.getReason());
            throw icex;
        }
    }

    @Override
    public void signalConnectionClosed(Context context) {
        if (this.rawSerialBidib == null) {
            LOGGER.error("No backend configured. Abort disconnect from backend.");
            throw new InvalidConfigurationException("No backend configured. Abort disconnect from backend.");
        }
        LOGGER.info("Disconnect from the backend.");
        this.serialMessageReceiver.disable();
        try {
            this.rawSerialBidib.close();
        }
        catch (Exception ex) {
            LOGGER.warn("Close port failed.", (Throwable)ex);
        }
        this.fireClosed(this.connectedPort);
        this.connectedPort = null;
        this.configuredPort = null;
        LOGGER.info("Disconnect port has passed.");
    }

    private void fireClosed(String portName) {
        LOGGER.info("The port was closed: {}", (Object)portName);
    }
}

