/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.BidibMessagePublisher;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.HostAdapter;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.StringData;
import org.bidib.jbidibc.messages.enums.PairingResult;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.exception.ProtocolInvalidContentException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.jbidibc.messages.message.BidibCommand;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.BidibResponseFactory;
import org.bidib.jbidibc.messages.message.LocalBidibUpResponse;
import org.bidib.jbidibc.messages.message.LocalLogoffMessage;
import org.bidib.jbidibc.messages.message.LocalLogonAckMessage;
import org.bidib.jbidibc.messages.message.LocalLogonMessage;
import org.bidib.jbidibc.messages.message.StringResponse;
import org.bidib.jbidibc.messages.message.SysPVersionResponse;
import org.bidib.jbidibc.messages.message.SysUniqueIdResponse;
import org.bidib.jbidibc.messages.message.netbidib.LocalLinkMessage;
import org.bidib.jbidibc.messages.message.netbidib.LocalProtocolSignatureMessage;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.MessageUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.jbidibc.netbidib.ConnectionUpdateEvent;
import org.bidib.jbidibc.netbidib.exception.AccessDeniedException;
import org.bidib.jbidibc.netbidib.exception.PairingDeniedException;
import org.bidib.jbidibc.netbidib.pairingstore.LocalPairingStore;
import org.bidib.jbidibc.netbidib.pairingstore.PairingStore;
import org.bidib.jbidibc.netbidib.server.ConnectionState;
import org.bidib.jbidibc.netbidib.server.RoleTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NetBidibServerHandler<T>
extends SimpleChannelInboundHandler<ByteBuf>
implements BidibMessagePublisher<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibServerHandler.class);
    private static final Logger MSG_RX_NET_LOGGER = LoggerFactory.getLogger((String)"RX_NET");
    private static final Logger MSG_TX_NET_LOGGER = LoggerFactory.getLogger((String)"TX_NET");
    private BidibRequestFactory bidibRequestFactory;
    protected BidibResponseFactory responseFactory;
    private final HostAdapter<T> hostAdapter;
    private final String backendPortName;
    protected final Object pairedPartnerLock = new Object();
    protected NetBidibLinkData pairedPartner;
    protected final NetBidibLinkData serverLinkData;
    private PairingStore pairingStore;
    private ChannelGroup channelGroup;
    protected ChannelHandlerContext ctx;
    private Set<ConnectionListener> remoteConnectionListeners = new HashSet<ConnectionListener>();
    private final Consumer<NetBidibServerHandler<T>> lazyInitializationCallback;
    private final Function<BidibMessageInterface, T> messageContentSupplier;
    private RoleTypeEnum roleType;
    private final org.bidib.jbidibc.messages.logger.Logger splitMessageLogger;
    private final AtomicBoolean isFirstPacket = new AtomicBoolean(true);
    private final ScheduledExecutorService pairingWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("pairingWorkers-thread-%d").build());
    private BiFunction<NetBidibLinkData, Integer, Boolean> pairingCallback;

    public NetBidibServerHandler(ChannelGroup channelGroup, HostAdapter<T> hostAdapter, String backendPortName, NetBidibLinkData serverLinkData, Consumer<NetBidibServerHandler<T>> lazyInitializationCallback, Function<BidibMessageInterface, T> messageContentSupplier, RoleTypeEnum roleType, NetBidibLinkData pairedPartner) {
        LOGGER.info("Create new NetBidibServerHandler instance. Provided roleType: {}", (Object)roleType);
        this.channelGroup = channelGroup;
        this.hostAdapter = hostAdapter;
        this.backendPortName = backendPortName;
        this.serverLinkData = serverLinkData;
        this.lazyInitializationCallback = lazyInitializationCallback;
        this.messageContentSupplier = messageContentSupplier;
        this.roleType = roleType;
        this.pairedPartner = pairedPartner;
        this.splitMessageLogger = new org.bidib.jbidibc.messages.logger.Logger(){

            public void debug(String format, Object ... arguments) {
                LOGGER.debug(format, arguments);
            }

            public void info(String format, Object ... arguments) {
                LOGGER.info(format, arguments);
            }

            public void warn(String format, Object ... arguments) {
                LOGGER.warn(format, arguments);
            }

            public void error(String format, Object ... arguments) {
                LOGGER.error(format, arguments);
            }
        };
    }

    protected boolean handleLocalBidibUpResponse() {
        return this.roleType == RoleTypeEnum.INTERFACE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteConnectionListener(ConnectionListener remoteConnectionListener) {
        Set<ConnectionListener> set = this.remoteConnectionListeners;
        synchronized (set) {
            this.remoteConnectionListeners.add(remoteConnectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteConnectionListener(ConnectionListener remoteConnectionListener) {
        Set<ConnectionListener> set = this.remoteConnectionListeners;
        synchronized (set) {
            this.remoteConnectionListeners.remove(remoteConnectionListener);
        }
    }

    public void setPairingStore(PairingStore pairingStore) {
        this.pairingStore = pairingStore;
    }

    protected void performLazyInitialization() {
        LOGGER.info("Perform the lazy initialization.");
        if (this.bidibRequestFactory == null) {
            this.bidibRequestFactory = new BidibRequestFactory();
            this.bidibRequestFactory.setEscapeMagic(false);
            this.bidibRequestFactory.initialize();
        }
        if (this.responseFactory == null) {
            this.responseFactory = new BidibResponseFactory();
        }
        if (this.lazyInitializationCallback != null) {
            LOGGER.info("Call the lazy initialization callback.");
            this.lazyInitializationCallback.accept(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        SocketAddress remoteAddress = ctx.channel().remoteAddress();
        LOGGER.info("Session created. IP: {}, channel: {}", (Object)remoteAddress, (Object)ctx.channel());
        if (this.hasActiveConnection()) {
            LOGGER.warn("More than one session: reject!");
            ctx.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        MSG_RX_NET_LOGGER.info("Connected");
        this.performLazyInitialization();
        this.channelGroup.add((Object)ctx.channel());
        ctx.channel().attr(ConnectionState.STATE_KEY).set((Object)ConnectionState.Phase.NOT_CONNECTED);
        if (remoteAddress != null) {
            ctx.channel().attr(ConnectionState.REMOTE_ADDRESS_KEY).set((Object)remoteAddress.toString());
        } else {
            SocketAddress localAddress = ctx.channel().localAddress();
            LOGGER.info("No remoteAddress available. Use localAddress: {}", (Object)localAddress);
        }
        super.channelRegistered(ctx);
        LOGGER.info("Store the channelHandlerContext: {}", (Object)ctx);
        this.ctx = ctx;
        Set<ConnectionListener> set = this.remoteConnectionListeners;
        synchronized (set) {
            for (ConnectionListener connectionListener : this.remoteConnectionListeners) {
                try {
                    connectionListener.opened(ctx.channel().remoteAddress() != null ? ctx.channel().remoteAddress().toString() : "unknown");
                }
                catch (Exception ex) {
                    LOGGER.warn("Notify that the client connection was closed failed.", (Throwable)ex);
                }
            }
        }
    }

    private void sendInitialLocalProtocolSignatureMessage() throws ProtocolException {
        String requestorName = this.serverLinkData.getRequestorName();
        LOGGER.info("Send the initial LocalProtocolSignatureMessage to the client. Current requestorName: {}", (Object)requestorName);
        if (StringUtils.isBlank((CharSequence)requestorName) || !requestorName.startsWith("BiDiB")) {
            LOGGER.warn("Invalid requestor name provided: {}", (Object)requestorName);
            throw new IllegalArgumentException("Invalid requestor name provided.");
        }
        LocalProtocolSignatureMessage message = this.bidibRequestFactory.createLocalProtocolSignature(requestorName);
        this.publishMessage(this.ctx, (BidibMessageInterface)message);
        DefaultContext context = new DefaultContext();
        context.register("port", (Object)this.backendPortName);
        ConnectionListener connectionListener = new ConnectionListener(){

            public void opened(String port) {
                LOGGER.info("The port was opened: {}", (Object)port);
            }

            public void closed(String port) {
            }

            public void status(String messageKey, Context context) {
            }

            public void stall(boolean stall) {
            }

            public void pairingFinished(PairingResult pairingResult) {
                LOGGER.info("The pairing process has finished. Current pairingResult: {}", (Object)pairingResult);
            }
        };
        context.register("connectionListener", (Object)connectionListener);
        try {
            LOGGER.info("Initialize the host adapter.");
            this.hostAdapter.initialize((Context)context);
            LOGGER.info("Connect to the backend. Provided context: {}", (Object)context);
            this.hostAdapter.signalConnectionOpened((Context)context);
            LOGGER.info("Get the productname, username, uniqueId and protocol version from the root node.");
            BidibCommand stringGetMessage = this.bidibRequestFactory.createStringGet(0, 0);
            stringGetMessage.setAddr(Node.ROOTNODE_ADDR);
            this.sendLocalBidibDownMessage(stringGetMessage);
            stringGetMessage = this.bidibRequestFactory.createStringGet(0, 1);
            stringGetMessage.setAddr(Node.ROOTNODE_ADDR);
            this.sendLocalBidibDownMessage(stringGetMessage);
            BidibCommand getUniqueIdMessage = this.bidibRequestFactory.createSysGetUniqueId();
            getUniqueIdMessage.setAddr(Node.ROOTNODE_ADDR);
            this.sendLocalBidibDownMessage(getUniqueIdMessage);
            BidibCommand getPVersionMessage = this.bidibRequestFactory.createSysGetPVersion();
            getUniqueIdMessage.setAddr(Node.ROOTNODE_ADDR);
            this.sendLocalBidibDownMessage(getPVersionMessage);
        }
        catch (Exception ex) {
            LOGGER.warn("Connect to backend failed.", (Throwable)ex);
            throw new InvalidConfigurationException("Connect to backend failed.");
        }
    }

    private void sendLocalBidibDownMessage(BidibCommand bidibCommand) {
        BidibCommand localBidibDownMessage = this.bidibRequestFactory.createLocalBidibDown(bidibCommand);
        localBidibDownMessage.setAddr(Node.ROOTNODE_ADDR);
        LOGGER.info("Prepared the localBidibDownMessage to forward to backend: {}", (Object)localBidibDownMessage);
        this.hostAdapter.forwardMessageToBackend(this.messageContentSupplier.apply((BidibMessageInterface)localBidibDownMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        SocketAddress remoteAddress = ctx.channel().remoteAddress();
        LOGGER.info("Session closed. IP: {}", (Object)remoteAddress);
        if (remoteAddress == null) {
            SocketAddress localAddress = ctx.channel().localAddress();
            LOGGER.info("No remoteAddress available. Use localAddress: {}", (Object)localAddress);
            remoteAddress = localAddress;
        }
        String connectedRemoteAddress = (String)ctx.channel().attr(ConnectionState.REMOTE_ADDRESS_KEY).get();
        LOGGER.info("The connected remote address: {}", (Object)connectedRemoteAddress);
        if (this.hasActiveConnection() && !Objects.equals(remoteAddress.toString(), connectedRemoteAddress)) {
            LOGGER.info("The primary connection is still established.");
            return;
        }
        ctx.channel().attr(ConnectionState.STATE_KEY).set((Object)ConnectionState.Phase.NOT_CONNECTED);
        super.channelUnregistered(ctx);
        DefaultContext context = new DefaultContext();
        if (this.pairedPartner.getUniqueId() != null) {
            context.register("uniqueId", (Object)this.pairedPartner.getUniqueId());
        }
        LOGGER.info("Signal that the connection to the guest was closed.");
        try {
            this.hostAdapter.signalConnectionClosed((Context)context);
        }
        catch (Exception ex) {
            LOGGER.warn("Signal that the connection to the guest was closed failed.", (Throwable)ex);
        }
        try {
            LOGGER.info("Clear the saved serverLinkData.");
            this.serverLinkData.clear(false);
        }
        catch (Exception ex) {
            LOGGER.warn("Remove uniqueid from serverLinkData failed.", (Throwable)ex);
        }
        Set<ConnectionListener> set = this.pairedPartnerLock;
        synchronized (set) {
            LOGGER.info("Clear the paired partner link data: {}", (Object)this.pairedPartner);
            this.pairedPartner.clear(true);
        }
        LOGGER.info("Release the stored channelHandlerContext: {}", (Object)ctx);
        this.ctx = null;
        if (!this.hasActiveConnection()) {
            ctx.fireUserEventTriggered((Object)new ConnectionUpdateEvent("NOT_CONNECTED"));
        }
        set = this.remoteConnectionListeners;
        synchronized (set) {
            for (ConnectionListener connectionListener : this.remoteConnectionListeners) {
                try {
                    connectionListener.closed(ctx.channel().remoteAddress() != null ? ctx.channel().remoteAddress().toString() : "unknown");
                }
                catch (Exception ex) {
                    LOGGER.warn("Notify that the client connection was closed failed.", (Throwable)ex);
                }
            }
        }
        MSG_RX_NET_LOGGER.info("Disconnected");
    }

    public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) {
        byte[] messageContent = new byte[in.readableBytes()];
        in.readBytes(messageContent);
        LOGGER.info("<<net<<  : {}", (Object)ByteUtils.bytesToHex((byte[])messageContent));
        if (MSG_RX_NET_LOGGER.isInfoEnabled()) {
            MSG_RX_NET_LOGGER.info("<<netraw<< {}", (Object)ByteUtils.bytesToHex((byte[])messageContent));
        }
        try {
            int len = ByteUtils.getInt((byte)messageContent[0]);
            LOGGER.info("Current message len: {}", (Object)len);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                outputStream.write(messageContent);
            }
            catch (IOException ex2) {
                LOGGER.warn("Write data to output stream failed.", (Throwable)ex2);
            }
            MessageUtils.splitBidibMessages((org.bidib.jbidibc.messages.logger.Logger)this.splitMessageLogger, (ByteArrayOutputStream)outputStream, (boolean)false, messageArray -> this.processReceivedMessage(messageArray), (AtomicBoolean)this.isFirstPacket);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create messages from provided data failed.", (Throwable)ex);
        }
    }

    private void processReceivedMessage(byte[] messageArray) throws ProtocolException {
        Object message = null;
        try {
            List commands = this.bidibRequestFactory.create(messageArray);
            LOGGER.info("Received commands: {}", (Object)commands);
            block12: for (BidibMessageInterface bidibCommand : commands) {
                if (MSG_RX_NET_LOGGER.isInfoEnabled()) {
                    StringBuilder sb = new StringBuilder("<<net<< ");
                    sb.append(bidibCommand);
                    sb.append(" : ");
                    sb.append(ByteUtils.bytesToHex((byte[])messageArray));
                    MSG_RX_NET_LOGGER.info(sb.toString());
                }
                switch (ByteUtils.getInt((byte)bidibCommand.getType())) {
                    case 254: {
                        LocalProtocolSignatureMessage localProtocolSignatureMessage = (LocalProtocolSignatureMessage)bidibCommand;
                        this.processMsgLocalProtocolSignature(this.ctx, localProtocolSignatureMessage);
                        continue block12;
                    }
                    case 255: {
                        LocalLinkMessage localLinkMessage = (LocalLinkMessage)bidibCommand;
                        this.processMsgLocalLink(this.ctx, localLinkMessage);
                        continue block12;
                    }
                    case 240: {
                        if (this.hostAdapter != null) {
                            this.hostAdapter.forwardMessageToBackend(this.messageContentSupplier.apply(bidibCommand));
                            continue block12;
                        }
                        LOGGER.warn("No hostAdapter assigned.");
                        continue block12;
                    }
                    case 112: {
                        LocalLogonAckMessage localLogonAckMessage = (LocalLogonAckMessage)bidibCommand;
                        this.processMsgLocalLogonAck(this.ctx, localLogonAckMessage);
                        continue block12;
                    }
                    case 114: {
                        LOGGER.warn("Process the MSG_LOCAL_LOGON_REJECTED !!!");
                        continue block12;
                    }
                }
                LOGGER.debug("Processing BiDiB node related command: {}", (Object)bidibCommand);
                NetBidibLinkData.LogonStatus logonStatus = this.pairedPartner.getLogonStatus();
                if (NetBidibLinkData.LogonStatus.LOGGED_ON == logonStatus) {
                    if (this.hostAdapter != null) {
                        this.hostAdapter.forwardMessageToBackend(this.messageContentSupplier.apply(bidibCommand));
                        continue;
                    }
                    LOGGER.warn("No hostAdapter assigned.");
                    continue;
                }
                LOGGER.warn("The logon status for the paired partner is not LOGGED_ON.");
                throw new IllegalArgumentException("The paired partner is not LOGGED_ON.");
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Process received messages failed: {}", (Object)ByteUtils.bytesToHex((byte[])messageArray), (Object)ex);
            StringBuilder sb = new StringBuilder("<<net<< received invalid: ");
            sb.append((Object)message);
            sb.append(" : ");
            sb.append(ByteUtils.bytesToHex((byte[])messageArray));
            MSG_RX_NET_LOGGER.warn(sb.toString());
            throw ex;
        }
        catch (AccessDeniedException ex) {
            LOGGER.warn("Access was denied.", (Throwable)ex);
            throw ex;
        }
        catch (PairingDeniedException ex) {
            LOGGER.warn("Pairing was denied.", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.warn("Process received messages failed: {}", (Object)ByteUtils.bytesToHex((byte[])messageArray), (Object)ex);
            throw new RuntimeException(ex);
        }
    }

    private void processMsgLocalProtocolSignature(ChannelHandlerContext ctx, LocalProtocolSignatureMessage localProtocolSignatureMessage) throws ProtocolException {
        String requestorName = localProtocolSignatureMessage.getRequestorName();
        LOGGER.info("Received MSG_LOCAL_PROTOCOL_SIGNATURE from requestor: {}", (Object)requestorName);
        if (StringUtils.isBlank((CharSequence)requestorName) || !requestorName.startsWith("BiDiB")) {
            LOGGER.warn("No requestor provided or the requestor does not start with 'BiDiB'. Abort connection.");
            throw new AccessDeniedException("No requestor provided or the requestor does not start with 'BiDiB'.");
        }
        LOGGER.info("Update the pairedPartner with requestorName: {}", (Object)requestorName);
        this.pairedPartner.setRequestorName(requestorName);
        this.sendInitialLocalProtocolSignatureMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMsgLocalLink(ChannelHandlerContext ctx, LocalLinkMessage localLinkMessage) throws ProtocolException {
        LOGGER.info("Received MSG_LOCAL_LINK: {}", (Object)localLinkMessage);
        switch (localLinkMessage.getLinkDescriptor()) {
            case 255: {
                LOGGER.info("Received the partner UID of the host: {}", (Object)ByteUtils.formatHexUniqueId((long)localLinkMessage.getSenderUniqueId()));
                boolean isPaired = false;
                if (this.pairingStore != null) {
                    try {
                        LOGGER.info("Check if the UID is already in the pairing store: {}", (Object)ByteUtils.formatHexUniqueId((long)localLinkMessage.getSenderUniqueId()));
                        LocalPairingStore.PairingLookupResult pairingLookupResult = this.pairingStore.isPaired(localLinkMessage.getSenderUniqueId());
                        isPaired = LocalPairingStore.PairingLookupResult.PAIRED == pairingLookupResult;
                        LOGGER.info("Result of pairingStore lookup, isPaired: {}", (Object)isPaired);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Get the paired status from the pairing store failed.", (Throwable)ex);
                    }
                } else {
                    LOGGER.warn("No pairing store configured.");
                }
                Object ex = this.pairedPartnerLock;
                synchronized (ex) {
                    if (this.pairedPartner.getUniqueId() == null) {
                        LOGGER.info("Update the pairedPartner with uniqueId: {}", (Object)ByteUtils.formatHexUniqueId((long)localLinkMessage.getSenderUniqueId()));
                        this.pairedPartner.setUniqueId(Long.valueOf(localLinkMessage.getSenderUniqueId()));
                        if (isPaired) {
                            LOGGER.info("Set the serverLinkData as paired based on the pairing store entry.");
                            this.serverLinkData.setPairingStatus(NetBidibLinkData.PairingStatus.PAIRED);
                        } else {
                            LOGGER.info("Set the serverLinkData as unpaired based on the pairing store entry.");
                            this.serverLinkData.setPairingStatus(NetBidibLinkData.PairingStatus.UNPAIRED);
                        }
                        LOGGER.info("Created new pairedPartner: {}", (Object)this.pairedPartner);
                    } else if (this.pairedPartner.getUniqueId() == null || localLinkMessage.getSenderUniqueId() != this.pairedPartner.getUniqueId().longValue()) {
                        LOGGER.warn("The provided uniqueId from the sender does not match the stored uniqueId in the pairedPartner. Do not answer and ignore the message.");
                        return;
                    }
                    if (this.serverLinkData.getUniqueId() != null) {
                        LOGGER.info("Current pairingStatus: {}", (Object)this.serverLinkData.getPairingStatus());
                        LocalLinkMessage myUID = new LocalLinkMessage(new byte[]{0}, 0, this.serverLinkData.getUniqueId().longValue());
                        LOGGER.info("Publish uniqueId of server: {}", (Object)myUID);
                        this.publishMessage(ctx, (BidibMessageInterface)myUID);
                        switch (this.serverLinkData.getPairingStatus()) {
                            case UNPAIRED: {
                                LOGGER.info("The partner is not paired. Send the STATUS_UNPAIRED.");
                                try {
                                    this.publishPairedStatus(ctx, 253);
                                }
                                catch (PairingDeniedException ex2) {
                                    LOGGER.info("Pairing is denied but we ignore it here: {}", (Object)ex2.getMessage());
                                }
                                break;
                            }
                            case PAIRED: {
                                LOGGER.info("The partner is paired. Send the STATUS_PAIRED.");
                                this.publishPairedStatus(ctx, 254);
                                break;
                            }
                        }
                    } else {
                        LOGGER.info("No uniqueId from connected backend available yet.");
                    }
                    if (this.serverLinkData.getProdString() != null) {
                        LocalLinkMessage myProd = new LocalLinkMessage(new byte[]{0}, 0, 0, this.serverLinkData.getProdString());
                        LOGGER.info("Publish product string of server: {}", (Object)myProd);
                        this.publishMessage(ctx, (BidibMessageInterface)myProd);
                    } else {
                        LOGGER.info("No prod string from connected backend available yet.");
                    }
                    if (this.serverLinkData.getUserString() != null) {
                        LocalLinkMessage myUser = new LocalLinkMessage(new byte[]{0}, 0, 1, this.serverLinkData.getUserString());
                        LOGGER.info("Publish user string of server: {}", (Object)myUser);
                        this.publishMessage(ctx, (BidibMessageInterface)myUser);
                    } else {
                        LOGGER.info("No user string from connected backend available yet.");
                    }
                    if (this.serverLinkData.getProtocolVersion() != null) {
                        LocalLinkMessage myProtocolVersion = new LocalLinkMessage(new byte[]{0}, 0, 128, this.serverLinkData.getProtocolVersion());
                        LOGGER.info("Publish protocol version of server: {}", (Object)myProtocolVersion);
                        this.publishMessage(ctx, (BidibMessageInterface)myProtocolVersion);
                    } else {
                        LOGGER.info("No protocol version from connected backend available yet.");
                    }
                    break;
                }
            }
            case 128: {
                LOGGER.info("Received the partner P_VERSION: {}", (Object)localLinkMessage.getProtocolVersion());
                Object ex = this.pairedPartnerLock;
                synchronized (ex) {
                    this.pairedPartner.setProtocolVersion(localLinkMessage.getProtocolVersion());
                    break;
                }
            }
            case 0: {
                LOGGER.info("Received the partner PROD_STRING: {}", (Object)localLinkMessage.getProdString());
                Object ex = this.pairedPartnerLock;
                synchronized (ex) {
                    this.pairedPartner.setProdString(localLinkMessage.getProdString());
                    break;
                }
            }
            case 1: {
                LOGGER.info("Received the partner USER_STRING: {}", (Object)localLinkMessage.getProdString());
                Object ex = this.pairedPartnerLock;
                synchronized (ex) {
                    this.pairedPartner.setUserString(localLinkMessage.getProdString());
                    break;
                }
            }
            case 254: {
                Object localLogoffMessage;
                LOGGER.info("Received a paired message, senderUID: {}, receiverUID: {}", (Object)ByteUtils.formatHexUniqueId((long)localLinkMessage.getSenderUniqueId()), (Object)ByteUtils.formatHexUniqueId((long)localLinkMessage.getReceiverUniqueId()));
                Object ex = this.pairedPartnerLock;
                synchronized (ex) {
                    this.pairedPartner.setPairingStatus(NetBidibLinkData.PairingStatus.PAIRED);
                }
                if (this.pairingStore != null) {
                    try {
                        LOGGER.info("Update the pairing store.");
                        this.pairingStore.setPaired(localLinkMessage.getSenderUniqueId(), this.pairedPartner.getRequestorName(), this.pairedPartner.getProdString(), this.pairedPartner.getUserString(), this.pairedPartner.getProtocolVersion(), true);
                        this.pairingStore.store();
                    }
                    catch (Exception ex3) {
                        LOGGER.warn("Store the pairing status failed.", (Throwable)ex3);
                    }
                } else {
                    LOGGER.warn("No pairing store configured.");
                }
                if (this.serverLinkData.getPairingStatus() == NetBidibLinkData.PairingStatus.UNPAIRED) {
                    LOGGER.info("Send the UNPAIRED status.");
                    this.publishPairedStatus(ctx, 253);
                    LOGGER.info("Send the Logoff message.");
                    localLogoffMessage = new LocalLogoffMessage(new byte[]{0}, 0, this.serverLinkData.getUniqueId().longValue());
                    this.publishMessage(ctx, (BidibMessageInterface)localLogoffMessage);
                    break;
                }
                if (this.roleType == RoleTypeEnum.NODE) {
                    LOGGER.info("Send the logon message after receive PAIRED message from remote partner.");
                    localLogoffMessage = this.pairedPartnerLock;
                    synchronized (localLogoffMessage) {
                        if (NetBidibLinkData.PairingStatus.PAIRED == this.pairedPartner.getPairingStatus() && NetBidibLinkData.LogonStatus.LOGGED_OFF == this.pairedPartner.getLogonStatus()) {
                            LOGGER.info("The pairedPartner accepted the pairing already but is LOGGED_OFF. Send the LOGON.");
                            LocalLogonMessage localLogonMessage = new LocalLogonMessage(new byte[]{0}, 0, this.serverLinkData.getUniqueId().longValue());
                            this.publishMessage(ctx, (BidibMessageInterface)localLogonMessage);
                            this.pairedPartner.setLogonStatus(NetBidibLinkData.LogonStatus.LOGGED_ON);
                        }
                        break;
                    }
                }
                LOGGER.info("Do not sent logon because role type INTERFACE is configured.");
                break;
            }
            case 253: {
                LOGGER.info("Received an UNPAIRED message, senderUID: {}, receiverUID: {}", (Object)ByteUtils.formatHexUniqueId((long)localLinkMessage.getSenderUniqueId()), (Object)ByteUtils.formatHexUniqueId((long)localLinkMessage.getReceiverUniqueId()));
                Object localLogoffMessage = this.pairedPartnerLock;
                synchronized (localLogoffMessage) {
                    this.pairedPartner.setPairingStatus(NetBidibLinkData.PairingStatus.UNPAIRED);
                    break;
                }
            }
            case 252: {
                LOGGER.info("Received a pairing request, senderUID: {}, receiverUID: {}, pairingTimeout: {}", new Object[]{ByteUtils.formatHexUniqueId((long)localLinkMessage.getSenderUniqueId()), ByteUtils.formatHexUniqueId((long)localLinkMessage.getReceiverUniqueId()), localLinkMessage.getPairingTimeout()});
                Object localLogoffMessage = this.pairedPartnerLock;
                synchronized (localLogoffMessage) {
                    this.pairedPartner.setUniqueId(Long.valueOf(localLinkMessage.getSenderUniqueId()));
                    this.pairedPartner.setPairingStatus(NetBidibLinkData.PairingStatus.PAIRING_REQUESTED);
                }
                Integer pairingTimeout = localLinkMessage.getPairingTimeout();
                this.pairingWorker.schedule(() -> {
                    Boolean paired = Boolean.FALSE;
                    if (this.pairingCallback != null) {
                        LOGGER.info("Use the pairing callback to get the paired result.");
                        Object object = this.pairedPartnerLock;
                        synchronized (object) {
                            paired = this.pairingCallback.apply(this.pairedPartner, pairingTimeout);
                        }
                    } else {
                        LOGGER.warn("No pairingCallback available. Accept every client.");
                        paired = Boolean.TRUE;
                    }
                    LOGGER.info("After pairing callback. Pairing success: {}, pairedPartner: {}", (Object)paired, (Object)this.pairedPartner);
                    try {
                        if (Boolean.TRUE.equals(paired)) {
                            this.publishPairedStatus(ctx, 254);
                        } else {
                            this.publishPairedStatus(ctx, 253);
                        }
                    }
                    catch (ProtocolException ex) {
                        LOGGER.warn("Publish paired status failed.", (Throwable)ex);
                    }
                    catch (PairingDeniedException ex) {
                        LOGGER.warn("Pairing was denied. We must close the connection.", (Throwable)ex);
                        this.channelGroup.close();
                    }
                }, 5L, TimeUnit.MILLISECONDS);
                break;
            }
            default: {
                LOGGER.warn("Unhandled message: {}", (Object)localLinkMessage);
            }
        }
    }

    public void setPairingCallback(BiFunction<NetBidibLinkData, Integer, Boolean> pairingCallback) {
        LOGGER.info("Set the pairing callback: {}", pairingCallback);
        this.pairingCallback = pairingCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMsgLocalLogonAck(ChannelHandlerContext ctx, LocalLogonAckMessage localLogonAckMessage) {
        LOGGER.info("Received MSG_LOCAL_LOGON_ACK: {}", (Object)localLogonAckMessage);
        int nodeAddress = localLogonAckMessage.getNodeAddress();
        long uniqueId = localLogonAckMessage.getSenderUniqueId();
        LOGGER.info("Current nodeAddress: {}, uniqueId: {}", (Object)nodeAddress, (Object)ByteUtils.formatHexUniqueId((long)uniqueId));
        if (this.serverLinkData.getUniqueId() == uniqueId) {
            Object object = this.pairedPartnerLock;
            synchronized (object) {
                this.pairedPartner.setLogonStatus(NetBidibLinkData.LogonStatus.LOGGED_ON);
                LOGGER.info("Current pairedPartner: {}", (Object)this.pairedPartner);
            }
        } else {
            LOGGER.warn("The provided uniqueId does not match, provided: {}, expected: {}", (Object)ByteUtils.formatHexUniqueId((long)uniqueId), (Object)ByteUtils.formatHexUniqueId((Long)this.serverLinkData.getUniqueId()));
        }
    }

    protected void publishPairedStatus(ChannelHandlerContext ctx, int descriptor) throws ProtocolException {
        LOGGER.info("Publish the paired status: {}", (Object)descriptor);
        if (254 == descriptor) {
            LOGGER.info("The BIDIB_LINK_STATUS_PAIRED is published.");
            ctx.channel().attr(ConnectionState.STATE_KEY).set((Object)ConnectionState.Phase.PAIRED);
            LOGGER.info("Send the status pairing status PAIRED message to the client.");
            LocalLinkMessage statusPaired = this.bidibRequestFactory.createLocalLinkStatusPaired(this.serverLinkData.getUniqueId().longValue(), this.pairedPartner.getUniqueId().longValue());
            this.publishMessage(ctx, (BidibMessageInterface)statusPaired);
            this.serverLinkData.setPairingStatus(NetBidibLinkData.PairingStatus.PAIRED);
            LOGGER.info("Current pairedPartner: {}, serverLinkData: {}", (Object)this.pairedPartner, (Object)this.serverLinkData);
            if (NetBidibLinkData.PairingStatus.PAIRED == this.pairedPartner.getPairingStatus() && NetBidibLinkData.PairingStatus.PAIRED == this.serverLinkData.getPairingStatus() && NetBidibLinkData.LogonStatus.LOGGED_OFF == this.pairedPartner.getLogonStatus()) {
                LOGGER.info("The pairedPartner accepted the pairing already. Send the LOGON.");
                LocalLogonMessage localLogonMessage = new LocalLogonMessage(new byte[]{0}, 0, this.serverLinkData.getUniqueId().longValue());
                this.publishMessage(ctx, (BidibMessageInterface)localLogonMessage);
                this.pairedPartner.setLogonStatus(NetBidibLinkData.LogonStatus.LOGGED_ON);
            } else {
                LOGGER.info("LOGON was not sent.");
            }
        } else {
            LOGGER.info("The BIDIB_LINK_STATUS_UNPAIRED is published.");
            ctx.channel().attr(ConnectionState.STATE_KEY).set((Object)ConnectionState.Phase.UNPAIRED);
            LocalLinkMessage statusUnpaired = this.bidibRequestFactory.createLocalLinkStatusUnpaired(this.serverLinkData.getUniqueId().longValue(), this.pairedPartner.getUniqueId().longValue());
            this.publishMessage(ctx, (BidibMessageInterface)statusUnpaired);
            this.serverLinkData.setPairingStatus(NetBidibLinkData.PairingStatus.UNPAIRED);
            LOGGER.info("Throw PairingDeniedException to signal the connection is not paired. Current uniqueId: {}", (Object)ByteUtils.formatHexUniqueId((Long)this.pairedPartner.getUniqueId()));
            throw new PairingDeniedException("Pairing denied for uniqueId: " + ByteUtils.formatHexUniqueId((Long)this.pairedPartner.getUniqueId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processLocalBidibUpResponseFromBackend(LocalBidibUpResponse localBidibUpResponse) throws ProtocolException {
        boolean sendPairingStatusIfRequired = false;
        try {
            byte[] wrapped = localBidibUpResponse.getWrappedMessage();
            byte[] raw = ByteUtils.concat((byte[])new byte[]{ByteUtils.getLowByte((int)(wrapped.length + 2)), 0, 0}, (byte[])wrapped);
            BidibMessageInterface message = this.responseFactory.create(raw);
            LOGGER.info("Received wrapped message: {}", (Object)message);
            boolean publish = false;
            block9 : switch (ByteUtils.getInt((byte)message.getType())) {
                case 132: {
                    SysUniqueIdResponse response = (SysUniqueIdResponse)message;
                    Object object = this.pairedPartnerLock;
                    synchronized (object) {
                        publish = this.serverLinkData.getUniqueId() == null;
                        this.serverLinkData.setUniqueId(Long.valueOf(NodeUtils.getUniqueId((byte[])response.getUniqueId())));
                        if (this.pairedPartner != null && this.pairedPartner.getUniqueId() != null && publish) {
                            LOGGER.info("Publish the uniqueId: {}", (Object)this.serverLinkData.getUniqueId());
                            LocalLinkMessage myUID = new LocalLinkMessage(new byte[]{0}, 0, this.serverLinkData.getUniqueId().longValue());
                            this.publishMessage(this.ctx, (BidibMessageInterface)myUID);
                        }
                        break;
                    }
                }
                case 149: {
                    StringResponse stringResponse = (StringResponse)message;
                    StringData stringData = stringResponse.getStringData();
                    switch (stringData.getIndex()) {
                        case 0: {
                            Object object = this.pairedPartnerLock;
                            synchronized (object) {
                                publish = this.serverLinkData.getProdString() == null;
                                this.serverLinkData.setProdString(stringData.getValue());
                                if (this.pairedPartner != null && this.pairedPartner.getUniqueId() != null && publish) {
                                    LocalLinkMessage myProd = new LocalLinkMessage(new byte[]{0}, 0, 0, this.serverLinkData.getProdString());
                                    LOGGER.info("Publish the product string: {}", (Object)myProd);
                                    this.publishMessage(this.ctx, (BidibMessageInterface)myProd);
                                }
                                break block9;
                            }
                        }
                        case 1: {
                            Object object = this.pairedPartnerLock;
                            synchronized (object) {
                                publish = this.serverLinkData.getUserString() == null;
                                this.serverLinkData.setUserString(stringData.getValue());
                                if (this.pairedPartner != null && this.pairedPartner.getUniqueId() != null && publish) {
                                    LocalLinkMessage myUser = new LocalLinkMessage(new byte[]{0}, 0, 1, this.serverLinkData.getUserString());
                                    LOGGER.info("Publish the user string: {}", (Object)myUser);
                                    this.publishMessage(this.ctx, (BidibMessageInterface)myUser);
                                }
                                break block9;
                            }
                        }
                        default: {
                            break block9;
                        }
                    }
                }
                case 131: {
                    SysPVersionResponse pVersionResponse = (SysPVersionResponse)message;
                    Object object = this.pairedPartnerLock;
                    synchronized (object) {
                        publish = this.serverLinkData.getProtocolVersion() == null;
                        this.serverLinkData.setProtocolVersion(pVersionResponse.getVersion());
                        if (this.pairedPartner != null && this.pairedPartner.getUniqueId() != null && publish) {
                            LocalLinkMessage myProtocolVersion = new LocalLinkMessage(new byte[]{0}, 0, 128, this.serverLinkData.getProtocolVersion());
                            LOGGER.info("Publish the protocol version: {}", (Object)myProtocolVersion);
                            this.publishMessage(this.ctx, (BidibMessageInterface)myProtocolVersion);
                        }
                        sendPairingStatusIfRequired = true;
                        break;
                    }
                }
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create message from wrapped message data failed: {}", (Object)ex.getMessage());
            throw new ProtocolInvalidContentException("Create message from wrapped message data failed.", (Throwable)ex);
        }
        catch (Exception ex) {
            LOGGER.warn("Process the LocalBidibUpResponse message failed.", (Throwable)ex);
            throw new ProtocolException("Process the LocalBidibUpResponse message failed.");
        }
        return sendPairingStatusIfRequired;
    }

    private void publishMessage(ChannelHandlerContext ctx, BidibMessageInterface message) {
        LOGGER.info("Publish the message to channel: {}", (Object)message);
        byte[] msg = message.getContent();
        if (MSG_TX_NET_LOGGER.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder(">>net>> ");
            sb.append(message);
            sb.append(" : ");
            sb.append(ByteUtils.bytesToHex((byte[])msg));
            MSG_TX_NET_LOGGER.info(sb.toString());
        }
        ((Channel)this.channelGroup.iterator().next()).writeAndFlush((Object)Unpooled.copiedBuffer((byte[])msg));
        LOGGER.info("Write message to socketChannel has finished, msg: {}", (Object)ByteUtils.bytesToHex((byte[])msg));
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        LOGGER.debug("channelReadComplete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.warn("Exception in handler. Close the channelHandlerContext.", cause);
        if (cause instanceof IOException) {
            LOGGER.warn("IOException: {}", (Object)cause.getMessage());
        } else {
            LOGGER.warn("Exception caught in server handler. Will close connection.", cause);
        }
        ctx.channel().attr(ConnectionState.STATE_KEY).set((Object)ConnectionState.Phase.NOT_CONNECTED);
        ctx.close();
        LOGGER.info("Clear the info of the paired partner.");
        Object object = this.pairedPartnerLock;
        synchronized (object) {
            this.pairedPartner.clear(true);
        }
    }

    public boolean hasActiveConnection() {
        return !this.channelGroup.isEmpty();
    }
}

