/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.server;

import io.netty.channel.group.ChannelGroup;
import java.io.IOException;
import java.util.function.Consumer;
import org.bidib.jbidibc.messages.HostAdapter;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.netbidib.server.NetBidibServer;
import org.bidib.jbidibc.netbidib.server.NetBidibServerHandler;
import org.bidib.jbidibc.netbidib.server.NetBidibServerHandlerByteArray;
import org.bidib.jbidibc.netbidib.server.RoleTypeEnum;
import org.bidib.jbidibc.netbidib.server.adapter.ScmSerialHostAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBidibServerByteArray
extends NetBidibServer<byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibServerByteArray.class);

    public NetBidibServerByteArray(HostAdapter<byte[]> hostAdapter, String backendPortName, NetBidibLinkData serverLinkData, RoleTypeEnum roleType, NetBidibLinkData pairedPartner) {
        this("localhost", 62875, hostAdapter, backendPortName, serverLinkData, roleType, pairedPartner);
    }

    public NetBidibServerByteArray(String hostName, int portNumber, HostAdapter<byte[]> hostAdapter, String backendPortName, NetBidibLinkData serverLinkData, RoleTypeEnum roleType, NetBidibLinkData pairedPartner) {
        super(hostName, portNumber, hostAdapter, backendPortName, serverLinkData, roleType, pairedPartner);
    }

    @Override
    protected NetBidibServerHandler<byte[]> createNetBidibServerHandler(ChannelGroup channelGroup, NetBidibLinkData serverLinkData, HostAdapter<byte[]> hostAdapter, String backendPortName, Consumer<NetBidibServerHandler<byte[]>> lazyInitializationCallback, RoleTypeEnum roleType, NetBidibLinkData pairedPartner) {
        NetBidibServerHandlerByteArray serverHandler = new NetBidibServerHandlerByteArray(channelGroup, hostAdapter, backendPortName, serverLinkData, lazyInitializationCallback, roleType, pairedPartner);
        return serverHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException, IOException {
        String backendPortName = null;
        if (args.length <= 0) {
            LOGGER.warn("Provide the backend port name as argument, e.g. COM5");
            return;
        }
        backendPortName = args[0];
        LOGGER.info("Start the server. The current backendPortName: {}", (Object)backendPortName);
        NetBidibLinkData serverLinkData = new NetBidibLinkData(NetBidibLinkData.PartnerType.LOCAL);
        serverLinkData.setProtocolVersion(ProtocolVersion.VERSION_0_8);
        ScmSerialHostAdapter<byte[]> hostAdapter = new ScmSerialHostAdapter<byte[]>(message -> message.getContent());
        RoleTypeEnum roleType = RoleTypeEnum.INTERFACE;
        NetBidibLinkData pairedPartner = new NetBidibLinkData(NetBidibLinkData.PartnerType.REMOTE);
        pairedPartner.setPairingStatus(NetBidibLinkData.PairingStatus.UNKNOWN);
        pairedPartner.setLogonStatus(NetBidibLinkData.LogonStatus.LOGGED_OFF);
        NetBidibServerByteArray netBidibServer = new NetBidibServerByteArray("localhost", 62875, (HostAdapter<byte[]>)hostAdapter, backendPortName, serverLinkData, roleType, pairedPartner);
        netBidibServer.setShutdownHook(new Thread(() -> {
            LOGGER.info("Run shutdown hook.");
            try {
                netBidibServer.stop();
            }
            catch (Exception ex) {
                LOGGER.warn("Stop the netBidibServer failed.", (Throwable)ex);
            }
        }));
        Runtime.getRuntime().addShutdownHook(netBidibServer.getShutdownHook());
        netBidibServer.startServer();
        LOGGER.info("Wait for server startup.");
        try {
            Object shutdownLock;
            Thread.sleep(500L);
            LOGGER.info("Wait for shutdown.");
            Object object = shutdownLock = netBidibServer.getShutdownLock();
            synchronized (object) {
                shutdownLock.wait();
            }
        }
        finally {
            LOGGER.info("Stop the netBidibServer.");
            try {
                netBidibServer.stop();
            }
            catch (Exception ex) {
                LOGGER.warn("Stop the netBidibServer failed.", (Throwable)ex);
            }
        }
    }
}

