package org.bidib.jbidibc.netbidib.server.adapter;

import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.function.Function;

import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.SequenceNumberProvider;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.SimulationMessageReceiver;
import org.bidib.jbidibc.simulation.demo.DemoMaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulationHostAdapter extends DefaultHostAdapter<byte[]> {

    private static final Logger LOGGER = LoggerFactory.getLogger(SimulationHostAdapter.class);

    private DemoMaster demoMaster;

    private final BidibRequestFactory requestFactory;

    public SimulationHostAdapter(Function<BidibMessageInterface, byte[]> messageContentSupplier) {
        super(messageContentSupplier);
        this.requestFactory = new BidibRequestFactory();
        this.requestFactory.initialize();
    }

    @Override
    public void forwardMessageToBackend(final byte[] rawMessage) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Forward message to backend: {}", ByteUtils.bytesToHex(rawMessage));
        }

        if (getToBackendPublisher() != null) {
            getToBackendPublisher().publishBidibMessage(null, rawMessage);
        }
        else {

            if (demoMaster == null) {
                long uniqueId = 0xDA000D680064EAL;
                boolean autoAddFeature = false;
                final SimulationBidibMessageProcessor messageReceiver = new SimulationMessageReceiver() {

                    @Override
                    public void removeNodeListener(NodeListener nodeListener) {

                    }

                    @Override
                    public void publishResponse(ByteArrayOutputStream output) throws ProtocolException {

                        // Publish the responses to the host
                        LOGGER
                            .info("Publish the response. Prepare message to send to host using toHostPublisher: {}",
                                getToGuestPublisher());
                        try {
                            // send to handler
                            getToGuestPublisher().publishBidibMessage(null, output.toByteArray());
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Process messages failed.", ex);
                        }
                    }

                };
                LOGGER.info("Create and init the demo master.");

                final Context context = new DefaultContext();

                demoMaster =
                    new DemoMaster(new byte[] { 0 }, uniqueId, autoAddFeature, messageReceiver, this.requestFactory);
                demoMaster.setProtocolVersion(ProtocolVersion.VERSION_0_8.toString());
                demoMaster.setSoftwareVersion(SoftwareVersion.build(1, 0, 0).toString());
                demoMaster.init(context);
                demoMaster.start();
            }

            LOGGER.warn("Demo only. Let the demo master send the message to the host.");
            try {
                List<BidibMessageInterface> commands = requestFactory.create(rawMessage);

                for (BidibMessageInterface bidibMessage : commands) {
                    demoMaster.processRequest(bidibMessage);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Process request in demoMaster failed.", ex);
            }
        }

    }

    @Override
    public void forwardMessageToGuest(final SequenceNumberProvider node, final byte[] rawMessage) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Forward message to host: {}", ByteUtils.bytesToHex(rawMessage));
        }

        getToGuestPublisher().publishBidibMessage(node, rawMessage);
    }

}
