package org.bidib.jbidibc.netbidib.server.adapter;

import java.util.function.Function;

import org.bidib.jbidibc.messages.BidibMessagePublisher;
import org.bidib.jbidibc.messages.HostAdapter;
import org.bidib.jbidibc.messages.SequenceNumberProvider;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHostAdapter<T> implements HostAdapter<T> {

    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHostAdapter.class);

    private BidibMessagePublisher<T> toGuestPublisher;

    private BidibMessagePublisher<T> toBackendPublisher;

    protected final Function<BidibMessageInterface, T> messageContentSupplier;

    public DefaultHostAdapter(Function<BidibMessageInterface, T> messageContentSupplier) {
        this.messageContentSupplier = messageContentSupplier;
    }

    @Override
    public void initialize(final Context context) {

    }

    /**
     * @return the toGuestPublisher
     */
    public BidibMessagePublisher<T> getToGuestPublisher() {
        return toGuestPublisher;
    }

    /**
     * @param toGuestPublisher
     *            the toGuestPublisher to set
     */
    @Override
    public void setToGuestPublisher(BidibMessagePublisher<T> toGuestPublisher) {
        LOGGER.info("Set the toGuestPublisher: {}", toGuestPublisher);
        this.toGuestPublisher = toGuestPublisher;
    }

    /**
     * @return the toBackendPublisher
     */
    public BidibMessagePublisher<T> getToBackendPublisher() {
        return toBackendPublisher;
    }

    /**
     * @param toBackendPublisher
     *            the toBackendPublisher to set
     */
    @Override
    public void setToBackendPublisher(BidibMessagePublisher<T> toBackendPublisher) {
        LOGGER.info("Set the toBackendPublisher: {}", toBackendPublisher);
        this.toBackendPublisher = toBackendPublisher;
    }

    @Override
    public void forwardMessageToBackend(final T rawMessage) {
        // if (LOGGER.isTraceEnabled()) {
        // LOGGER.trace("Forward message to the backend: {}", ByteUtils.bytesToHex(rawMessage));
        // }

        if (toBackendPublisher != null) {
            toBackendPublisher.publishBidibMessage(null, rawMessage);
        }
        else {
            LOGGER.warn("No toBackendPublisher available, discard message.");
        }
    }

    @Override
    public void forwardMessageToGuest(final SequenceNumberProvider node, final T rawMessage) {
        // if (LOGGER.isTraceEnabled()) {
        // LOGGER.trace("Forward message to host: {}", ByteUtils.bytesToHex(rawMessage));
        // }
        if (toGuestPublisher != null) {
            toGuestPublisher.publishBidibMessage(node, rawMessage);
        }
        else {
            LOGGER.warn("No toGuestPublisher available, discard message.");
        }
    }

    @Override
    public void signalConnectionOpened(final Context context) {
        LOGGER.info("The connection was opened. Current toBackendPublisher: {}", toBackendPublisher);

    }

    @Override
    public void signalConnectionClosed(final Context context) {
        LOGGER.info("The connection was closed.");

    }
}
