/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.BidibResponseFactory;
import org.bidib.jbidibc.messages.message.netbidib.LocalProtocolSignatureMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBidibClientHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibClientHandler.class);
    private final BidibRequestFactory requestFactory = new BidibRequestFactory();
    private final BidibResponseFactory responseFactory;
    private String clientRequestor = "BiDiB-Wizard-Client";

    public NetBidibClientHandler() {
        this.requestFactory.setEscapeMagic(false);
        this.requestFactory.initialize();
        this.responseFactory = new BidibResponseFactory();
        this.responseFactory.initialize();
    }

    public String getClientRequestor() {
        return this.clientRequestor;
    }

    public void setClientRequestor(String clientRequestor) {
        this.clientRequestor = clientRequestor;
    }

    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        LOGGER.info("Channel became active. Send the initial MSG_LOCAL_PROTOCOL_SIGNATURE message to the server.");
        try {
            LocalProtocolSignatureMessage bidibCommand = this.requestFactory.createLocalProtocolSignature(this.clientRequestor);
            channelHandlerContext.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])bidibCommand.getContent()));
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Prepare the MSG_LOCAL_PROTOCOL_SIGNATURE message failed.", (Throwable)ex);
        }
    }

    public void channelRead0(ChannelHandlerContext channelHandlerContext, ByteBuf in) {
        byte[] messageContent = new byte[in.readableBytes()];
        in.readBytes(messageContent);
        LOGGER.info("Client received message content: {}", (Object)ByteUtils.bytesToHex((byte[])messageContent));
        try {
            BidibMessageInterface message = this.responseFactory.create(messageContent);
            LOGGER.info("Received message: {}", (Object)message);
        }
        catch (Exception ex) {
            LOGGER.warn("Create concrete message from byte content failed.", (Throwable)ex);
        }
        LOGGER.info("The client handler will close the connection.");
        channelHandlerContext.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable cause) {
        LOGGER.warn("Exception in handler. Close the channelHandlerContext.", cause);
        channelHandlerContext.close();
    }
}

