/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.server;

import io.netty.buffer.Unpooled;
import io.netty.channel.group.ChannelGroup;
import java.util.function.Consumer;
import org.bidib.jbidibc.messages.HostAdapter;
import org.bidib.jbidibc.messages.SequenceNumberProvider;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.LocalBidibUpResponse;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.netbidib.exception.PairingDeniedException;
import org.bidib.jbidibc.netbidib.server.NetBidibServerHandler;
import org.bidib.jbidibc.netbidib.server.RoleTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBidibServerHandlerByteArray
extends NetBidibServerHandler<byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibServerHandlerByteArray.class);
    private static final Logger MSG_TX_NET_LOGGER = LoggerFactory.getLogger((String)"TX_NET");

    public NetBidibServerHandlerByteArray(ChannelGroup channelGroup, HostAdapter<byte[]> hostAdapter, String backendPortName, NetBidibLinkData serverLinkData, Consumer<NetBidibServerHandler<byte[]>> lazyInitializationCallback, RoleTypeEnum roleType, NetBidibLinkData pairedPartner) {
        super(channelGroup, hostAdapter, backendPortName, serverLinkData, lazyInitializationCallback, message -> message.getContent(), roleType, pairedPartner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishBidibMessage(SequenceNumberProvider proxyNode, byte[] content) {
        LOGGER.info("Received message to publish to host: {}", (Object)ByteUtils.bytesToHex((byte[])content));
        if (this.handleLocalBidibUpResponse()) {
            try {
                BidibMessageInterface message = this.responseFactory.create(content);
                if (message instanceof LocalBidibUpResponse) {
                    LocalBidibUpResponse localBidibUpResponse = (LocalBidibUpResponse)message;
                    LOGGER.info("Do not deliver LocalBidibUpResponse: {}", (Object)localBidibUpResponse);
                    boolean sendPairingStatusIfRequired = this.processLocalBidibUpResponseFromBackend(localBidibUpResponse);
                    if (sendPairingStatusIfRequired) {
                        LOGGER.info("Check if we must send the current pairing status: {}", (Object)this.serverLinkData);
                        if (this.serverLinkData.getUniqueId() != null) {
                            try {
                                if (this.serverLinkData.getPairingStatus() == null || this.serverLinkData.getPairingStatus() == NetBidibLinkData.PairingStatus.UNKNOWN) {
                                    LOGGER.warn("Set the pairing status from UNKNOWN to UNPAIRED.");
                                    this.serverLinkData.setPairingStatus(NetBidibLinkData.PairingStatus.UNPAIRED);
                                }
                                LOGGER.info("Current pairingStatus stored in serverLinkData: {}", (Object)this.serverLinkData.getPairingStatus());
                                switch (this.serverLinkData.getPairingStatus()) {
                                    case UNPAIRED: {
                                        LOGGER.info("The partner is not paired. Send the STATUS_UNPAIRED.");
                                        this.publishPairedStatus(this.ctx, 253);
                                        break;
                                    }
                                    case PAIRED: {
                                        LOGGER.info("The partner is paired. Send the STATUS_PAIRED.");
                                        this.publishPairedStatus(this.ctx, 254);
                                        break;
                                    }
                                }
                            }
                            catch (PairingDeniedException pde) {
                                LOGGER.info("The pairing is denied.", (Throwable)pde);
                            }
                        } else {
                            LOGGER.info("The uniqueId of the server link is not yet available.");
                        }
                    }
                    return;
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Check if message is local response failed.");
            }
        }
        Object ex = this.pairedPartnerLock;
        synchronized (ex) {
            if (this.pairedPartner == null || NetBidibLinkData.LogonStatus.LOGGED_OFF == this.pairedPartner.getLogonStatus()) {
                LOGGER.warn("The paired partner is not available or not logged on. Discard the message. Current pairedPartner: {}", (Object)this.pairedPartner);
                return;
            }
        }
        LOGGER.info("Publish the message data to channel: {}", (Object)ByteUtils.bytesToHex((byte[])content));
        if (MSG_TX_NET_LOGGER.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder(">>net>>");
            sb.append("BiDiB");
            sb.append(" : ");
            sb.append(ByteUtils.bytesToHex((byte[])content));
            MSG_TX_NET_LOGGER.info(sb.toString());
        }
        this.ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])content));
    }
}

