/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.time.StopWatch;
import org.bidib.jbidibc.core.schema.BidibFactory;
import org.bidib.jbidibc.messages.BidibMessagePublisher;
import org.bidib.jbidibc.messages.HostAdapter;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.jbidibc.netbidib.server.NetBidibServerHandler;
import org.bidib.jbidibc.netbidib.server.RoleTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NetBidibServer<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibServer.class);
    public static final int DEFAULT_PORTNUM = 62875;
    public static final String DEFAULT_HOSTNAME = "localhost";
    private int portNumber = 62875;
    private String hostName;
    private String connectionName;
    private EventLoopGroup group;
    private EventLoopGroup parentGroup;
    private ChannelGroup channelGroup;
    private ChannelFuture channelFuture;
    private final HostAdapter<T> hostAdapter;
    private final Object shutdownLock = new Object();
    private Thread shutdownHook;
    private NetBidibLinkData serverLinkData;
    private final ScheduledExecutorService serverWorkers;
    private final RoleTypeEnum roleType;
    private final NetBidibLinkData pairedPartner;

    public NetBidibServer(HostAdapter<T> hostAdapter, String connectionName, NetBidibLinkData serverLinkData, RoleTypeEnum roleType, NetBidibLinkData pairedPartner) {
        this(DEFAULT_HOSTNAME, 62875, hostAdapter, connectionName, serverLinkData, roleType, pairedPartner);
    }

    public NetBidibServer(String hostName, int portNumber, HostAdapter<T> hostAdapter, String connectionName, NetBidibLinkData serverLinkData, RoleTypeEnum roleType, NetBidibLinkData pairedPartner) {
        this.hostName = hostName;
        this.portNumber = portNumber;
        this.hostAdapter = hostAdapter;
        this.connectionName = connectionName;
        this.serverLinkData = serverLinkData;
        this.roleType = roleType;
        this.pairedPartner = pairedPartner;
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("netBidibServerWorkers-thread-%d").build();
        this.serverWorkers = Executors.newScheduledThreadPool(1, namedThreadFactory);
    }

    public Thread getShutdownHook() {
        return this.shutdownHook;
    }

    public void setShutdownHook(Thread shutdownHook) {
        this.shutdownHook = shutdownHook;
    }

    public Object getShutdownLock() {
        return this.shutdownLock;
    }

    protected abstract NetBidibServerHandler<T> createNetBidibServerHandler(ChannelGroup var1, NetBidibLinkData var2, HostAdapter<T> var3, String var4, Consumer<NetBidibServerHandler<T>> var5, RoleTypeEnum var6, NetBidibLinkData var7);

    public void startServer() {
        Runnable serverThread = () -> {
            try {
                this.group = new NioEventLoopGroup();
                this.parentGroup = new NioEventLoopGroup();
                this.channelGroup = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);
                LOGGER.info("Create ServerBootstrap with hostname: {}, portNumber: {}", (Object)this.hostName, (Object)this.portNumber);
                try {
                    ChannelFuture channelFuture;
                    ServerBootstrap serverBootstrap = new ServerBootstrap();
                    serverBootstrap.group(this.parentGroup, this.group);
                    serverBootstrap.channel(NioServerSocketChannel.class);
                    serverBootstrap.localAddress((SocketAddress)new InetSocketAddress(this.hostName, this.portNumber));
                    serverBootstrap.option(ChannelOption.SO_BACKLOG, (Object)100);
                    serverBootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
                    serverBootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                        protected void initChannel(SocketChannel socketChannel) throws Exception {
                            LOGGER.info("Init the socketChannel: {}", (Object)socketChannel);
                            NetBidibServerHandler serverHandler = NetBidibServer.this.createNetBidibServerHandler(NetBidibServer.this.channelGroup, NetBidibServer.this.serverLinkData, NetBidibServer.this.hostAdapter, NetBidibServer.this.connectionName, toHostPublisher -> NetBidibServer.this.hostAdapter.setToGuestPublisher((BidibMessagePublisher)toHostPublisher), NetBidibServer.this.roleType, NetBidibServer.this.pairedPartner);
                            socketChannel.pipeline().addLast(new ChannelHandler[]{serverHandler});
                        }
                    });
                    LOGGER.info("Start pre-loading the messageTypes.");
                    StopWatch sw = StopWatch.createStarted();
                    BidibFactory.getMessageTypes();
                    sw.stop();
                    LOGGER.info("Finished pre-loading the messageTypes, duration: {}ms", (Object)sw.getTime());
                    LOGGER.info("Start the TCP server.");
                    this.channelFuture = channelFuture = serverBootstrap.bind().sync();
                    Channel channel = channelFuture.channel();
                    channel.closeFuture().sync();
                    LOGGER.info("The TCP server channel was closed.");
                }
                catch (Exception ex) {
                    LOGGER.warn("Process socket with netty failed.", (Throwable)ex);
                }
                finally {
                    this.group.shutdownGracefully().sync();
                }
                LOGGER.info("The TCP server has finished.");
            }
            catch (Exception ex) {
                LOGGER.warn("Start the server failed.", (Throwable)ex);
            }
        };
        this.serverWorkers.submit(serverThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LOGGER.info("Stop the NetBidibServer instance.");
        if (this.channelFuture != null) {
            LOGGER.info("Close the channel of the server.");
            try {
                this.channelFuture.channel().disconnect();
            }
            catch (Exception ex) {
                LOGGER.warn("Disconnect the channel failed.", (Throwable)ex);
            }
            this.channelFuture = null;
        } else {
            LOGGER.info("No channelFuture available.");
        }
        if (this.group != null) {
            Future terminate = this.group.shutdownGracefully(2L, 5L, TimeUnit.SECONDS);
            LOGGER.info("Wait for termination of server.");
            try {
                terminate.await(10000L);
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Wait for termination of server failed.", (Throwable)ex);
            }
            this.group = null;
        }
        LOGGER.info("Shutdown the serverWorker.");
        this.serverWorkers.shutdown();
        try {
            this.serverWorkers.awaitTermination(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait for termination of serverWorker failed.", (Throwable)ex);
        }
        Object object = this.shutdownLock;
        synchronized (object) {
            LOGGER.info("Notify the shutdownLock.");
            this.shutdownLock.notifyAll();
        }
    }
}

