package org.bidib.jbidibc.netbidib.server;

import java.util.UUID;

import io.netty.util.AttributeKey;

public class ConnectionState {
    /**
     * String to use to indicate that currently no connection is established.
     */
    public static final String NOT_CONNECTED = "NOT_CONNECTED";

    /**
     * Key to retrieve the state from the session.
     */
    public static final AttributeKey<ConnectionState.Phase> STATE_KEY =
        AttributeKey.valueOf("NetBidib.STATE_KEY_" + UUID.randomUUID());

    /**
     * Key to retrieve the remote address from the session.
     */
    public static final AttributeKey<String> REMOTE_ADDRESS_KEY =
        AttributeKey.valueOf("NetBidib.REMOTE_ADDRESS_KEY_" + UUID.randomUUID());

    /**
     * Enums for each phase.
     */
    public enum Phase {
        NOT_CONNECTED, CONFIRMATION_PENDING, UNPAIRED, PAIRED
    }
}
