/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.server;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.bidib.jbidibc.messages.BidibMessagePublisher;
import org.bidib.jbidibc.messages.HostAdapter;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.SequenceNumberProvider;
import org.bidib.jbidibc.messages.message.SysMagicResponse;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.netbidib.pairingstore.LocalPairingStore;
import org.bidib.jbidibc.netbidib.pairingstore.PairingStore;
import org.bidib.jbidibc.netbidib.server.NetBidibClientHandler;
import org.bidib.jbidibc.netbidib.server.NetBidibServer;
import org.bidib.jbidibc.netbidib.server.NetBidibServerByteArray;
import org.bidib.jbidibc.netbidib.server.NetBidibServerHandler;
import org.bidib.jbidibc.netbidib.server.RoleTypeEnum;
import org.bidib.jbidibc.netbidib.server.adapter.DefaultHostAdapter;
import org.bidib.jbidibc.netbidib.server.adapter.RxtxSerialHostAdapter;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class RxtxNetBidibServerTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(RxtxNetBidibServerTest.class);
    public static final String PAIRINGSTORE_FILENAME = ".pairingstore_" + RxtxNetBidibServerTest.class.getSimpleName();
    private static final String OUTPUT_TARGET_DIR = "target/pairingstore-test";
    private static final String SERVER_REQUESTOR = "BiDiB-Server-Test";

    @Test
    @Order(value=1)
    public void startClientAndServer() throws InterruptedException {
        LOGGER.info("startClientAndServer");
        LOGGER.info("Start the test server.");
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        this.internalStartClientAndServer(callback, SERVER_REQUESTOR, "BiDiB-Client-Test");
        ((Consumer)Mockito.verify((Object)callback, (VerificationMode)Mockito.atLeastOnce())).accept("established");
    }

    @Test
    @Order(value=2)
    public void startClientAndServerAccessDenied() throws InterruptedException {
        LOGGER.info("startClientAndServerAccessDenied");
        LOGGER.info("Start the test server.");
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        this.internalStartClientAndServer(callback, SERVER_REQUESTOR, "WrongBidib");
        ((Consumer)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).accept("established");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStartClientAndServer(final Consumer<String> callback, String serverRequestor, final String clientRequestor) throws InterruptedException {
        String pairingStorePath = new File(OUTPUT_TARGET_DIR).getAbsolutePath();
        File pairingStoreFile = new File(pairingStorePath, PAIRINGSTORE_FILENAME);
        LOGGER.info("Load the data from the pairing store.");
        LocalPairingStore pairingStore = new LocalPairingStore(pairingStoreFile);
        pairingStore.load();
        NetBidibLinkData serverLinkData = new NetBidibLinkData(NetBidibLinkData.PartnerType.LOCAL);
        serverLinkData.setRequestorName(serverRequestor);
        final DefaultHostAdapter hostAdapter = new DefaultHostAdapter(message -> message.getContent());
        hostAdapter.setToBackendPublisher((BidibMessagePublisher)new BidibMessagePublisher<byte[]>(){

            public void publishBidibMessage(SequenceNumberProvider proxyNode, byte[] content) {
                LOGGER.info("Received message content: {}", (Object)ByteUtils.bytesToHex((byte[])content));
                callback.accept("established");
                if (content[3] == ByteUtils.getLowByte((int)1)) {
                    try {
                        SysMagicResponse response = new SysMagicResponse(Node.ROOTNODE_ADDR, 0, new byte[]{-2, -81});
                        LOGGER.warn("Demo only. Let the scheduler send the message to the host.");
                        Executors.newScheduledThreadPool(1).submit(() -> {
                            byte[] messageContent = response.getContent();
                            LOGGER.warn("Publish message back to host: {}", (Object)ByteUtils.bytesToHex((byte[])messageContent));
                            hostAdapter.getToGuestPublisher().publishBidibMessage(proxyNode, (Object)messageContent);
                        });
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Send sysMagic response failed.", (Throwable)ex);
                    }
                } else {
                    LOGGER.warn("Discard message: {}", (Object)ByteUtils.bytesToHex((byte[])content));
                }
            }
        });
        RoleTypeEnum roleType = RoleTypeEnum.INTERFACE;
        NetBidibLinkData pairedPartner = new NetBidibLinkData(NetBidibLinkData.PartnerType.REMOTE);
        pairedPartner.setPairingStatus(NetBidibLinkData.PairingStatus.UNKNOWN);
        pairedPartner.setLogonStatus(NetBidibLinkData.LogonStatus.LOGGED_OFF);
        NetBidibServerByteArray netBidibServer = new NetBidibServerByteArray("localhost", 62875, (HostAdapter)hostAdapter, "COM14", serverLinkData, roleType, pairedPartner, (PairingStore)pairingStore){
            final /* synthetic */ PairingStore val$pairingStore;
            {
                this.val$pairingStore = pairingStore;
                super(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
            }

            protected NetBidibServerHandler<byte[]> createNetBidibServerHandler(ChannelGroup channelGroup, NetBidibLinkData serverLinkData, HostAdapter<byte[]> hostAdapter, String backendPortName, Consumer<NetBidibServerHandler<byte[]>> lazyInitializationCallback, RoleTypeEnum roleType, NetBidibLinkData pairedPartner) {
                NetBidibServerHandler netBidibServerHandler = super.createNetBidibServerHandler(channelGroup, serverLinkData, hostAdapter, backendPortName, lazyInitializationCallback, roleType, pairedPartner);
                netBidibServerHandler.pairedPartner = new NetBidibLinkData(NetBidibLinkData.PartnerType.REMOTE);
                netBidibServerHandler.pairedPartner.setLogonStatus(NetBidibLinkData.LogonStatus.LOGGED_ON);
                netBidibServerHandler.setPairingStore(this.val$pairingStore);
                return netBidibServerHandler;
            }
        };
        try {
            LOGGER.info("Start the server.");
            netBidibServer.startServer();
            LOGGER.info("Wait for server startup.");
            Thread.sleep(2000L);
            LOGGER.info("Bootstrap the client.");
            NioEventLoopGroup group = new NioEventLoopGroup();
            try {
                Bootstrap clientBootstrap = new Bootstrap();
                clientBootstrap.group((EventLoopGroup)group);
                clientBootstrap.channel(NioSocketChannel.class);
                clientBootstrap.remoteAddress((SocketAddress)new InetSocketAddress("localhost", 62875));
                clientBootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                    protected void initChannel(SocketChannel socketChannel) throws Exception {
                        NetBidibClientHandler netBidibClientHandler = new NetBidibClientHandler();
                        netBidibClientHandler.setClientRequestor(clientRequestor);
                        socketChannel.pipeline().addLast(new ChannelHandler[]{netBidibClientHandler});
                    }
                });
                LOGGER.info("Connect to server.");
                ChannelFuture channelFuture = clientBootstrap.connect().sync();
                channelFuture.channel().closeFuture().sync();
            }
            catch (Exception ex) {
                LOGGER.warn("Connect to server failed.", (Throwable)ex);
            }
            finally {
                try {
                    group.shutdownGracefully().sync();
                }
                catch (Exception ex) {
                    LOGGER.warn("Shutdown group failed.", (Throwable)ex);
                }
            }
        }
        finally {
            LOGGER.info("Wait a second.");
            Thread.sleep(1000L);
            LOGGER.info("Stop the server.");
            netBidibServer.stop();
            LOGGER.info("After shutdown of server.");
            Thread.sleep(1000L);
        }
        LOGGER.info("Finished.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        LOGGER.info("Start the test server.");
        NetBidibLinkData serverLinkData = new NetBidibLinkData(NetBidibLinkData.PartnerType.LOCAL);
        serverLinkData.setProtocolVersion(ProtocolVersion.VERSION_0_8);
        RxtxSerialHostAdapter hostAdapter = new RxtxSerialHostAdapter(message -> message.getContent());
        RoleTypeEnum roleType = RoleTypeEnum.INTERFACE;
        NetBidibLinkData pairedPartner = new NetBidibLinkData(NetBidibLinkData.PartnerType.REMOTE);
        pairedPartner.setPairingStatus(NetBidibLinkData.PairingStatus.UNKNOWN);
        pairedPartner.setLogonStatus(NetBidibLinkData.LogonStatus.LOGGED_OFF);
        NetBidibServerByteArray netBidibServer = new NetBidibServerByteArray("localhost", 62875, (HostAdapter)hostAdapter, "COM14", serverLinkData, roleType, pairedPartner);
        netBidibServer.setShutdownHook(new Thread(() -> RxtxNetBidibServerTest.lambda$main$2((NetBidibServer)netBidibServer)));
        Runtime.getRuntime().addShutdownHook(netBidibServer.getShutdownHook());
        netBidibServer.startServer();
        LOGGER.info("Wait for server startup.");
        try {
            Object shutdownLock;
            Thread.sleep(500L);
            LOGGER.info("Wait for shutdown.");
            Object object = shutdownLock = netBidibServer.getShutdownLock();
            synchronized (object) {
                shutdownLock.wait();
            }
        }
        finally {
            try {
                netBidibServer.stop();
            }
            catch (Exception ex) {
                LOGGER.warn("Stop the netBidibServer failed.", (Throwable)ex);
            }
        }
    }

    private static /* synthetic */ void lambda$main$2(NetBidibServer netBidibServer) {
        LOGGER.info("Run shutdown hook.");
        try {
            netBidibServer.stop();
        }
        catch (Exception ex) {
            LOGGER.warn("Stop the netBidibServer failed.", (Throwable)ex);
        }
    }
}

